/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.chiseling;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.rechiseled.chiseling.ChiselingEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class ChiselingRecipe {
    private final ResourceLocation recipeId;
    final ResourceLocation parentRecipeId;
    private final List<ChiselingEntry> entries;

    private ChiselingRecipe(ResourceLocation recipeId, ResourceLocation parentRecipeId, List<ChiselingEntry> entries) {
        this.recipeId = recipeId;
        this.parentRecipeId = parentRecipeId;
        this.entries = new ArrayList<ChiselingEntry>(entries);
    }

    public List<ChiselingEntry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    void addEntries(List<ChiselingEntry> entries) {
        this.entries.addAll(entries);
    }

    public boolean contains(ItemStack stack) {
        for (ChiselingEntry entry : this.entries) {
            if ((!entry.hasRegularItem() || entry.getRegularItem() != stack.m_41720_()) && (!entry.hasConnectingItem() || entry.getConnectingItem() != stack.m_41720_())) continue;
            return true;
        }
        return false;
    }

    public ResourceLocation getRecipeId() {
        return this.recipeId;
    }

    public static class Serializer {
        public static ChiselingRecipe fromJson(ResourceLocation resourceLocation, JsonObject json) {
            ResourceLocation parentRecipe;
            ArrayList<ChiselingEntry> chiselingEntries = new ArrayList<ChiselingEntry>();
            String parentRecipeString = GsonHelper.m_13851_((JsonObject)json, (String)"parent", null);
            ResourceLocation resourceLocation2 = parentRecipe = parentRecipeString == null ? null : new ResourceLocation(parentRecipeString);
            if (!GsonHelper.m_13885_((JsonObject)json, (String)"entries")) {
                throw new JsonParseException("Recipe must have an 'entries' array!");
            }
            JsonArray array = GsonHelper.m_13933_((JsonObject)json, (String)"entries");
            for (JsonElement element : array) {
                Item connectingItem;
                Item regularItem;
                if (!element.isJsonObject()) {
                    throw new JsonParseException("Recipe entries must be json objects with 'item' and 'connecting_item' keys!");
                }
                JsonObject object = element.getAsJsonObject();
                if (!object.has("item") && !object.has("connecting_item")) {
                    throw new JsonParseException("Recipe entry must be have at least one of 'item' or 'connecting_item' keys!");
                }
                boolean optional = GsonHelper.m_13855_((JsonObject)object, (String)"optional", (boolean)false);
                String regularItemName = GsonHelper.m_13851_((JsonObject)object, (String)"item", (String)"");
                if (regularItemName.isEmpty()) {
                    regularItem = null;
                } else {
                    regularItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(regularItemName));
                    if (regularItem == null && !optional) {
                        throw new JsonParseException("Unknown item '" + regularItemName + "'");
                    }
                }
                String connectingItemName = GsonHelper.m_13851_((JsonObject)object, (String)"connecting_item", (String)"");
                if (connectingItemName.isEmpty()) {
                    connectingItem = null;
                } else {
                    connectingItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(connectingItemName));
                    if (connectingItem == null && !optional) {
                        throw new JsonParseException("Unknown item '" + connectingItemName + "'");
                    }
                }
                if (regularItem == null && connectingItem == null) {
                    throw new JsonParseException("Recipe entry must be have at least one of 'item' or 'connecting_item' keys!");
                }
                chiselingEntries.add(new ChiselingEntry(regularItem, connectingItem));
            }
            return new ChiselingRecipe(resourceLocation, parentRecipe, chiselingEntries);
        }

        public static ChiselingRecipe fromNetwork(FriendlyByteBuf buffer) {
            ArrayList<ChiselingEntry> chiselingEntries = new ArrayList<ChiselingEntry>();
            ResourceLocation recipeId = buffer.m_130281_();
            int entries = buffer.readInt();
            for (int i = 0; i < entries; ++i) {
                chiselingEntries.add(new ChiselingEntry(buffer.readBoolean() ? Item.m_41445_((int)buffer.m_130242_()) : null, buffer.readBoolean() ? Item.m_41445_((int)buffer.m_130242_()) : null));
            }
            return new ChiselingRecipe(recipeId, null, chiselingEntries);
        }

        public static void toNetwork(FriendlyByteBuf buffer, ChiselingRecipe recipe) {
            buffer.m_130085_(recipe.recipeId);
            buffer.writeInt(recipe.entries.size());
            for (ChiselingEntry entry : recipe.entries) {
                buffer.writeBoolean(entry.getRegularItem() != null);
                if (entry.getRegularItem() != null) {
                    buffer.m_130130_(Item.m_41393_((Item)entry.getRegularItem()));
                }
                buffer.writeBoolean(entry.getConnectingItem() != null);
                if (entry.getConnectingItem() == null) continue;
                buffer.m_130130_(Item.m_41393_((Item)entry.getConnectingItem()));
            }
        }
    }
}

