/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.general_features.cave;

import com.legacy.blue_skies.data.objects.tags.SkiesStructureTags;
import com.legacy.blue_skies.world.general_features.IStructureRestricted;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public abstract class AbstractCaveFeature<FC extends FeatureConfiguration>
extends Feature<FC>
implements IStructureRestricted {
    public AbstractCaveFeature(Codec<FC> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<FC> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        ChunkGenerator chunkGen = context.m_159775_();
        FeatureConfiguration config = context.m_159778_();
        int surfaceY = level.m_46865_(pos).m_5885_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_());
        if (this.isValidPos(level, chunkGen, level.m_5822_(), pos, config) && pos.m_123342_() + this.getMaxHeight(config) < surfaceY - 5 && this.shouldGenerate(level, pos)) {
            return this.generate(level, chunkGen, level.m_5822_(), pos, config);
        }
        return false;
    }

    public abstract boolean generate(WorldGenLevel var1, ChunkGenerator var2, Random var3, BlockPos var4, FC var5);

    public abstract boolean isValidPos(WorldGenLevel var1, ChunkGenerator var2, Random var3, BlockPos var4, FC var5);

    public int getMaxHeight(FC config) {
        return 2;
    }

    @Override
    public TagKey<ConfiguredStructureFeature<?, ?>> disallowedStructures() {
        return SkiesStructureTags.ON_POISON_MAPS;
    }
}

