/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright.gen.structures.blinding_dungeon;

import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.world.everbright.gen.structures.blinding_dungeon.EverbrightBlindingDungeonPieces;
import com.legacy.blue_skies.world.general_features.structures.BlindingDungeonStructure;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class EverbrightBlindingDungeonStructure
extends BlindingDungeonStructure {
    public EverbrightBlindingDungeonStructure(Codec<NoneFeatureConfiguration> config) {
        super(config, EverbrightBlindingDungeonStructure::farFromDungeon, (PieceGenerator<NoneFeatureConfiguration>)((PieceGenerator)EverbrightBlindingDungeonStructure::generatePieces));
    }

    private static boolean farFromDungeon(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context) {
        ChunkPos pos = context.f_197355_();
        Optional key = SkiesStructures.NATURE_DUNGEON.getStructureSet().m_203543_();
        if (key.isPresent()) {
            return !context.f_197352_().m_212265_((ResourceKey)key.get(), context.f_197354_(), pos.f_45578_, pos.f_45579_, 10);
        }
        return true;
    }

    private static void generatePieces(StructurePiecesBuilder builder, PieceGenerator.Context<NoneFeatureConfiguration> context) {
        ChunkPos chunkPos = context.f_192705_();
        Rotation rotation = Rotation.values()[context.f_192708_().nextInt(Rotation.values().length)];
        int y = BlindingDungeonStructure.getHeighestY(context.f_192707_(), context.f_192703_(), chunkPos.f_45578_, chunkPos.f_45579_);
        if (y < 150 && y >= 60) {
            EverbrightBlindingDungeonPieces.assemble(context.f_192704_(), new BlockPos(chunkPos.f_45578_ * 16 + 8, y, chunkPos.f_45579_ * 16 + 8), rotation, builder, (Random)context.f_192708_());
        }
    }

    public int getSpacing() {
        return 45;
    }

    public int getOffset() {
        return this.getSpacing() - 14;
    }

    public float getProbability() {
        return 0.75f;
    }
}

