/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile.boss;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.legacy.blue_skies.blocks.dungeon.SkyDecayingSpikeBlock;
import com.legacy.blue_skies.blocks.misc.TrophyBlock;
import com.legacy.blue_skies.entities.hostile.boss.summons.DecayingSpikeEntity;
import com.legacy.blue_skies.entities.projectile.SpearEntity;
import com.legacy.blue_skies.entities.util.SkiesDungeonType;
import com.legacy.blue_skies.entities.util.base.SkiesIllagerBossEntity;
import com.legacy.blue_skies.entities.util.interfaces.ISkyBoss;
import com.legacy.blue_skies.items.LootBagItem;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesParticles;
import com.legacy.blue_skies.registries.SkiesSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

public class AlchemistEntity
extends SkiesIllagerBossEntity {
    private static final Set<MobEffect> IMMUNE_EFFECTS = ImmutableSet.of((Object)MobEffects.f_19614_, (Object)MobEffects.f_19602_, (Object)MobEffects.f_19615_, (Object)MobEffects.f_19620_, (Object)MobEffects.f_19597_);
    protected List<BlockPos> fluidConversionList = new ArrayList<BlockPos>();
    protected boolean isConvertingToWater = true;

    public AlchemistEntity(EntityType<? extends AlchemistEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new RegenGoal());
        this.f_21345_.m_25352_(4, (Goal)new LiquidConversionGoal());
        this.f_21345_.m_25352_(5, (Goal)new FireArrowBundleGoal());
        this.f_21345_.m_25352_(5, (Goal)new DecayingSpikeGoal());
        this.f_21345_.m_25352_(5, (Goal)new PotionCloudGoal());
        this.f_21345_.m_25352_(5, (Goal)new BlindlessGoal());
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21345_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21345_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21345_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 500.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22279_, 0.5);
    }

    @Override
    public double getBossHealth() {
        return 500.0 + (double)this.getExtraPlayers() * 150.0;
    }

    @Override
    public float getHealAmount() {
        return 40.0f;
    }

    @Override
    public LootBagItem getLootBag() {
        return SkiesItems.loot_bag_alchemist;
    }

    @Override
    public TrophyBlock getTrophy() {
        return SkiesBlocks.alchemist_trophy;
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    public Pair<DyeColor, DyeColor> getFireworkColors() {
        return Pair.of((Object)DyeColor.RED, (Object)DyeColor.YELLOW);
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return IMMUNE_EFFECTS.contains(effect.m_19544_()) ? false : super.m_7301_(effect);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7640_() instanceof AreaEffectCloud || source.m_7640_() instanceof ThrownPotion) {
            return false;
        }
        Entity entity = source.m_7640_();
        if (entity instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)entity;
            if (!(source.m_7640_() instanceof ThrownTrident) && !(source.m_7640_() instanceof SpearEntity)) {
                return false;
            }
        }
        return super.m_6469_(source, amount);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void healthParticles() {
        if (this.secondPhaseHealth()) {
            double dx = this.f_19796_.nextGaussian() * 0.02;
            double dy = this.f_19796_.nextGaussian() * 0.02;
            double dz = this.f_19796_.nextGaussian() * 0.02;
            this.f_19853_.m_7106_((ParticleOptions)SkiesParticles.BLACK_FLAME, this.m_20185_() + (double)(this.f_19796_.nextFloat() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + (double)(this.f_19796_.nextFloat() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.nextFloat() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), dx, dy, dz);
        } else {
            this.spawnParticles((ParticleOptions)ParticleTypes.f_123810_);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
    }

    @Override
    public void invulnerableTick() {
        if (this.f_19853_.f_46443_) {
            double d0 = 0.05;
            this.f_19853_.m_6493_((ParticleOptions)ParticleTypes.f_123810_, true, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.5, 0.0);
            this.f_19853_.m_6493_((ParticleOptions)ParticleTypes.f_123810_, true, this.m_20185_(), this.m_20186_() + 4.0, this.m_20189_(), d0, -0.4, d0);
            this.f_19853_.m_6493_((ParticleOptions)ParticleTypes.f_123810_, true, this.m_20185_(), this.m_20186_() + 4.0, this.m_20189_(), d0, -0.4, -d0);
            this.f_19853_.m_6493_((ParticleOptions)ParticleTypes.f_123810_, true, this.m_20185_(), this.m_20186_() + 4.0, this.m_20189_(), -d0, -0.4, d0);
            this.f_19853_.m_6493_((ParticleOptions)ParticleTypes.f_123810_, true, this.m_20185_(), this.m_20186_() + 4.0, this.m_20189_(), -d0, -0.4, -d0);
        }
    }

    public void attackEntityWithRangedAttack(LivingEntity target, float distanceFactor) {
        double d3;
        double d2;
        double d1;
        double d0;
        Arrow entityarrow;
        int i;
        for (i = 0; i < 3; ++i) {
            entityarrow = this.createArrowEntity(distanceFactor);
            d0 = target.m_20185_() - this.m_20185_();
            d1 = target.m_142469_().f_82289_ + (double)(target.m_20206_() / 3.0f) - entityarrow.m_20186_();
            d2 = target.m_20189_() - this.m_20189_();
            d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
            entityarrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2 + (double)(4 * i - 4), 1.6f, (float)(14 - this.getDifficultyID() * 4));
            this.m_5496_(SoundEvents.f_11687_, 1.0f, 1.0f / (this.m_21187_().nextFloat() * 0.4f + 0.8f));
            this.f_19853_.m_7967_((Entity)entityarrow);
        }
        if (this.secondPhaseHealth()) {
            for (i = 0; i < 3; ++i) {
                entityarrow = this.createArrowEntity(distanceFactor);
                entityarrow.m_20254_(7);
                d0 = target.m_20185_() - this.m_20185_();
                d1 = target.m_142469_().f_82289_ + (double)(target.m_20206_() / 3.0f) - entityarrow.m_20186_() - 1.0;
                d2 = target.m_20189_() - this.m_20189_();
                d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
                entityarrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2 + (double)(4 * i - 4), 1.6f, (float)(14 - this.getDifficultyID() * 4));
                this.m_5496_(SoundEvents.f_11687_, 1.0f, 1.0f / (this.m_21187_().nextFloat() * 0.4f + 0.8f));
                this.f_19853_.m_7967_((Entity)entityarrow);
            }
        }
    }

    protected Arrow createArrowEntity(float distanceFactor) {
        Arrow arrow = new Arrow(this.f_19853_, (LivingEntity)this);
        arrow.m_36745_((LivingEntity)this, distanceFactor);
        arrow.m_36781_(3.0);
        if (this.secondPhaseHealth()) {
            if (this.getDifficultyID() >= ISkyBoss.BossLevel.GOLD.getId() && this.f_19796_.nextInt(5) == 0) {
                arrow.m_36870_(new MobEffectInstance(MobEffects.f_19597_, 100));
            }
            arrow.m_36781_(5.0);
        } else {
            arrow.m_36781_(3.0);
        }
        arrow.m_36735_(1);
        return arrow;
    }

    protected SoundEvent m_7515_() {
        return SkiesSounds.ENTITY_ALCHEMIST_IDLE;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SkiesSounds.ENTITY_ALCHEMIST_HURT;
    }

    protected SoundEvent m_5592_() {
        return SkiesSounds.ENTITY_ALCHEMIST_DEATH;
    }

    protected float m_6121_() {
        return 1.5f;
    }

    public float m_6100_() {
        return (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.1f + 1.0f;
    }

    @Override
    public BlockState getFloorState() {
        return SkiesBlocks.lunar_stonebrick.m_49966_();
    }

    public SoundEvent m_7930_() {
        return SkiesSounds.ENTITY_ALCHEMIST_CELEBRATE;
    }

    protected SoundEvent m_7894_() {
        return SkiesSounds.ENTITY_ALCHEMIST_CAST_SPELL;
    }

    @Override
    public SkiesDungeonType getBossType() {
        return SkiesDungeonType.BLINDING;
    }

    @Override
    public int getProgression() {
        return 1;
    }

    @Override
    public boolean isEverbrightBoss() {
        return false;
    }

    @Override
    public BossEvent.BossBarColor getBossBarColor() {
        return BossEvent.BossBarColor.RED;
    }

    public class RegenGoal
    extends SkiesIllagerBossEntity.UseBossSpellGoal {
        private AlchemistEntity boss;

        public RegenGoal() {
            super(AlchemistEntity.this);
            this.boss = AlchemistEntity.this;
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && this.boss.isAwayFromPlayers() && this.boss.secondPhaseHealth() && this.boss.getInvulTime() <= 0;
        }

        public void m_8041_() {
            super.m_8041_();
        }

        protected void m_8130_() {
            int extraPlayers = Math.min(4, this.boss.getExtraPlayers());
            this.boss.m_7292_(new MobEffectInstance(MobEffects.f_19605_, (this.boss.getDifficultyID() == ISkyBoss.BossLevel.BRONZE.getId() ? 18 : 20) + extraPlayers * 5, 5, false, false));
        }

        protected int m_8069_() {
            return 20;
        }

        protected int m_8089_() {
            return this.boss.getDifficultyID() >= ISkyBoss.BossLevel.GOLD.getId() ? 60 : 70;
        }

        protected int m_8067_() {
            int extraPlayers = Math.min(7, this.boss.getExtraPlayers());
            return 360 + extraPlayers * 20;
        }

        protected SoundEvent m_7030_() {
            return SkiesSounds.ENTITY_ALCHEMIST_PREPARE_REGEN;
        }

        @Override
        protected SkiesIllagerBossEntity.BossSpellColor getSpellColor() {
            return SkiesIllagerBossEntity.BossSpellColor.REGENERATION;
        }
    }

    public class LiquidConversionGoal
    extends SkiesIllagerBossEntity.UseBossSpellGoal {
        private AlchemistEntity boss;
        public boolean shouldPlaceWater;
        private int waterAmount;
        private int lavaAmount;

        public LiquidConversionGoal() {
            super(AlchemistEntity.this);
            this.boss = AlchemistEntity.this;
            this.waterAmount = 0;
            this.lavaAmount = 0;
        }

        @Override
        public boolean m_8036_() {
            return this.boss.secondPhaseHealth() && this.boss.isAwayFromPlayers() && this.boss.getInvulTime() <= 0 && super.m_8036_() && (this.boss.f_19796_.nextBoolean() || this.boss.m_5448_() != null && this.boss.m_5448_().m_20094_() > 0);
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            int radius = 15;
            BlockPos pos = this.boss.getHome();
            BlockPos min = pos.m_142082_(-radius, -radius, -radius);
            BlockPos max = pos.m_142082_(radius, radius, radius);
            for (BlockPos posAround : BlockPos.m_121940_((BlockPos)min, (BlockPos)max)) {
                BlockState state = this.boss.f_19853_.m_8055_(posAround);
                if (state.m_60734_() != Blocks.f_50080_ && (state.m_60734_() != Blocks.f_49991_ && state.m_60734_() != Blocks.f_49990_ || (Integer)state.m_61143_((Property)LiquidBlock.f_54688_) != 0)) continue;
                this.boss.fluidConversionList.add(new BlockPos((Vec3i)posAround));
                if (state.m_60734_() == Blocks.f_49991_) {
                    ++this.lavaAmount;
                    continue;
                }
                if (state.m_60734_() != Blocks.f_49990_) continue;
                ++this.waterAmount;
            }
            if (this.waterAmount > this.lavaAmount) {
                this.boss.setBossSpellType(SkiesIllagerBossEntity.BossSpellColor.LAVA);
            } else {
                this.boss.setBossSpellType(SkiesIllagerBossEntity.BossSpellColor.WATER);
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.waterAmount = 0;
            this.lavaAmount = 0;
            this.boss.fluidConversionList.clear();
        }

        protected void m_8130_() {
            if (!this.boss.fluidConversionList.isEmpty()) {
                this.boss.fluidConversionList.forEach(fluidPos -> {
                    if (this.waterAmount > this.lavaAmount) {
                        this.boss.f_19853_.m_46597_(fluidPos, Blocks.f_49991_.m_49966_());
                    } else {
                        this.boss.f_19853_.m_46597_(fluidPos, Blocks.f_49990_.m_49966_());
                    }
                });
                this.waterAmount = 0;
                this.lavaAmount = 0;
                this.boss.fluidConversionList.clear();
            }
        }

        @Override
        public void m_8037_() {
            if (this.f_33774_ == 1) {
                int radius = 15;
                BlockPos pos = this.boss.getHome();
                BlockPos min = pos.m_142082_(-radius, -radius, -radius);
                BlockPos max = pos.m_142082_(radius, radius, radius);
                for (BlockPos posAround : BlockPos.MutableBlockPos.m_121940_((BlockPos)min, (BlockPos)max)) {
                    BlockState state = this.boss.f_19853_.m_8055_(posAround);
                    if (state.m_60734_() != Blocks.f_49991_ && state.m_60734_() != Blocks.f_49990_) continue;
                    this.boss.f_19853_.m_46597_(posAround, Blocks.f_50016_.m_49966_());
                }
            }
            super.m_8037_();
        }

        protected int m_8069_() {
            return 30;
        }

        protected int m_8089_() {
            return this.boss.getDifficultyID() == ISkyBoss.BossLevel.BRONZE.getId() ? 70 : 60;
        }

        protected int m_8067_() {
            return 90;
        }

        protected SoundEvent m_7030_() {
            return SkiesSounds.ENTITY_ALCHEMIST_PREPARE_CONVERSION;
        }

        @Override
        protected SkiesIllagerBossEntity.BossSpellColor getSpellColor() {
            if (this.waterAmount > this.lavaAmount) {
                return SkiesIllagerBossEntity.BossSpellColor.LAVA;
            }
            return SkiesIllagerBossEntity.BossSpellColor.WATER;
        }
    }

    class FireArrowBundleGoal
    extends SkiesIllagerBossEntity.UseBossSpellGoal {
        private AlchemistEntity boss;

        private FireArrowBundleGoal() {
            super(AlchemistEntity.this);
            this.boss = AlchemistEntity.this;
        }

        protected int m_8089_() {
            return this.boss.getDifficultyID() == ISkyBoss.BossLevel.BRONZE.getId() ? 50 : 40;
        }

        protected int m_8067_() {
            return 200;
        }

        protected int m_8069_() {
            return this.boss.getDifficultyID() == ISkyBoss.BossLevel.BRONZE.getId() ? 25 : 20;
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && this.boss.isAwayFromPlayers() && this.boss.getInvulTime() <= 0;
        }

        protected void m_8130_() {
            LivingEntity entitylivingbase = this.boss.m_5448_();
            if (entitylivingbase != null) {
                this.boss.attackEntityWithRangedAttack(entitylivingbase, BowItem.m_40661_((int)40));
            }
        }

        protected SoundEvent m_7030_() {
            return SkiesSounds.ENTITY_ALCHEMIST_PREPARE_ATTACK;
        }

        @Override
        protected SkiesIllagerBossEntity.BossSpellColor getSpellColor() {
            return SkiesIllagerBossEntity.BossSpellColor.ARROW_BUNDLE;
        }
    }

    class DecayingSpikeGoal
    extends SkiesIllagerBossEntity.UseBossSpellGoal {
        private AlchemistEntity boss;

        private DecayingSpikeGoal() {
            super(AlchemistEntity.this);
            this.boss = AlchemistEntity.this;
        }

        protected int m_8069_() {
            return this.boss.getDifficultyID() == ISkyBoss.BossLevel.GOLD.getId() ? 15 : (this.boss.getDifficultyID() >= ISkyBoss.BossLevel.PLATINUM.getId() ? 10 : 20);
        }

        protected int m_8089_() {
            return 60;
        }

        protected int m_8067_() {
            return 270;
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && this.boss.isAwayFromPlayers() && this.boss.getInvulTime() <= 0;
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
        }

        protected void m_8130_() {
            LivingEntity target = this.boss.m_5448_();
            double d0 = Math.min(target.m_20186_(), this.boss.m_20186_());
            double d1 = Math.max(target.m_20186_(), this.boss.m_20186_()) + 1.0;
            float f = (float)Mth.m_14136_((double)(target.m_20189_() - this.boss.m_20189_()), (double)(target.m_20185_() - this.boss.m_20185_()));
            if ((double)this.boss.m_20270_((Entity)target) < 5.0 || this.boss.f_19853_.m_45924_(this.boss.m_20185_(), this.boss.m_20186_(), this.boss.m_20189_(), 5.0, true) != null && (double)this.boss.m_20270_((Entity)this.boss.f_19853_.m_45924_(this.boss.m_20185_(), this.boss.m_20186_(), this.boss.m_20189_(), 5.0, true)) < 5.0) {
                for (int k = 0; k < 8; ++k) {
                    float f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.playSpikeParticles(this.boss.m_20185_() + (double)Mth.m_14089_((float)f2) * 2.0, this.boss.m_20186_() + 0.2, this.boss.m_20189_() + (double)Mth.m_14031_((float)f2) * 2.0, this.boss.m_20205_() / 4.0f, this.boss.m_20206_() / 4.0f, this.boss.m_20205_() / 4.0f);
                    this.spawnSpikeCircle(this.boss.m_20185_() + (double)Mth.m_14089_((float)f2) * 2.0, this.boss.m_20189_() + (double)Mth.m_14031_((float)f2) * 2.0, d0, d1);
                }
            } else {
                for (int l = 0; l < 16; ++l) {
                    double d2 = 1.25 * (double)(l + 1);
                    this.playSpikeParticles(this.boss.m_20185_() + (double)Mth.m_14089_((float)f) * d2, this.boss.m_20186_() + 5.0, this.boss.m_20189_() + (double)Mth.m_14031_((float)f) * d2, this.boss.m_20205_() / 4.0f, this.boss.m_20206_() / 4.0f, this.boss.m_20205_() / 4.0f);
                    this.spawnSpikeLine(this.boss.m_20185_() + (double)Mth.m_14089_((float)f) * d2, this.boss.m_20189_() + (double)Mth.m_14031_((float)f) * d2, d0, d1);
                }
            }
        }

        private void spawnSpikeLine(double posX, double posZ, double maxY, double posY) {
            BlockPos blockpos = new BlockPos(posX, posY, posZ);
            boolean flag = false;
            double d0 = 0.0;
            do {
                BlockState iblockstate;
                VoxelShape voxelshape;
                if (!this.boss.f_19853_.m_46859_(blockpos) || this.boss.f_19853_.m_46859_(blockpos.m_7495_())) continue;
                if (!this.boss.f_19853_.m_46859_(blockpos) && (voxelshape = (iblockstate = this.boss.f_19853_.m_8055_(blockpos)).m_60812_((BlockGetter)this.boss.f_19853_, blockpos)) != null) {
                    d0 = voxelshape.m_83297_(Direction.Axis.Y);
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)maxY) - 1);
            if (flag) {
                BlockPos blockpos2 = new BlockPos(posX, (double)blockpos.m_123342_() + d0 + 5.0, posZ);
                DecayingSpikeEntity block = new DecayingSpikeEntity(this.boss.f_19853_, blockpos2, SkiesBlocks.decaying_spike.m_49966_(), (LivingEntity)this.boss);
                block.setDownwards(true);
                block.f_31942_ = 200;
                block.f_31943_ = false;
                this.boss.f_19853_.m_7967_((Entity)block);
            }
        }

        private void spawnSpikeCircle(double posX, double posZ, double maxY, double posY) {
            BlockPos blockpos = new BlockPos(posX, posY, posZ);
            boolean flag = false;
            double d0 = 0.0;
            do {
                BlockState iblockstate;
                VoxelShape voxelshape;
                if (!this.boss.f_19853_.m_46859_(blockpos) || this.boss.f_19853_.m_46859_(blockpos.m_7495_())) continue;
                if (!this.boss.f_19853_.m_46859_(blockpos) && (voxelshape = (iblockstate = this.boss.f_19853_.m_8055_(blockpos)).m_60812_((BlockGetter)this.boss.f_19853_, blockpos)) != null) {
                    d0 = voxelshape.m_83297_(Direction.Axis.Y);
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)maxY) - 1);
            if (flag) {
                BlockPos blockpos2 = new BlockPos((double)blockpos.m_123341_() + d0, (double)blockpos.m_123342_() + d0, (double)blockpos.m_123343_() + d0);
                DecayingSpikeEntity block = new DecayingSpikeEntity(this.boss.f_19853_, blockpos2, (BlockState)SkiesBlocks.decaying_spike.m_49966_().m_61124_((Property)SkyDecayingSpikeBlock.DOWNWARD, (Comparable)Boolean.valueOf(false)), (LivingEntity)this.boss);
                block.setDownwards(false);
                block.m_6034_((double)blockpos2.m_123341_() + 0.5, blockpos2.m_123342_(), (double)blockpos2.m_123343_() + 0.5);
                block.f_31942_ = 200;
                block.m_20334_(0.0, 0.7, 0.0);
                block.f_31943_ = false;
                this.boss.f_19853_.m_7967_((Entity)block);
            }
        }

        @Override
        public void m_8037_() {
            block4: {
                super.m_8037_();
                LivingEntity target = this.boss.m_5448_();
                if (target == null || this.boss.f_19797_ % 5 != 0) break block4;
                float f = (float)Mth.m_14136_((double)(target.m_20189_() - this.boss.m_20189_()), (double)(target.m_20185_() - this.boss.m_20185_()));
                if ((double)this.boss.m_20270_((Entity)target) < 5.0 || this.boss.f_19853_.m_45924_(this.boss.m_20185_(), this.boss.m_20186_(), this.boss.m_20189_(), 5.0, true) != null && (double)this.boss.m_20270_((Entity)this.boss.f_19853_.m_45924_(this.boss.m_20185_(), this.boss.m_20186_(), this.boss.m_20189_(), 5.0, true)) < 5.0) {
                    for (int k = 0; k < 8; ++k) {
                        float f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                        this.playSpikeParticles(this.boss.m_20185_() + (double)Mth.m_14089_((float)f2) * 2.0, this.boss.m_20186_() + 0.2, this.boss.m_20189_() + (double)Mth.m_14031_((float)f2) * 2.0, this.boss.m_20205_() / 4.0f, this.boss.m_20206_() / 4.0f, this.boss.m_20205_() / 4.0f);
                    }
                } else {
                    for (int l = 0; l < 16; ++l) {
                        double d2 = 1.25 * (double)(l + 1);
                        this.playSpikeParticles(this.boss.m_20185_() + (double)Mth.m_14089_((float)f) * d2, this.boss.m_20186_() + 5.0, this.boss.m_20189_() + (double)Mth.m_14031_((float)f) * d2, this.boss.m_20205_() / 4.0f, this.boss.m_20206_() / 4.0f, this.boss.m_20205_() / 4.0f);
                    }
                }
            }
        }

        private void playSpikeParticles(double posX, double posY, double posZ, double offsetX, double offsetY, double offsetZ) {
            int count = 20;
            if (this.boss.f_19853_ instanceof ServerLevel) {
                ((ServerLevel)this.boss.f_19853_).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, SkiesBlocks.decaying_spike.m_49966_()), posX, posY, posZ, count, offsetX, offsetY, offsetZ, 0.05);
            }
        }

        protected SoundEvent m_7030_() {
            return SkiesSounds.ENTITY_ALCHEMIST_PREPARE_ROCKS;
        }

        @Override
        protected SkiesIllagerBossEntity.BossSpellColor getSpellColor() {
            return SkiesIllagerBossEntity.BossSpellColor.ROCKS;
        }
    }

    class PotionCloudGoal
    extends SkiesIllagerBossEntity.UseBossSpellGoal {
        private AlchemistEntity boss;

        private PotionCloudGoal() {
            super(AlchemistEntity.this);
            this.boss = AlchemistEntity.this;
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && AlchemistEntity.this.isAwayFromPlayers() && AlchemistEntity.this.getInvulTime() <= 0 && this.boss.f_19796_.nextBoolean();
        }

        protected int m_8089_() {
            return this.boss.getDifficultyID() == ISkyBoss.BossLevel.BRONZE.getId() ? 85 : 70;
        }

        protected int m_8067_() {
            return 300;
        }

        protected void m_8130_() {
            if (this.boss.m_5448_() != null) {
                this.spawnClouds();
            }
        }

        private void spawnClouds() {
            BlockPos pos = this.boss.isDungeonSpawned() ? this.boss.getHome() : this.boss.m_142538_();
            AreaEffectCloud potionCloudPX = new AreaEffectCloud(this.boss.f_19853_, (double)(pos.m_123341_() + 5), (double)pos.m_123342_(), (double)(pos.m_123343_() + 5));
            AreaEffectCloud potionCloudPZ = new AreaEffectCloud(this.boss.f_19853_, (double)(pos.m_123341_() + 5), (double)pos.m_123342_(), (double)(pos.m_123343_() - 5));
            AreaEffectCloud potionCloudNX = new AreaEffectCloud(this.boss.f_19853_, (double)(pos.m_123341_() - 5), (double)pos.m_123342_(), (double)(pos.m_123343_() + 5));
            AreaEffectCloud potionCloudNZ = new AreaEffectCloud(this.boss.f_19853_, (double)(pos.m_123341_() - 5), (double)pos.m_123342_(), (double)(pos.m_123343_() - 5));
            Potion potiontype = this.boss.secondPhaseHealth() ? Potions.f_43582_ : Potions.f_43584_;
            ImmutableList clouds = ImmutableList.of((Object)potionCloudPX, (Object)potionCloudPZ, (Object)potionCloudNX, (Object)potionCloudNZ);
            clouds.forEach(cloud -> {
                cloud.m_19722_(potiontype);
                cloud.m_19734_(200 + (this.boss.getDifficultyID() > ISkyBoss.BossLevel.SILVER.getId() ? this.boss.getDifficultyID() * 40 : 0));
                cloud.m_19718_((LivingEntity)this.boss);
                this.boss.f_19853_.m_7967_((Entity)cloud);
            });
        }

        protected SoundEvent m_7030_() {
            return SkiesSounds.ENTITY_ALCHEMIST_PREPARE_POTIONS;
        }

        @Override
        protected SkiesIllagerBossEntity.BossSpellColor getSpellColor() {
            return this.boss.secondPhaseHealth() ? SkiesIllagerBossEntity.BossSpellColor.HARMING_CLOUD : SkiesIllagerBossEntity.BossSpellColor.POISON_CLOUD;
        }
    }

    public class BlindlessGoal
    extends SkiesIllagerBossEntity.UseBossSpellGoal {
        private AlchemistEntity boss;

        public BlindlessGoal() {
            super(AlchemistEntity.this);
            this.boss = AlchemistEntity.this;
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && this.boss.isAwayFromPlayers() && this.boss.getInvulTime() <= 0 && this.boss.f_19796_.nextBoolean();
        }

        public void m_8041_() {
            super.m_8041_();
        }

        protected void m_8130_() {
            for (Player players : this.boss.getPlayersInDungeonArea()) {
                if (players.m_7500_() || players.m_5833_()) continue;
                players.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 0));
            }
        }

        protected int m_8069_() {
            return 20;
        }

        protected int m_8089_() {
            return 60;
        }

        protected int m_8067_() {
            return 300;
        }

        protected SoundEvent m_7030_() {
            return SkiesSounds.ENTITY_ALCHEMIST_PREPARE_BLINDNESS;
        }

        @Override
        protected SkiesIllagerBossEntity.BossSpellColor getSpellColor() {
            return SkiesIllagerBossEntity.BossSpellColor.BLINDNESS;
        }
    }
}

