/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.innovation.item;

import cofh.core.capability.CapabilityAreaEffect;
import cofh.core.item.IMultiModeItem;
import cofh.core.util.ProxyUtils;
import cofh.core.util.helpers.AreaEffectHelper;
import cofh.core.util.helpers.AugmentableHelper;
import cofh.core.util.helpers.ChatHelper;
import cofh.lib.api.capability.IAreaEffectItem;
import cofh.lib.api.item.IColorableItem;
import cofh.lib.api.item.IEnergyContainerItem;
import cofh.lib.energy.EnergyContainerItemWrapper;
import cofh.lib.util.Utils;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.item.EnergyContainerItemAugmentable;
import cofh.thermal.lib.item.IFlexibleEnergyContainerItem;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class RFSawItem
extends EnergyContainerItemAugmentable
implements IColorableItem,
DyeableLeatherItem,
IMultiModeItem,
IFlexibleEnergyContainerItem {
    protected static final Set<Material> MATERIALS = new ObjectOpenHashSet();
    protected static final Set<Enchantment> VALID_ENCHANTS = new ObjectOpenHashSet();
    public static final int ENERGY_PER_USE = 200;

    public static void setupEnchants() {
        VALID_ENCHANTS.add(Enchantments.f_44984_);
        VALID_ENCHANTS.add(Enchantments.f_44985_);
        VALID_ENCHANTS.add(Enchantments.f_44987_);
    }

    public RFSawItem(Item.Properties builder, int maxEnergy, int maxTransfer) {
        super(builder, maxEnergy, maxTransfer);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("color"), (stack, world, entity, seed) -> this.m_41113_(stack) ? 1.0f : 0.0f);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("state"), (stack, world, entity, seed) -> (this.getEnergyStored(stack) > 0 ? 0.5f : 0.0f) + (this.isActive(stack) ? 0.25f : 0.0f));
        ProxyUtils.registerColorable((Item)this);
        this.numSlots = () -> ThermalCoreConfig.toolAugments;
        this.augValidator = ThermalAugmentRules.createAllowValidator((String[])new String[]{"Upgrade", "RF", "Area"});
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        int radius = this.getMode(stack) * 2 + 1;
        if (radius <= 1) {
            tooltip.add((Component)new TranslatableComponent("info.cofh.single_block").m_130940_(ChatFormatting.ITALIC));
        } else {
            tooltip.add((Component)new TranslatableComponent("info.cofh.area").m_130946_(": " + radius + "x" + radius).m_130940_(ChatFormatting.ITALIC));
        }
        if (this.getNumModes(stack) > 1) {
            this.addModeChangeTooltip(this, stack, worldIn, tooltip, flagIn);
        }
        super.tooltipDelegate(stack, worldIn, tooltip, flagIn);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || VALID_ENCHANTS.contains(enchantment);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return MATERIALS.contains(state.m_60767_()) || state.m_204336_(BlockTags.f_144280_) ? this.getEfficiency(stack) : super.m_8102_(stack, state);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlot.MAINHAND) {
            float damage = this.getAttackDamage(stack);
            float speed = this.getAttackSpeed(stack);
            if (damage != 0.0f) {
                multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)damage, AttributeModifier.Operation.ADDITION));
            }
            if (speed != 0.0f) {
                multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)speed, AttributeModifier.Operation.ADDITION));
            }
        }
        return multimap;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_AXE_ACTIONS.contains(toolAction);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        if (state.m_204336_(BlockTags.f_144280_)) {
            return TierSortingRegistry.isCorrectTierForDrops((Tier)this.getHarvestTier(stack), (BlockState)state);
        }
        return false;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker instanceof Player && !((Player)attacker).f_36077_.f_35937_) {
            this.extractEnergy(stack, this.getEnergyPerUse(stack) * 2, false);
        }
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (Utils.isServerWorld((Level)worldIn) && state.m_60800_((BlockGetter)worldIn, pos) != 0.0f && entityLiving instanceof Player && !((Player)entityLiving).f_36077_.f_35937_) {
            this.extractEnergy(stack, this.getEnergyPerUse(stack), false);
        }
        return true;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        this.setActive(stack, entity);
        return true;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        Player player = context.m_43723_();
        BlockState state = level.m_8055_(blockpos);
        ItemStack held = context.m_43722_();
        Optional<BlockState> optional = Optional.ofNullable(state.getToolModifiedState(context, ToolActions.AXE_STRIP, false));
        Optional optional1 = optional.isPresent() ? Optional.empty() : Optional.ofNullable(state.getToolModifiedState(context, ToolActions.AXE_SCRAPE, false));
        Optional optional2 = optional.isPresent() || optional1.isPresent() ? Optional.empty() : Optional.ofNullable(state.getToolModifiedState(context, ToolActions.AXE_WAX_OFF, false));
        Optional<Object> optional3 = Optional.empty();
        if (optional.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            optional3 = optional;
        } else if (optional1.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5898_(player, 3005, blockpos, 0);
            optional3 = optional1;
        } else if (optional2.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5898_(player, 3004, blockpos, 0);
            optional3 = optional2;
        }
        if (optional3.isPresent()) {
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, blockpos, held);
            }
            level.m_7731_(blockpos, (BlockState)optional3.get(), 11);
            if (player != null && !player.f_36077_.f_35937_) {
                this.extractEnergy(held, this.getEnergyPerUse(context.m_43722_()), false);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!this.hasActiveTag(stack)) {
            return;
        }
        long activeTime = stack.m_41784_().m_128454_("Active");
        if (entityIn.f_19853_.m_46467_() > activeTime) {
            stack.m_41784_().m_128473_("Active");
        }
    }

    protected void setAttributesFromAugment(ItemStack container, CompoundTag augmentData) {
        CompoundTag subTag = container.m_41737_("Properties");
        if (subTag == null) {
            return;
        }
        AugmentableHelper.setAttributeFromAugmentAdd((CompoundTag)subTag, (CompoundTag)augmentData, (String)"Radius");
        super.setAttributesFromAugment(container, augmentData);
    }

    protected boolean hasEnergy(ItemStack stack) {
        return this.getEnergyStored(stack) >= this.getEnergyPerUse(stack);
    }

    protected float getAttackDamage(ItemStack stack) {
        return this.hasEnergy(stack) ? 3.0f + this.getBaseMod(stack) : 0.0f;
    }

    protected float getAttackSpeed(ItemStack stack) {
        return this.hasEnergy(stack) ? -2.1f + this.getBaseMod(stack) / 10.0f : -3.0f;
    }

    protected float getEfficiency(ItemStack stack) {
        return this.hasEnergy(stack) ? 5.0f + this.getBaseMod(stack) : 1.0f;
    }

    protected int getEnergyPerUse(ItemStack stack) {
        return 200;
    }

    protected Tier getHarvestTier(ItemStack stack) {
        return switch (this.getHarvestLevel(stack)) {
            case 2 -> Tiers.IRON;
            case 3 -> Tiers.DIAMOND;
            case 0, 1 -> Tiers.WOOD;
            default -> Tiers.NETHERITE;
        };
    }

    protected int getHarvestLevel(ItemStack stack) {
        return this.hasEnergy(stack) ? Math.max(2, (int)this.getBaseMod(stack)) : 0;
    }

    protected int getRadius(ItemStack stack) {
        return (int)AugmentableHelper.getPropertyWithDefault((ItemStack)stack, (String)"Radius", (float)0.0f);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new RFSawItemWrapper(stack, (IEnergyContainerItem)this);
    }

    public void updateAugmentState(ItemStack container, List<ItemStack> augments) {
        super.updateAugmentState(container, augments);
        if (this.getMode(container) >= this.getNumModes(container)) {
            this.setMode(container, this.getNumModes(container) - 1);
        }
    }

    public int getNumModes(ItemStack stack) {
        return 1 + this.getRadius(stack);
    }

    public void onModeChange(Player player, ItemStack stack) {
        if (this.getNumModes(stack) <= 1) {
            return;
        }
        player.f_19853_.m_5594_(null, player.m_142538_(), SoundEvents.f_12088_, SoundSource.PLAYERS, 0.4f, 1.0f - 0.1f * (float)this.getMode(stack));
        int radius = this.getMode(stack) * 2 + 1;
        if (radius <= 1) {
            ChatHelper.sendIndexedChatMessageToPlayer((Player)player, (Component)new TranslatableComponent("info.cofh.single_block"));
        } else {
            ChatHelper.sendIndexedChatMessageToPlayer((Player)player, (Component)new TranslatableComponent("info.cofh.area").m_130946_(": " + radius + "x" + radius));
        }
    }

    static {
        MATERIALS.add(Material.f_76320_);
        MATERIALS.add(Material.f_76300_);
        MATERIALS.add(Material.f_76302_);
        MATERIALS.add(Material.f_76271_);
    }

    protected class RFSawItemWrapper
    extends EnergyContainerItemWrapper
    implements IAreaEffectItem {
        private final LazyOptional<IAreaEffectItem> holder;

        RFSawItemWrapper(ItemStack containerIn, IEnergyContainerItem itemIn) {
            super(containerIn, itemIn, itemIn.getEnergyCapability());
            this.holder = LazyOptional.of(() -> this);
        }

        public ImmutableList<BlockPos> getAreaEffectBlocks(BlockPos pos, Player player) {
            return AreaEffectHelper.getBreakableBlocksRadius((ItemStack)this.container, (BlockPos)pos, (Player)player, (int)RFSawItem.this.getMode(this.container));
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY) {
                return CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY.orEmpty(cap, this.holder);
            }
            return super.getCapability(cap, side);
        }
    }
}

