/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.innovation.client.model;

import cofh.core.item.IMultiModeItem;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.api.item.ICoFHItem;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.CompositeModelState;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ItemMultiLayerBakedModel;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public final class FluidReservoirItemModel
implements IModelGeometry<FluidReservoirItemModel> {
    private static final float NORTH_Z_FLUID = 0.468625f;
    private static final float SOUTH_Z_FLUID = 0.531375f;
    @Nonnull
    private final FluidStack fluidStack;
    private final int mode;
    private final boolean active;
    private final boolean color;

    public FluidReservoirItemModel(FluidStack fluidStack, int mode, boolean active, boolean color) {
        this.fluidStack = fluidStack;
        this.mode = mode;
        this.active = active;
        this.color = color;
    }

    public FluidReservoirItemModel withProperties(FluidStack newFluid, int mode, boolean active, boolean color) {
        return new FluidReservoirItemModel(newFluid, mode, active, color);
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        TextureAtlasSprite templateSprite;
        Material frameLayer;
        Material modeLayer;
        TextureAtlasSprite particleSprite;
        Material particleLocation = owner.isTexturePresent("particle") ? owner.resolveTexture("particle") : null;
        Material fluidMaskLocation = owner.isTexturePresent("fluid_mask") ? owner.resolveTexture("fluid_mask") : null;
        Material[] inactiveLocations = new Material[2];
        Material[] activeLocations = new Material[2];
        Material[] baseLocations = new Material[2];
        Material[] colorLocations = new Material[2];
        inactiveLocations[0] = owner.isTexturePresent("mode_0") ? owner.resolveTexture("mode_0") : null;
        inactiveLocations[1] = owner.isTexturePresent("mode_1") ? owner.resolveTexture("mode_1") : null;
        activeLocations[0] = owner.isTexturePresent("active_0") ? owner.resolveTexture("active_0") : null;
        activeLocations[1] = owner.isTexturePresent("active_1") ? owner.resolveTexture("active_1") : null;
        baseLocations[0] = owner.isTexturePresent("base_0") ? owner.resolveTexture("base_0") : null;
        baseLocations[1] = owner.isTexturePresent("base_1") ? owner.resolveTexture("base_1") : null;
        colorLocations[0] = owner.isTexturePresent("color_0") ? owner.resolveTexture("color_0") : null;
        colorLocations[1] = owner.isTexturePresent("color_1") ? owner.resolveTexture("color_1") : null;
        ModelState transformsFromModel = owner.getCombinedTransform();
        Fluid fluid = this.fluidStack.getFluid();
        TextureAtlasSprite fluidSprite = fluid != Fluids.f_76191_ ? spriteGetter.apply(ForgeHooksClient.getBlockMaterial((ResourceLocation)fluid.getAttributes().getStillTexture())) : null;
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((ModelState)new CompositeModelState(transformsFromModel, modelTransform));
        TextureAtlasSprite textureAtlasSprite = particleSprite = particleLocation != null ? spriteGetter.apply(particleLocation) : null;
        if (particleSprite == null) {
            particleSprite = fluidSprite;
        }
        Transformation transform = modelTransform.m_6189_();
        ItemMultiLayerBakedModel.Builder builder = ItemMultiLayerBakedModel.builder((IModelConfiguration)owner, (TextureAtlasSprite)particleSprite, (ItemOverrides)new ContainedFluidOverrideHandler(bakery, owner, this), (ImmutableMap)transformMap);
        Material material = modeLayer = this.active ? activeLocations[this.mode % 2] : inactiveLocations[this.mode % 2];
        if (modeLayer != null) {
            builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)false), (Collection)ItemLayerModel.getQuadsForSprite((int)0, (TextureAtlasSprite)spriteGetter.apply(modeLayer), (Transformation)transform));
        }
        Material material2 = frameLayer = this.color ? colorLocations[this.mode % 2] : baseLocations[this.mode % 2];
        if (frameLayer != null) {
            builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)false), (Collection)ItemLayerModel.getQuadsForSprite((int)1, (TextureAtlasSprite)spriteGetter.apply(frameLayer), (Transformation)transform));
        }
        if (fluidMaskLocation != null && fluidSprite != null && (templateSprite = spriteGetter.apply(fluidMaskLocation)) != null) {
            int luminosity = fluid.getAttributes().getLuminosity(this.fluidStack);
            int color = fluid.getAttributes().getColor(this.fluidStack);
            builder.addQuads(ItemLayerModel.getLayerRenderType((luminosity > 0 ? 1 : 0) != 0), (Collection)ItemTextureQuadConverter.convertTexture((Transformation)transform, (TextureAtlasSprite)templateSprite, (TextureAtlasSprite)fluidSprite, (float)0.468625f, (Direction)Direction.NORTH, (int)color, (int)2, (int)luminosity));
            builder.addQuads(ItemLayerModel.getLayerRenderType((luminosity > 0 ? 1 : 0) != 0), (Collection)ItemTextureQuadConverter.convertTexture((Transformation)transform, (TextureAtlasSprite)templateSprite, (TextureAtlasSprite)fluidSprite, (float)0.531375f, (Direction)Direction.SOUTH, (int)color, (int)2, (int)luminosity));
        }
        builder.setParticle(particleSprite);
        return builder.build();
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet texs = Sets.newHashSet();
        if (owner.isTexturePresent("particle")) {
            texs.add(owner.resolveTexture("particle"));
        }
        if (owner.isTexturePresent("fluid_mask")) {
            texs.add(owner.resolveTexture("fluid_mask"));
        }
        if (owner.isTexturePresent("base_0")) {
            texs.add(owner.resolveTexture("base_0"));
        }
        if (owner.isTexturePresent("base_1")) {
            texs.add(owner.resolveTexture("base_1"));
        }
        if (owner.isTexturePresent("color_0")) {
            texs.add(owner.resolveTexture("color_0"));
        }
        if (owner.isTexturePresent("color_1")) {
            texs.add(owner.resolveTexture("color_1"));
        }
        if (owner.isTexturePresent("mode_0")) {
            texs.add(owner.resolveTexture("mode_0"));
        }
        if (owner.isTexturePresent("mode_1")) {
            texs.add(owner.resolveTexture("mode_1"));
        }
        if (owner.isTexturePresent("active_0")) {
            texs.add(owner.resolveTexture("active_0"));
        }
        if (owner.isTexturePresent("active_1")) {
            texs.add(owner.resolveTexture("active_1"));
        }
        return texs;
    }

    private static final class ContainedFluidOverrideHandler
    extends ItemOverrides {
        private final Map<List<Integer>, BakedModel> cache = new Object2ObjectOpenHashMap();
        private final ModelBakery bakery;
        private final IModelConfiguration owner;
        private final FluidReservoirItemModel parent;

        private ContainedFluidOverrideHandler(ModelBakery bakery, IModelConfiguration owner, FluidReservoirItemModel parent) {
            this.bakery = bakery;
            this.owner = owner;
            this.parent = parent;
        }

        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
            int mode = ((IMultiModeItem)stack.m_41720_()).getMode(stack);
            boolean active = ((ICoFHItem)stack.m_41720_()).isActive(stack);
            CompoundTag nbt = stack.m_41737_("display");
            boolean color = nbt != null && nbt.m_128425_("color", 99);
            FluidStack fluidStack = FluidHelper.getFluidContainedInItem((ItemStack)stack).orElse(FluidStack.EMPTY);
            List<Integer> fluidHash = Arrays.asList(mode + (active ? 2 : 0) + (color ? 4 : 0), FluidHelper.fluidHashcode((FluidStack)fluidStack));
            if (!this.cache.containsKey(fluidHash)) {
                FluidReservoirItemModel unbaked = this.parent.withProperties(fluidStack, mode, active, color);
                BakedModel bakedModel = unbaked.bake(this.owner, this.bakery, ForgeModelBakery.defaultTextureGetter(), (ModelState)BlockModelRotation.X0_Y0, this, new ResourceLocation("thermal_innovation", "reservoir_override"));
                this.cache.put(fluidHash, bakedModel);
                return bakedModel;
            }
            return this.cache.get(fluidHash);
        }
    }

    public static class Loader
    implements IModelLoader<FluidReservoirItemModel> {
        public void m_6213_(ResourceManager resourceManager) {
        }

        public FluidReservoirItemModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            ResourceLocation fluidName;
            Fluid fluid;
            FluidStack stack = FluidStack.EMPTY;
            if (modelContents.has("fluid") && (fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidName = new ResourceLocation(modelContents.get("fluid").getAsString()))) != null) {
                stack = new FluidStack(fluid, 1000);
            }
            return new FluidReservoirItemModel(stack, 0, false, false);
        }
    }
}

