/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.tile;

import mob_grinding_utils.MobGrindingUtils;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.blocks.BlockXPTap;
import mob_grinding_utils.entity.EntityXPOrbFalling;
import mob_grinding_utils.network.MessageTapParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.network.PacketDistributor;

public class TileEntityXPTap
extends BlockEntity {
    public boolean active;

    public TileEntityXPTap(BlockPos pos, BlockState state) {
        super(ModBlocks.XP_TAP.getTileEntityType(), pos, state);
    }

    public static <T extends BlockEntity> void serverTick(Level world, BlockPos worldPosition, BlockState blockState, T t) {
        if (t instanceof TileEntityXPTap) {
            BlockEntity tileentity;
            TileEntityXPTap tileEntityXPTap = (TileEntityXPTap)t;
            if (tileEntityXPTap.active && (tileentity = world.m_7702_(worldPosition.m_142300_(((Direction)world.m_8055_(worldPosition).m_61143_((Property)BlockXPTap.f_52588_)).m_122424_()))) != null) {
                LazyOptional fluidHandler = tileentity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, (Direction)world.m_8055_(worldPosition).m_61143_((Property)BlockXPTap.f_52588_));
                fluidHandler.ifPresent(handler -> {
                    int xpAmount;
                    if (handler.getTanks() > 0 && handler.getFluidInTank(0).getAmount() >= 20 && handler.getFluidInTank(0).getFluid().m_205067_(MobGrindingUtils.EXPERIENCE) && world.m_46467_() % 3L == 0L && !handler.drain((xpAmount = EntityXPOrbFalling.m_20782_((int)Math.min(20, handler.getFluidInTank(0).getAmount() / 20))) * 20, IFluidHandler.FluidAction.EXECUTE).isEmpty()) {
                        tileEntityXPTap.spawnXP(world, worldPosition, xpAmount, tileentity);
                        PacketDistributor.TargetPoint particleTarget = new PacketDistributor.TargetPoint((double)t.m_58899_().m_123341_(), (double)t.m_58899_().m_123342_(), (double)t.m_58899_().m_123343_(), 30.0, t.m_58904_().m_46472_());
                        MobGrindingUtils.NETWORK_WRAPPER.send(PacketDistributor.NEAR.with(() -> particleTarget), (Object)new MessageTapParticle(worldPosition));
                    }
                });
            }
        }
    }

    public void spawnXP(Level world, BlockPos pos, int xp, BlockEntity tankTile) {
        tankTile.m_6596_();
        EntityXPOrbFalling orb = new EntityXPOrbFalling(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() - 0.125, (double)pos.m_123343_() + 0.5, xp);
        world.m_7967_((Entity)orb);
    }

    public void setActive(boolean isActive) {
        this.active = isActive;
        this.m_58904_().m_7260_(this.f_58858_, this.m_58904_().m_8055_(this.f_58858_), this.m_58904_().m_8055_(this.f_58858_), 3);
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("active", this.active);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.active = nbt.m_128471_("active");
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        if (packet.m_131708_() != null) {
            this.m_142466_(packet.m_131708_());
        }
    }
}

