/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.util;

import com.technicalitiesmc.lib.util.TextUtils;
import com.technicalitiesmc.lib.util.Utils;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.DyeColor;

public interface TooltipProvider {
    public void addTooltip(List<Component> var1);

    public static class BuiltIn {
        private static final EnumMap<DyeColor, Component> COMPONENTS = Utils.newFilledEnumMap(DyeColor.class, color -> new TranslatableComponent("tooltip.tklib.color." + color.m_7912_()));

        public static TooltipProvider of(DyeColor dye) {
            Component component = BuiltIn.nameOf(dye);
            return list -> list.add(component);
        }

        public static Component nameOf(DyeColor dye) {
            return COMPONENTS.get(dye);
        }
    }

    public record Simple(String translationKey) implements Auto
    {
        @Override
        public String getTooltipTranslationKey() {
            return this.translationKey();
        }
    }

    public static interface Auto
    extends TooltipProvider {
        public String getTooltipTranslationKey();

        @Override
        default public void addTooltip(List<Component> tooltip) {
            String key = this.getTooltipTranslationKey();
            tooltip.addAll(TextUtils.getLocalized(key, new Object[0]));
            String subtitleKey = key + ".subtitle";
            TranslatableComponent subtitle = new TranslatableComponent(subtitleKey);
            String subtitleString = subtitle.getString();
            if (!subtitleString.equals(subtitleKey)) {
                tooltip.addAll(TextUtils.breakUp(subtitleString));
            }
        }
    }
}

