/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.network;

import com.technicalitiesmc.lib.item.ifo.ItemFunctionalOverride;
import com.technicalitiesmc.lib.network.ClientboundDisableIFOPacket;
import com.technicalitiesmc.lib.network.ClientboundEnableIFOPacket;
import com.technicalitiesmc.lib.network.Packet;
import com.technicalitiesmc.lib.network.ServerboundGhostSlotClickPacket;
import com.technicalitiesmc.lib.network.ServerboundGhostSlotScrollPacket;
import com.technicalitiesmc.lib.network.ServerboundGhostSlotSetPacket;
import com.technicalitiesmc.lib.network.ServerboundMenuComponentMessagePacket;
import com.technicalitiesmc.lib.network.ServerboundQuickBreakPacket;
import com.technicalitiesmc.lib.network.ServerboundRotateBlockPacket;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Rotation;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class TKLibNetworkHandler {
    private static SimpleChannel INSTANCE;
    private static int ID;

    public static void registerPackets() {
        INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("tklib", "main"), () -> "1.0", s -> true, s -> true);
        TKLibNetworkHandler.register(ServerboundGhostSlotClickPacket.class, ServerboundGhostSlotClickPacket::new);
        TKLibNetworkHandler.register(ServerboundGhostSlotScrollPacket.class, ServerboundGhostSlotScrollPacket::new);
        TKLibNetworkHandler.register(ServerboundGhostSlotSetPacket.class, ServerboundGhostSlotSetPacket::new);
        TKLibNetworkHandler.register(ServerboundMenuComponentMessagePacket.class, ServerboundMenuComponentMessagePacket::new);
        TKLibNetworkHandler.register(ServerboundRotateBlockPacket.class, ServerboundRotateBlockPacket::new);
        TKLibNetworkHandler.register(ClientboundEnableIFOPacket.class, ClientboundEnableIFOPacket::new);
        TKLibNetworkHandler.register(ClientboundDisableIFOPacket.class, ClientboundDisableIFOPacket::new);
        TKLibNetworkHandler.register(ServerboundQuickBreakPacket.class, ServerboundQuickBreakPacket::new);
    }

    private static <T extends Packet> void register(Class<T> type, Function<FriendlyByteBuf, T> decoder) {
        INSTANCE.messageBuilder(type, ID++).encoder(Packet::encode).decoder(decoder).consumer((first, second) -> first.handle((NetworkEvent.Context)second.get())).add();
    }

    private static void sendToClient(Packet packet, ServerPlayer player) {
        INSTANCE.sendTo((Object)packet, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    private static void sendToServer(Packet packet) {
        INSTANCE.sendToServer((Object)packet);
    }

    public static void sendServerboundGhostSlotClick(int slotNumber) {
        TKLibNetworkHandler.sendToServer(new ServerboundGhostSlotClickPacket(slotNumber));
    }

    public static void sendServerboundGhostSlotScroll(int slotNumber, int amount) {
        TKLibNetworkHandler.sendToServer(new ServerboundGhostSlotScrollPacket(slotNumber, amount));
    }

    public static void sendServerboundGhostSlotSet(int slotNumber, ItemStack stack) {
        TKLibNetworkHandler.sendToServer(new ServerboundGhostSlotSetPacket(slotNumber, stack));
    }

    public static void sendServerboundMenuComponentMessage(int component, byte[] data) {
        TKLibNetworkHandler.sendToServer(new ServerboundMenuComponentMessagePacket(component, data));
    }

    public static void sendServerboundRotateBlock(BlockPos pos, Direction.Axis axis, Rotation rotation) {
        TKLibNetworkHandler.sendToServer(new ServerboundRotateBlockPacket(pos, axis, rotation));
    }

    public static void sendClientboundEnableIFO(ServerPlayer player, ItemFunctionalOverride ifo) {
        TKLibNetworkHandler.sendToClient(new ClientboundEnableIFOPacket(ifo), player);
    }

    public static void sendClientboundDisableIFO(ServerPlayer player) {
        TKLibNetworkHandler.sendToClient(new ClientboundDisableIFOPacket(), player);
    }

    public static void sendServerboundQuickBreak(BlockPos pos) {
        TKLibNetworkHandler.sendToServer(new ServerboundQuickBreakPacket(pos));
    }

    static {
        ID = 0;
    }
}

