/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.menu;

import com.technicalitiesmc.lib.client.screen.widget.Widget;
import com.technicalitiesmc.lib.network.TKLibNetworkHandler;
import com.technicalitiesmc.lib.util.value.Reference;
import io.netty.buffer.Unpooled;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;

public abstract class MenuComponent {
    private static final BooleanSupplier ALWAYS = () -> true;
    private static final BooleanSupplier NEVER = () -> false;
    int id;
    private BooleanSupplier enabled = () -> true;
    private int delayUntilSend = -1;
    private byte[] bytesToSend = null;

    public abstract Supplier<Widget> widgetSupplier();

    public abstract void subscribe(DataTracker var1);

    public abstract void onEvent(FriendlyByteBuf var1);

    public void clientTick() {
        if (this.delayUntilSend >= 0 && this.delayUntilSend-- == 0) {
            TKLibNetworkHandler.sendServerboundMenuComponentMessage(this.id, this.bytesToSend);
            this.bytesToSend = null;
        }
    }

    public void onClientClosed() {
        if (this.delayUntilSend >= 0) {
            TKLibNetworkHandler.sendServerboundMenuComponentMessage(this.id, this.bytesToSend);
            this.bytesToSend = null;
        }
    }

    protected final void notifyServer(Consumer<FriendlyByteBuf> writer) {
        this.notifyServer(writer, 0);
    }

    protected final void notifyServer(Consumer<FriendlyByteBuf> writer, int delay) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        writer.accept(buf);
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        buf.release();
        if (delay == 0) {
            TKLibNetworkHandler.sendServerboundMenuComponentMessage(this.id, bytes);
        } else {
            this.delayUntilSend = delay;
            this.bytesToSend = bytes;
        }
    }

    public final boolean isEnabled() {
        return this.enabled.getAsBoolean();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled ? ALWAYS : NEVER;
    }

    public void setEnabledWhen(BooleanSupplier supplier) {
        this.enabled = supplier;
    }

    public static interface DataTracker {
        public void trackInts(int[] var1);

        public void trackBoolean(Reference<Boolean> var1);

        public void trackInt(Reference<Integer> var1);

        public void trackEnum(Reference<? extends Enum<?>> var1);
    }
}

