/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.item.ifo;

import com.technicalitiesmc.lib.init.TKLibIFOs;
import com.technicalitiesmc.lib.item.ifo.BlockIFOBase;
import com.technicalitiesmc.lib.util.Utils;
import com.technicalitiesmc.lib.util.Validator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class SelectRangeOverride
extends BlockIFOBase {
    private final int maxRange;
    private final Callback callback;

    public SelectRangeOverride(BlockPos origin, int maxRange, Callback callback, Validator validator) {
        super(TKLibIFOs.SELECT_RANGE, origin, validator);
        this.maxRange = maxRange;
        this.callback = callback;
    }

    public SelectRangeOverride(FriendlyByteBuf buf) {
        super(TKLibIFOs.SELECT_RANGE, buf);
        this.maxRange = buf.m_130242_();
        this.callback = null;
    }

    @Override
    public InteractionResult use(Level level, Player player, HitResult hit) {
        Direction direction;
        if (level.m_5776_() || !(hit instanceof BlockHitResult)) {
            return InteractionResult.PASS;
        }
        BlockHitResult blockHit = (BlockHitResult)hit;
        BlockPos offset = blockHit.m_82425_().m_141950_((Vec3i)this.origin());
        int magnitude = Utils.getMagnitude((Vec3i)offset);
        Direction direction2 = direction = magnitude == 0 || magnitude > this.maxRange ? blockHit.m_82434_() : Utils.getDirection((Vec3i)offset);
        if (magnitude <= this.maxRange && direction != null && this.callback.onRangeSelected(level, this.origin(), player, direction, magnitude)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME_PARTIAL;
    }

    @Override
    public InteractionResult hit(Level level, Player player, HitResult hit) {
        return InteractionResult.PASS;
    }

    @Override
    @Nullable
    public Component getTip(Level level, Player player) {
        return new TextComponent("Select a block up to " + this.maxRange + " blocks away in a straight line.");
    }

    @Override
    public void writeToNetwork(FriendlyByteBuf buf) {
        super.writeToNetwork(buf);
        buf.m_130130_(this.maxRange);
    }

    @FunctionalInterface
    public static interface Callback {
        public boolean onRangeSelected(Level var1, BlockPos var2, Player var3, Direction var4, int var5);
    }
}

