/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.inventory;

import com.technicalitiesmc.lib.inventory.ItemFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.stream.IntStream;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemHandlerExtractionQuery {
    private final IItemHandler inventory;
    private final int size;
    private final List<ItemStack> items;
    private final int[] extracted;
    private Extraction lastExtraction;
    private boolean committed;

    public static PrimitiveIterator.OfInt defaultVisitOrder(int size) {
        return IntStream.range(0, size).iterator();
    }

    public ItemHandlerExtractionQuery(IItemHandler inventory) {
        this.inventory = inventory;
        this.size = inventory.getSlots();
        this.items = new ArrayList<ItemStack>();
        for (int i = 0; i < this.size; ++i) {
            this.items.add(null);
        }
        this.extracted = new int[this.size];
    }

    public Extraction extractAll(ItemFilter filter) {
        return this.extractAll(filter, ItemHandlerExtractionQuery.defaultVisitOrder(this.size));
    }

    public Extraction extractAll(ItemFilter filter, PrimitiveIterator.OfInt visitOrder) {
        ItemStack stack = ItemStack.f_41583_;
        int extractedAmount = 0;
        int minExtracted = 0;
        int maxExtracted = 0;
        int[] extractedAmounts = new int[this.size];
        while (visitOrder.hasNext()) {
            int extracted;
            int i = visitOrder.nextInt();
            if (stack.m_41619_()) {
                ItemFilter.Simple matchedFilter = this.getMatch(i, filter);
                if (matchedFilter == null) continue;
                stack = this.items.get(i).m_41777_();
                minExtracted = matchedFilter.getMinAmount();
                maxExtracted = matchedFilter.getMaxAmount();
            } else if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)this.getStack(i))) continue;
            ItemStack s = this.getStack(i);
            extractedAmounts[i] = extracted = Math.min(s.m_41613_(), maxExtracted - extractedAmount);
            if ((extractedAmount += extracted) != maxExtracted) continue;
            break;
        }
        if (extractedAmount < minExtracted) {
            return new Extraction(ItemStack.f_41583_, null, 0);
        }
        stack.m_41764_(extractedAmount);
        this.lastExtraction = new Extraction(stack, extractedAmounts, minExtracted);
        return this.lastExtraction;
    }

    public Extraction extractFirst(ItemFilter filter, PrimitiveIterator.OfInt visitOrder) {
        while (visitOrder.hasNext()) {
            int amount;
            ItemStack stack;
            int i = visitOrder.nextInt();
            ItemFilter.Simple matchedFilter = this.getMatch(i, filter);
            if (matchedFilter == null || (stack = this.items.get(i)).m_41613_() < matchedFilter.getMinAmount()) continue;
            int[] extractedAmounts = new int[this.size];
            extractedAmounts[i] = amount = Math.min(stack.m_41613_(), matchedFilter.getMaxAmount());
            if (amount != stack.m_41613_()) {
                stack = stack.m_41777_().m_41620_(amount);
            }
            this.lastExtraction = new Extraction(stack, extractedAmounts, matchedFilter.getMinAmount());
            return this.lastExtraction;
        }
        return new Extraction(ItemStack.f_41583_, null, 0);
    }

    public void commit() {
        if (this.committed) {
            throw new IllegalStateException("This query has already been committed.");
        }
        this.committed = true;
        for (int i = 0; i < this.size; ++i) {
            int amt = this.extracted[i];
            if (amt == 0) continue;
            this.inventory.extractItem(i, amt, false);
        }
    }

    private ItemStack getStack(int slot) {
        ItemStack currentItem = this.items.get(slot);
        if (currentItem == null) {
            currentItem = this.inventory.extractItem(slot, 64, true).m_41777_();
            this.items.set(slot, currentItem);
        }
        return currentItem;
    }

    private ItemFilter.Simple getMatch(int slot, ItemFilter filter) {
        ItemStack currentItem = this.getStack(slot);
        if (currentItem.m_41619_()) {
            return null;
        }
        if (filter instanceof ItemFilter.Combined) {
            ItemFilter.Combined c = (ItemFilter.Combined)filter;
            return c.getMatchingFilter(currentItem);
        }
        if (filter instanceof ItemFilter.Simple) {
            ItemFilter.Simple s = (ItemFilter.Simple)filter;
            return filter.test(currentItem) ? s : null;
        }
        if (filter instanceof ItemFilter.None) {
            return null;
        }
        throw new IllegalArgumentException("Custom filter implementations are not allowed in extraction queries.");
    }

    public class Extraction {
        private final ItemStack extracted;
        private final int[] extractedAmounts;
        private final int minExtracted;

        private Extraction(ItemStack extracted, int[] extractedAmounts, int minExtracted) {
            this.extracted = extracted;
            this.extractedAmounts = extractedAmounts;
            this.minExtracted = minExtracted;
        }

        public ItemStack getExtracted() {
            return this.extracted;
        }

        public void commit() {
            if (ItemHandlerExtractionQuery.this.lastExtraction != this) {
                throw new IllegalStateException("Only the most recent extraction can be committed.");
            }
            ItemHandlerExtractionQuery.this.lastExtraction = null;
            if (this.extracted.m_41619_()) {
                throw new IllegalStateException("Attempted to commit a failed extraction.");
            }
            for (int i = 0; i < ItemHandlerExtractionQuery.this.size; ++i) {
                int amt = this.extractedAmounts[i];
                if (amt == 0) continue;
                ItemStack currentItem = ItemHandlerExtractionQuery.this.items.get(i);
                currentItem.m_41774_(amt);
                int n = i;
                ItemHandlerExtractionQuery.this.extracted[n] = ItemHandlerExtractionQuery.this.extracted[n] + amt;
            }
        }

        public boolean commitAtMost(int maxExtracted) {
            if (ItemHandlerExtractionQuery.this.lastExtraction != this) {
                throw new IllegalStateException("Only the most recent extraction can be committed.");
            }
            ItemHandlerExtractionQuery.this.lastExtraction = null;
            if (this.extracted.m_41619_()) {
                throw new IllegalStateException("Attempted to commit a failed extraction.");
            }
            if (maxExtracted < this.minExtracted) {
                return false;
            }
            int left = maxExtracted;
            for (int i = 0; i < ItemHandlerExtractionQuery.this.size && left > 0; ++i) {
                int amt = this.extractedAmounts[i];
                if (amt == 0) continue;
                int actualAmt = Math.min(left, amt);
                ItemStack currentItem = ItemHandlerExtractionQuery.this.items.get(i);
                currentItem.m_41774_(actualAmt);
                int n = i;
                ItemHandlerExtractionQuery.this.extracted[n] = ItemHandlerExtractionQuery.this.extracted[n] + actualAmt;
                left -= actualAmt;
            }
            return true;
        }
    }
}

