/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.inventory;

import com.technicalitiesmc.lib.inventory.InventoryHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.IntBinaryOperator;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.ItemHandlerHelper;

public interface ItemFilter {
    public boolean test(ItemStack var1);

    public int getMatchedAmount(ItemStack var1);

    public static ItemFilter none() {
        return None.INSTANCE;
    }

    @Nonnull
    public static Builder exactly(int amt) {
        return new Builder(AmountMatchMode.EXACTLY, amt);
    }

    @Nonnull
    public static Builder atLeast(int amt) {
        return new Builder(AmountMatchMode.AT_LEAST, amt);
    }

    @Nonnull
    public static Builder atMost(int amt) {
        return new Builder(AmountMatchMode.AT_MOST, amt);
    }

    @Nonnull
    public static ItemFilter anyOf(ItemFilter ... filters) {
        return ItemFilter.anyOf(Arrays.asList(filters));
    }

    @Nonnull
    public static ItemFilter anyOf(Collection<ItemFilter> filters) {
        if (filters.isEmpty()) {
            return ItemFilter.none();
        }
        ArrayList<Simple> simpleFilters = new ArrayList<Simple>();
        for (ItemFilter filter : filters) {
            if (filter instanceof Simple) {
                Simple s = (Simple)filter;
                simpleFilters.add(s);
                continue;
            }
            if (filter instanceof Combined) {
                Combined c = (Combined)filter;
                simpleFilters.addAll(c.filters);
                continue;
            }
            throw new IllegalArgumentException("Only simple and combined filters are allowed to be combined.");
        }
        return new Combined(simpleFilters);
    }

    public record None() implements ItemFilter
    {
        public static final ItemFilter INSTANCE = new None();

        @Override
        public boolean test(ItemStack stack) {
            return false;
        }

        @Override
        public int getMatchedAmount(ItemStack stack) {
            return 0;
        }
    }

    public static final class Builder {
        private final AmountMatchMode mode;
        private final int amount;

        private Builder(AmountMatchMode mode, int amount) {
            this.mode = mode;
            this.amount = amount;
        }

        @Nonnull
        public ItemFilter ofAnyItem() {
            return this.matching((ItemStack s) -> true);
        }

        @Nonnull
        public ItemFilter of(ItemStack stack) {
            return this.matching((ItemStack s) -> ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)s));
        }

        @Nonnull
        public ItemFilter is(ItemLike item) {
            return this.matching((ItemStack s) -> s.m_150930_(item.m_5456_()));
        }

        @Nonnull
        public ItemFilter is(TagKey<Item> tag) {
            return this.matching((ItemStack s) -> s.m_204117_(tag));
        }

        @Nonnull
        public ItemFilter isNot(TagKey<Item> tag) {
            return this.matching((ItemStack s) -> !s.m_204117_(tag));
        }

        @Nonnull
        public ItemFilter matching(ItemStack filter) {
            return this.matching((ItemStack s) -> InventoryHelper.matchesFilter(filter, s));
        }

        @Nonnull
        public ItemFilter matching(Predicate<ItemStack> predicate) {
            return new Simple(this.mode, this.amount, predicate);
        }
    }

    public static enum AmountMatchMode {
        EXACTLY((in, ref) -> in == ref ? ref : 0),
        AT_LEAST((in, ref) -> in >= ref ? in : 0),
        AT_MOST(Math::min);

        private final IntBinaryOperator test;

        private AmountMatchMode(IntBinaryOperator test) {
            this.test = test;
        }

        public int test(int amount, int reference) {
            return this.test.applyAsInt(amount, reference);
        }
    }

    public static final class Simple
    implements ItemFilter {
        private final AmountMatchMode mode;
        private final int amount;
        private final int minAmount;
        private final int maxAmount;
        private final Predicate<ItemStack> predicate;

        private Simple(AmountMatchMode mode, int amount, Predicate<ItemStack> predicate) {
            this.mode = mode;
            this.amount = amount;
            this.minAmount = mode == AmountMatchMode.AT_MOST ? 0 : amount;
            this.maxAmount = mode == AmountMatchMode.AT_LEAST ? 64 : amount;
            this.predicate = predicate;
        }

        @Override
        public boolean test(ItemStack stack) {
            return this.predicate.test(stack);
        }

        @Override
        public int getMatchedAmount(ItemStack stack) {
            return this.mode.test.applyAsInt(stack.m_41613_(), this.amount);
        }

        public int getMinAmount() {
            return this.minAmount;
        }

        public int getMaxAmount() {
            return this.maxAmount;
        }
    }

    public static final class Combined
    implements ItemFilter {
        private final Collection<Simple> filters;

        private Combined(Collection<Simple> filters) {
            this.filters = filters;
        }

        @Override
        public boolean test(ItemStack stack) {
            for (Simple filter : this.filters) {
                if (!filter.test(stack)) continue;
                return true;
            }
            return false;
        }

        @Override
        public int getMatchedAmount(ItemStack stack) {
            for (Simple filter : this.filters) {
                if (!filter.test(stack)) continue;
                return filter.getMatchedAmount(stack);
            }
            return 0;
        }

        @Nullable
        public Simple getMatchingFilter(ItemStack stack) {
            for (Simple filter : this.filters) {
                if (!filter.test(stack)) continue;
                return filter;
            }
            return null;
        }
    }
}

