/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.inventory;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.IItemHandler;

public class DroppedItemHandler
implements IItemHandler {
    private final List<ItemEntity> entities;

    public DroppedItemHandler(Level level, AABB area) {
        this.entities = level.m_45976_(ItemEntity.class, area);
    }

    public int getSlots() {
        return this.entities.size();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        ItemEntity entity = this.entities.get(slot);
        return entity.m_6084_() ? entity.m_32055_() : ItemStack.f_41583_;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemEntity entity = this.entities.get(slot);
        if (!entity.m_6084_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = entity.m_32055_();
        int originalSize = stack.m_41613_();
        ItemStack split = stack.m_41620_(amount);
        if (simulate) {
            stack.m_41764_(originalSize);
        } else if (stack.m_41619_()) {
            entity.m_142687_(Entity.RemovalReason.KILLED);
        }
        return split;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return false;
    }
}

