/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.client.screen.widget;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.mojang.blaze3d.vertex.PoseStack;
import com.technicalitiesmc.lib.client.RenderHelper;
import com.technicalitiesmc.lib.client.screen.widget.SimpleWidget;
import com.technicalitiesmc.lib.math.Vec2i;
import com.technicalitiesmc.lib.util.value.Reference;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class ListWidget<T extends Entry>
extends SimpleWidget {
    private final Iterable<T> entries;
    private final Reference<Integer> selectedEntry;
    private final int entryHeight;
    private final int maxVisibleEntries;
    private int scrolled;

    public ListWidget(int x, int y, int width, int height, BooleanSupplier enabled, Iterable<T> entries, Reference<Integer> selectedEntry, int entryHeight) {
        super(x, y, width, height, enabled);
        this.entries = entries;
        this.selectedEntry = selectedEntry;
        this.entryHeight = entryHeight;
        this.maxVisibleEntries = height / entryHeight;
    }

    @Override
    public void onClicked(double x, double y, int button) {
        int entryCount;
        if (button != 0) {
            return;
        }
        int viewSpaceEntry = (int)Math.floor(y / (double)this.entryHeight);
        int actualEntry = viewSpaceEntry + this.scrolled;
        this.selectedEntry.set(actualEntry <= (entryCount = Iterators.size(this.entries.iterator())) ? actualEntry : -1);
        this.playClickSound();
    }

    @Override
    public boolean onMouseScrolled(double x, double y, double amount) {
        int delta = (int)(-Math.signum(amount));
        int entryCount = Iterators.size(this.entries.iterator());
        this.scrolled = Math.max(0, Math.min(this.scrolled + delta, entryCount - this.maxVisibleEntries));
        return true;
    }

    @Override
    public void addTooltip(int mouseX, int mouseY, List<Component> tooltip) {
        int viewSpaceEntry = mouseY / this.entryHeight;
        int actualEntry = viewSpaceEntry + this.scrolled;
        Entry entry = (Entry)Iterables.getFirst((Iterable)Iterables.skip(this.entries, (int)actualEntry), null);
        if (entry != null) {
            entry.addTooltip(tooltip, this.size().x());
        }
    }

    @Override
    public void render(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        Vec2i size = this.size();
        int width = size.x();
        int height = size.y();
        RenderHelper.enableScissor(poseStack, 0.0, 0.0, width - 2, height);
        poseStack.m_85836_();
        Integer selected = (Integer)this.selectedEntry.get();
        int i = 0;
        for (Entry entry : Iterables.skip(this.entries, (int)this.scrolled)) {
            if (this.scrolled + i == selected) {
                this.m_93179_(poseStack, 0, 0, width, this.entryHeight, 0x4FFFFFFF, 0x4AFFFFFF);
            }
            entry.render(poseStack, width, mouseX, mouseY - i * this.entryHeight, partialTicks);
            if (++i >= this.maxVisibleEntries) break;
            poseStack.m_85837_(0.0, (double)this.entryHeight, 0.0);
        }
        poseStack.m_85849_();
        RenderHelper.disableScissor();
    }

    public static interface Entry {
        public void render(PoseStack var1, int var2, int var3, int var4, float var5);

        default public void addTooltip(List<Component> components, int width) {
        }
    }

    public static final class ComponentEntry
    extends GuiComponent
    implements Entry {
        public static final int HEIGHT = 12;
        private final Component component;

        public ComponentEntry(Component component) {
            this.component = component;
        }

        @Override
        public void render(PoseStack poseStack, int width, int mouseX, int mouseY, float partialTicks) {
            Font font = Minecraft.m_91087_().f_91062_;
            font.m_92763_(poseStack, this.component, 2.0f, 2.0f, -1);
        }

        @Override
        public void addTooltip(List<Component> components, int width) {
            Font font = Minecraft.m_91087_().f_91062_;
            if (font.m_92852_((FormattedText)this.component) > width) {
                components.add(this.component);
            }
        }
    }
}

