/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.circuit.component;

import java.util.function.Consumer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public interface ComponentHarvestContext {
    public static ComponentHarvestContext dummy(final ServerLevel level) {
        return new ComponentHarvestContext(){

            @Override
            public ServerLevel getLevel() {
                return level;
            }

            @Override
            public boolean isCreative() {
                return false;
            }

            @Override
            public void drop(ItemStack item) {
            }
        };
    }

    public static ComponentHarvestContext forPlayer(final Player player) {
        return new ComponentHarvestContext(){

            @Override
            public ServerLevel getLevel() {
                return (ServerLevel)player.m_183503_();
            }

            @Override
            public boolean isCreative() {
                return player.m_7500_();
            }

            @Override
            public void drop(ItemStack item) {
                ItemStack copy = item.m_41777_();
                player.m_36356_(copy);
                if (!copy.m_41619_()) {
                    player.f_19853_.m_7967_((Entity)new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_(), copy));
                }
            }
        };
    }

    public static ComponentHarvestContext drop(final ServerLevel level, final Consumer<ItemStack> dropper) {
        return new ComponentHarvestContext(){

            @Override
            public ServerLevel getLevel() {
                return level;
            }

            @Override
            public boolean isCreative() {
                return false;
            }

            @Override
            public void drop(ItemStack item) {
                dropper.accept(item);
            }
        };
    }

    public ServerLevel getLevel();

    public boolean isCreative();

    public void drop(ItemStack var1);
}

