/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.block.component;

import com.technicalitiesmc.lib.block.BlockComponent;
import com.technicalitiesmc.lib.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.phys.BlockHitResult;

public class BlockDyeable
extends BlockComponent.WithoutData {
    private final EnumProperty<DyeColor> property;

    private BlockDyeable(BlockComponent.Context context, EnumProperty<DyeColor> property) {
        super(context);
        this.property = property;
    }

    public static BlockComponent.Constructor<BlockDyeable> of(EnumProperty<DyeColor> property) {
        return ctx -> new BlockDyeable(ctx, property);
    }

    public DyeColor color(BlockState state) {
        return (DyeColor)state.m_61143_(this.property);
    }

    public BlockState withColor(BlockState state, DyeColor color) {
        return (BlockState)state.m_61124_(this.property, (Comparable)color);
    }

    @Override
    protected BlockState getStateForPlacement(BlockPlaceContext context, BlockState state) {
        DyeColor dye;
        Player player = context.m_43723_();
        if (player != null && (dye = Utils.getDyeColor(player.m_21206_())) != null) {
            return (BlockState)state.m_61124_(this.property, (Comparable)dye);
        }
        return state;
    }

    @Override
    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        DyeColor dyeColor;
        ItemStack item = player.m_21120_(hand);
        if (!item.m_41619_() && (dyeColor = Utils.getDyeColor(item)) != null) {
            if (!level.m_5776_()) {
                level.m_7731_(pos, (BlockState)state.m_61124_(this.property, (Comparable)dyeColor), 3);
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return super.use(state, level, pos, player, hand, hit);
    }
}

