/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.block;

import com.technicalitiesmc.lib.block.BlockComponent;
import com.technicalitiesmc.lib.block.RotationHandler;
import com.technicalitiesmc.lib.block.TKBlockEntity;
import com.technicalitiesmc.lib.item.ifo.IFOManager;
import com.technicalitiesmc.lib.item.ifo.ItemFunctionalOverride;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.RegistryObject;

public abstract class TKBlock
extends Block
implements BlockComponent.Context,
RotationHandler {
    private static final ThreadLocal<Property<?>[]> STATE_PROPERTIES = new ThreadLocal();
    private final List<BlockComponent> components = new ArrayList<BlockComponent>();

    private static BlockBehaviour.Properties cacheStateProperties(BlockBehaviour.Properties properties, Property<?>[] stateProperties) {
        STATE_PROPERTIES.set(stateProperties);
        return properties;
    }

    public TKBlock(BlockBehaviour.Properties properties, Property<?> ... stateProperties) {
        super(TKBlock.cacheStateProperties(properties, stateProperties));
    }

    final <T extends BlockComponent> T doAddComponent(BlockComponent.Constructor<T> constructor) {
        BlockComponent component = (BlockComponent)constructor.create(this);
        this.components.add(component);
        return (T)component;
    }

    protected final <T extends BlockComponent.WithoutData> T addComponent(BlockComponent.Constructor<T> constructor) {
        return (T)((BlockComponent.WithoutData)this.doAddComponent(constructor));
    }

    protected final Iterable<BlockComponent> getComponents() {
        return this.components;
    }

    @Override
    public final TKBlock getBlock() {
        return this;
    }

    @Nullable
    public Object getInterface(Class<?> itf) {
        if (itf == RotationHandler.class) {
            return this;
        }
        return this.getInterfaceFromComponents(itf);
    }

    @Nullable
    protected final Object getInterfaceFromComponents(Class<?> itf) {
        for (BlockComponent component : this.components) {
            Object impl = component.getInterface(itf);
            if (impl == null) continue;
            return impl;
        }
        return null;
    }

    public final Component getDefaultContainerName() {
        ResourceLocation name = this.getRegistryName();
        return new TranslatableComponent("container." + name.m_135827_() + "." + name.m_135815_());
    }

    public final Component getDefaultDebugContainerName() {
        ResourceLocation name = this.getRegistryName();
        return new TranslatableComponent("container." + name.m_135827_() + "." + name.m_135815_() + ".debug");
    }

    protected final InteractionResult openMenu(Level level, Player player, MenuConstructor constructor) {
        return this.openMenu(level, player, constructor, this.getDefaultContainerName());
    }

    protected final InteractionResult openMenu(Level level, Player player, MenuConstructor constructor, Component title) {
        if (!level.m_5776_()) {
            player.m_5893_((MenuProvider)new SimpleMenuProvider(constructor, title));
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    protected final InteractionResult applyOverride(Level level, Player player, Supplier<ItemFunctionalOverride> ifo) {
        if (!level.m_5776_()) {
            IFOManager.enable(player, ifo.get());
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    protected final <T extends Comparable<T>> void setDefault(Property<T> property, T value) {
        this.m_49959_((BlockState)this.m_49966_().m_61124_(property, value));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(STATE_PROPERTIES.get());
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        for (BlockComponent component : this.getComponents()) {
            state = component.getStateForPlacement(context, state);
        }
        return state;
    }

    public BlockState m_7417_(BlockState state, Direction side, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        state = super.m_7417_(state, side, neighborState, level, pos, neighborPos);
        for (BlockComponent component : this.getComponents()) {
            state = component.updateShape(state, side, neighborState, level, pos, neighborPos);
        }
        return state;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighborPos, boolean moving) {
        super.m_6861_(state, level, pos, block, neighborPos, moving);
        for (BlockComponent component : this.getComponents()) {
            component.neighborChanged(state, level, pos, block, neighborPos, moving);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        for (BlockComponent component : this.getComponents()) {
            InteractionResult result = component.use(state, level, pos, player, hand, hit);
            if (result == InteractionResult.PASS) continue;
            return result;
        }
        return InteractionResult.PASS;
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        for (BlockComponent component : this.getComponents()) {
            if (!component.attack(state, level, pos, player)) continue;
            return;
        }
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState prevState, boolean moving) {
        for (BlockComponent component : this.getComponents()) {
            component.onPlace(state, level, pos, prevState, moving);
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack item) {
        for (BlockComponent component : this.getComponents()) {
            component.setPlacedBy(level, pos, state, entity, item);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moving) {
        for (BlockComponent component : this.getComponents()) {
            component.onRemove(state, level, pos, newState, moving);
        }
        super.m_6810_(state, level, pos, newState, moving);
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        int signal = 0;
        for (BlockComponent component : this.getComponents()) {
            signal = Math.max(signal, component.getAnalogOutputSignal(state, level, pos));
        }
        return signal;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        for (BlockComponent component : this.getComponents()) {
            VoxelShape shape = component.getShape(state, level, pos, context);
            if (shape == null) continue;
            return shape;
        }
        return super.m_5940_(state, level, pos, context);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        for (BlockComponent component : this.getComponents()) {
            state = component.rotate(state, rotation);
        }
        return state;
    }

    public BlockState rotate(BlockState state, LevelAccessor level, BlockPos pos, Rotation rotation) {
        for (BlockComponent component : this.getComponents()) {
            state = component.rotate(state, level, pos, rotation);
        }
        return state;
    }

    @Override
    public boolean rotate(BlockState state, Level level, BlockPos pos, Direction.Axis axis, Rotation rotation) {
        ArrayList<UnaryOperator> actions = new ArrayList<UnaryOperator>();
        for (BlockComponent component : this.getComponents()) {
            InteractionResultHolder<UnaryOperator<BlockState>> result = component.rotate(state, level, pos, axis, rotation);
            if (result.m_19089_() == InteractionResult.FAIL) {
                return false;
            }
            if (result.m_19089_() != InteractionResult.SUCCESS) continue;
            actions.add((UnaryOperator)result.m_19095_());
        }
        if (actions.isEmpty()) {
            return false;
        }
        BlockState newState = state;
        for (UnaryOperator action : actions) {
            newState = (BlockState)action.apply(newState);
        }
        if (newState != state) {
            level.m_7731_(pos, newState, level.m_5776_() ? 8 : 3);
        }
        return true;
    }

    @Nullable
    public static <T> T getInterface(Block block, Class<T> itf) {
        if (block instanceof TKBlock) {
            TKBlock tkb = (TKBlock)block;
            return (T)tkb.getInterface(itf);
        }
        if (itf.isAssignableFrom(block.getClass())) {
            return (T)block;
        }
        return null;
    }

    public static class WithEntity
    extends TKBlock
    implements EntityBlock {
        final RegistryObject<BlockEntityType<TKBlockEntity>> entityType;
        final Map<String, BlockComponent.WithData<?>> components = new HashMap();

        public WithEntity(BlockBehaviour.Properties properties, RegistryObject<BlockEntityType<TKBlockEntity>> entityType, Property<?> ... stateProperties) {
            super(properties, stateProperties);
            this.entityType = entityType;
        }

        protected final <T extends BlockComponent.WithData<?>> T addComponent(String name, BlockComponent.Constructor<T> constructor) {
            BlockComponent.WithData component = (BlockComponent.WithData)this.doAddComponent(constructor);
            this.components.put(name, component);
            return (T)component;
        }

        @Nullable
        public BlockEntity m_142194_(BlockPos pos, BlockState state) {
            return ((BlockEntityType)this.entityType.get()).m_155264_(pos, state);
        }
    }
}

