/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.world;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.lang.ref.WeakReference;
import net.minecraft.core.SectionPos;
import net.roguelogix.phosphophyllite.repack.org.joml.AABBi;
import net.roguelogix.quartz.DrawBatch;
import net.roguelogix.quartz.internal.QuartzCore;

public class WorldEngine {
    private final Long2ObjectOpenHashMap<WeakReference<DrawBatch>> sectionDrawBatchers = new Long2ObjectOpenHashMap();
    private final Object2ObjectOpenHashMap<AABBi, WeakReference<DrawBatch>> customDrawBatchers = new Object2ObjectOpenHashMap();

    public synchronized DrawBatch getBatcherForAABB(AABBi aabb) {
        return this.getBatcherForAABB(aabb, false);
    }

    public synchronized DrawBatch getBatcherForAABB(AABBi aabb, boolean allowReuse) {
        if (aabb.minX >> 4 == aabb.maxX >> 4 && aabb.minY >> 4 == aabb.maxY >> 4 && aabb.minZ >> 4 == aabb.maxZ >> 4) {
            return this.getBatcherForSection(SectionPos.m_123209_((int)(aabb.minX >> 4), (int)(aabb.minY >> 4), (int)(aabb.minZ >> 4)));
        }
        WeakReference weakRef = (WeakReference)this.customDrawBatchers.get((Object)aabb);
        DrawBatch drawBatch = null;
        if (weakRef != null) {
            drawBatch = (DrawBatch)weakRef.get();
        }
        if (drawBatch == null) {
            if (allowReuse) {
                ObjectIterator iter = this.customDrawBatchers.object2ObjectEntrySet().fastIterator();
                while (iter.hasNext()) {
                    Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)iter.next();
                    AABBi AABB = (AABBi)entry.getKey();
                    if (!AABB.containsAABB(aabb) || (drawBatch = (DrawBatch)((WeakReference)entry.getValue()).get()) == null) continue;
                    return drawBatch;
                }
            }
            DrawBatch newDrawBatch = QuartzCore.INSTANCE.createDrawBatch();
            AABBi finalAABB = new AABBi(aabb);
            newDrawBatch.setCullAABB(finalAABB);
            QuartzCore.CLEANER.register(newDrawBatch, () -> {
                WorldEngine worldEngine = this;
                synchronized (worldEngine) {
                    this.customDrawBatchers.remove((Object)finalAABB);
                }
            });
            this.customDrawBatchers.put((Object)finalAABB, new WeakReference<DrawBatch>(newDrawBatch));
            return newDrawBatch;
        }
        return drawBatch;
    }

    public synchronized DrawBatch getBatcherForSection(long sectionPos) {
        WeakReference weakRef = (WeakReference)this.sectionDrawBatchers.get(sectionPos);
        DrawBatch drawBatch = null;
        if (weakRef != null) {
            drawBatch = (DrawBatch)weakRef.get();
        }
        if (drawBatch == null) {
            DrawBatch newDrawBatch = QuartzCore.INSTANCE.createDrawBatch();
            newDrawBatch.setCullAABB(new AABBi(0, 0, 0, 16, 16, 16).translate(SectionPos.m_123223_((int)SectionPos.m_123213_((long)sectionPos)), SectionPos.m_123223_((int)SectionPos.m_123225_((long)sectionPos)), SectionPos.m_123223_((int)SectionPos.m_123230_((long)sectionPos))));
            QuartzCore.CLEANER.register(newDrawBatch, () -> {
                WorldEngine worldEngine = this;
                synchronized (worldEngine) {
                    this.sectionDrawBatchers.remove(sectionPos);
                }
            });
            this.sectionDrawBatchers.put(sectionPos, new WeakReference<DrawBatch>(newDrawBatch));
            return newDrawBatch;
        }
        return drawBatch;
    }
}

