/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.gl;

import java.nio.FloatBuffer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.roguelogix.phosphophyllite.threading.Event;
import net.roguelogix.phosphophyllite.util.Util;
import net.roguelogix.quartz.internal.QuartzCore;
import net.roguelogix.quartz.internal.common.DrawInfo;
import net.roguelogix.quartz.internal.gl.GLCore;
import net.roguelogix.quartz.internal.gl.GLRenderPass;
import org.lwjgl.opengl.ARBSeparateShaderObjects;
import org.lwjgl.opengl.GL32C;

public class GLMainProgram {
    public final ResourceLocation baseResourceLocation = new ResourceLocation("quartz", "shaders/gl/main");
    private final ResourceLocation vertexShaderLocation = new ResourceLocation(this.baseResourceLocation.m_135827_(), this.baseResourceLocation.m_135815_() + ".vert");
    private final ResourceLocation fragmentShaderLocation = new ResourceLocation(this.baseResourceLocation.m_135827_(), this.baseResourceLocation.m_135815_() + ".frag");
    private final Info info = new Info();
    private int PLAYER_BLOCK_UNIFORM_LOCATION;
    private int PLAYER_SUB_BLOCK_UNIFORM_LOCATION;
    private int PROJECTION_MATRIX_UNIFORM_LOCATION;
    private int VERT_QUAD_UNIFORM_LOCATION;
    private int VERT_LIGHTING_UNIFORM_LOCATION;
    private int DYNAMIC_MATRICES_UNIFORM_LOCATION;
    private int DYNAMIC_LIGHTS_UNIFORM_LOCATION;
    public int OPAQUE_FOG_START_END_UNIFORM_LOCATION;
    public int OPAQUE_FOG_COLOR_UNIFORM_LOCATION;
    public int OPAQUE_QUAD_UNIFORM_LOCATION;
    public int OPAQUE_LIGHTING_UNIFORM_LOCATION;
    public int OPAQUE_TEXTURE_UNIFORM_LOCATION;
    public int OPAQUE_ATLAS_TEXTURE_UNIFORM_LOCATION;
    public int OPAQUE_LIGHTMAP_TEXTURE_UNIFORM_LOCATION;
    public int CUTOUT_FOG_START_END_UNIFORM_LOCATION;
    public int CUTOUT_FOG_COLOR_UNIFORM_LOCATION;
    public int CUTOUT_QUAD_UNIFORM_LOCATION;
    public int CUTOUT_LIGHTING_UNIFORM_LOCATION;
    public int CUTOUT_TEXTURE_UNIFORM_LOCATION;
    public int CUTOUT_ATLAS_TEXTURE_UNIFORM_LOCATION;
    public int CUTOUT_LIGHTMAP_TEXTURE_UNIFORM_LOCATION;
    private int currentAtlas = 0;
    private int currentPipeline = 0;

    public GLMainProgram() {
        Info info = this.info;
        QuartzCore.CLEANER.register(this, () -> GLCore.deletionQueue.enqueue(info::clean, new Event[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        int vertexProgram = 0;
        int opaqueFragmentProgram = 0;
        int cutoutFragmentProgram = 0;
        try {
            String vertexShaderCode = Util.readResourceLocation((ResourceLocation)this.vertexShaderLocation);
            String opaqueFragShaderCode = Util.readResourceLocation((ResourceLocation)this.fragmentShaderLocation);
            if (vertexShaderCode == null || opaqueFragShaderCode == null) {
                throw new IllegalStateException("Failed to load shader code for " + this.baseResourceLocation);
            }
            String vertPrepend = "#define POSITION_LOCATION 0\n#define COLOR_LOCATION 1\n#define TEX_COORD_LOCATION 2\n#define LIGHTINFO_LOCATION 3\n#define WORLD_POSITION_LOCATION 4\n#define DYNAMIC_MATRIX_ID_LOCATION 5\n#define DYNAMIC_LIGHT_ID_LOCATION 6\n#define STATIC_MATRIX_LOCATION 8\n#define STATIC_NORMAL_MATRIX_LOCATION 12\n" + (GLCore.SSBO ? "#define USE_SSBO\n" : "");
            vertexShaderCode = new StringBuilder(vertexShaderCode).insert(vertexShaderCode.indexOf(10) + 1, vertPrepend).toString();
            String cutoutFragShaderCode = new StringBuilder(opaqueFragShaderCode).insert(vertexShaderCode.indexOf(10) + 1, "#define ALPHA_DISCARD\n").toString();
            vertexProgram = ARBSeparateShaderObjects.glCreateShaderProgramv((int)35633, (CharSequence)vertexShaderCode);
            opaqueFragmentProgram = ARBSeparateShaderObjects.glCreateShaderProgramv((int)35632, (CharSequence)opaqueFragShaderCode);
            cutoutFragmentProgram = ARBSeparateShaderObjects.glCreateShaderProgramv((int)35632, (CharSequence)cutoutFragShaderCode);
            int vertLinked = GL32C.glGetProgrami((int)vertexProgram, (int)35714);
            int opaqueFragLinked = GL32C.glGetProgrami((int)opaqueFragmentProgram, (int)35714);
            int cutoutFragLinked = GL32C.glGetProgrami((int)cutoutFragmentProgram, (int)35714);
            if (vertLinked != 1 || opaqueFragLinked != 1 || cutoutFragLinked != 1) {
                StringBuilder error = new StringBuilder();
                if (vertLinked != 1) {
                    error.append("Vertex shader compilation failed for ").append(this.vertexShaderLocation).append('\n').append(GL32C.glGetProgramInfoLog((int)vertexProgram)).append('\n');
                }
                if (opaqueFragmentProgram != 1) {
                    error.append("Opaque fragment shader compilation failed for ").append(this.fragmentShaderLocation).append('\n').append(GL32C.glGetProgramInfoLog((int)opaqueFragmentProgram)).append('\n');
                }
                if (cutoutFragmentProgram != 1) {
                    error.append("Cutout fragment shader compilation failed for ").append(this.fragmentShaderLocation).append('\n').append(GL32C.glGetProgramInfoLog((int)cutoutFragmentProgram)).append('\n');
                }
                throw new IllegalStateException(error.toString());
            }
            ARBSeparateShaderObjects.glDeleteProgramPipelines((int)this.info.opaquePipeline);
            ARBSeparateShaderObjects.glDeleteProgramPipelines((int)this.info.cutoutPipeline);
            this.info.opaquePipeline = ARBSeparateShaderObjects.glGenProgramPipelines();
            ARBSeparateShaderObjects.glUseProgramStages((int)this.info.opaquePipeline, (int)1, (int)vertexProgram);
            ARBSeparateShaderObjects.glUseProgramStages((int)this.info.opaquePipeline, (int)2, (int)opaqueFragmentProgram);
            this.info.cutoutPipeline = ARBSeparateShaderObjects.glGenProgramPipelines();
            ARBSeparateShaderObjects.glUseProgramStages((int)this.info.cutoutPipeline, (int)1, (int)vertexProgram);
            ARBSeparateShaderObjects.glUseProgramStages((int)this.info.cutoutPipeline, (int)2, (int)cutoutFragmentProgram);
            this.info.vertexShader ^= vertexProgram;
            this.info.vertexShader ^= (vertexProgram ^= this.info.vertexShader);
            this.info.opaqueFragmentShader ^= opaqueFragmentProgram;
            this.info.opaqueFragmentShader ^= (opaqueFragmentProgram ^= this.info.opaqueFragmentShader);
            this.info.cutoutFragmentShader ^= cutoutFragmentProgram;
            this.info.cutoutFragmentShader ^= (cutoutFragmentProgram ^= this.info.cutoutFragmentShader);
            this.onReloaded();
        }
        finally {
            GL32C.glDeleteProgram((int)vertexProgram);
            GL32C.glDeleteProgram((int)opaqueFragmentProgram);
            GL32C.glDeleteProgram((int)cutoutFragmentProgram);
        }
    }

    private void onReloaded() {
        this.PLAYER_BLOCK_UNIFORM_LOCATION = GL32C.glGetUniformLocation((int)this.info.vertexShader, (CharSequence)"playerBlock");
        this.PLAYER_SUB_BLOCK_UNIFORM_LOCATION = GL32C.glGetUniformLocation((int)this.info.vertexShader, (CharSequence)"playerSubBlock");
        this.PROJECTION_MATRIX_UNIFORM_LOCATION = GL32C.glGetUniformLocation((int)this.info.vertexShader, (CharSequence)"projectionMatrix");
        this.VERT_QUAD_UNIFORM_LOCATION = GL32C.glGetUniformLocation((int)this.info.vertexShader, (CharSequence)"QUAD");
        this.VERT_LIGHTING_UNIFORM_LOCATION = GL32C.glGetUniformLocation((int)this.info.vertexShader, (CharSequence)"LIGHTING");
        if (!GLCore.SSBO) {
            this.DYNAMIC_MATRICES_UNIFORM_LOCATION = GL32C.glGetUniformLocation((int)this.info.vertexShader, (CharSequence)"dynamicMatrices");
            this.DYNAMIC_LIGHTS_UNIFORM_LOCATION = GL32C.glGetUniformLocation((int)this.info.vertexShader, (CharSequence)"dynamicLights");
        }
        this.OPAQUE_FOG_START_END_UNIFORM_LOCATION = GL32C.glGetUniformLocation((int)this.info.opaqueFragmentShader, (CharSequence)"fogStartEnd");
        this.OPAQUE_FOG_COLOR_UNIFORM_LOCATION = GL32C.glGetUniformLocation((int)this.info.opaqueFragmentShader, (CharSequence)"fogColor");
        this.OPAQUE_QUAD_UNIFORM_LOCATION = GL32C.glGetUniformLocation((int)this.info.opaqueFragmentShader, (CharSequence)"QUAD");
        this.OPAQUE_LIGHTING_UNIFORM_LOCATION = GL32C.glGetUniformLocation((int)this.info.opaqueFragmentShader, (CharSequence)"LIGHTING");
        this.OPAQUE_TEXTURE_UNIFORM_LOCATION = GL32C.glGetUniformLocation((int)this.info.opaqueFragmentShader, (CharSequence)"TEXTURE");
        this.OPAQUE_ATLAS_TEXTURE_UNIFORM_LOCATION = GL32C.glGetUniformLocation((int)this.info.opaqueFragmentShader, (CharSequence)"atlasTexture");
        this.OPAQUE_LIGHTMAP_TEXTURE_UNIFORM_LOCATION = GL32C.glGetUniformLocation((int)this.info.opaqueFragmentShader, (CharSequence)"lightmapTexture");
        this.CUTOUT_FOG_START_END_UNIFORM_LOCATION = GL32C.glGetUniformLocation((int)this.info.cutoutFragmentShader, (CharSequence)"fogStartEnd");
        this.CUTOUT_FOG_COLOR_UNIFORM_LOCATION = GL32C.glGetUniformLocation((int)this.info.cutoutFragmentShader, (CharSequence)"fogColor");
        this.CUTOUT_QUAD_UNIFORM_LOCATION = GL32C.glGetUniformLocation((int)this.info.cutoutFragmentShader, (CharSequence)"QUAD");
        this.CUTOUT_LIGHTING_UNIFORM_LOCATION = GL32C.glGetUniformLocation((int)this.info.cutoutFragmentShader, (CharSequence)"LIGHTING");
        this.CUTOUT_TEXTURE_UNIFORM_LOCATION = GL32C.glGetUniformLocation((int)this.info.cutoutFragmentShader, (CharSequence)"TEXTURE");
        this.CUTOUT_ATLAS_TEXTURE_UNIFORM_LOCATION = GL32C.glGetUniformLocation((int)this.info.cutoutFragmentShader, (CharSequence)"atlasTexture");
        this.CUTOUT_LIGHTMAP_TEXTURE_UNIFORM_LOCATION = GL32C.glGetUniformLocation((int)this.info.cutoutFragmentShader, (CharSequence)"lightmapTexture");
        if (!GLCore.SSBO) {
            ARBSeparateShaderObjects.glProgramUniform1i((int)this.info.vertexShader, (int)this.DYNAMIC_MATRICES_UNIFORM_LOCATION, (int)2);
            ARBSeparateShaderObjects.glProgramUniform1i((int)this.info.vertexShader, (int)this.DYNAMIC_LIGHTS_UNIFORM_LOCATION, (int)3);
        }
        ARBSeparateShaderObjects.glProgramUniform1i((int)this.info.opaqueFragmentShader, (int)this.OPAQUE_ATLAS_TEXTURE_UNIFORM_LOCATION, (int)0);
        ARBSeparateShaderObjects.glProgramUniform1i((int)this.info.opaqueFragmentShader, (int)this.OPAQUE_LIGHTMAP_TEXTURE_UNIFORM_LOCATION, (int)1);
        ARBSeparateShaderObjects.glProgramUniform1i((int)this.info.cutoutFragmentShader, (int)this.CUTOUT_ATLAS_TEXTURE_UNIFORM_LOCATION, (int)0);
        ARBSeparateShaderObjects.glProgramUniform1i((int)this.info.cutoutFragmentShader, (int)this.CUTOUT_LIGHTMAP_TEXTURE_UNIFORM_LOCATION, (int)1);
    }

    public void setupDrawInfo(DrawInfo drawInfo) {
        this.resetBinds();
        ARBSeparateShaderObjects.glProgramUniformMatrix4fv((int)this.info.vertexShader, (int)this.PROJECTION_MATRIX_UNIFORM_LOCATION, (boolean)false, (FloatBuffer)drawInfo.projectionMatrixFloatBuffer);
        ARBSeparateShaderObjects.glProgramUniform3i((int)this.info.vertexShader, (int)this.PLAYER_BLOCK_UNIFORM_LOCATION, (int)drawInfo.playerPosition.x, (int)drawInfo.playerPosition.y, (int)drawInfo.playerPosition.z);
        ARBSeparateShaderObjects.glProgramUniform3f((int)this.info.vertexShader, (int)this.PLAYER_SUB_BLOCK_UNIFORM_LOCATION, (float)drawInfo.playerSubBlock.x, (float)drawInfo.playerSubBlock.y, (float)drawInfo.playerSubBlock.z);
        ARBSeparateShaderObjects.glProgramUniform2f((int)this.info.opaqueFragmentShader, (int)this.OPAQUE_FOG_START_END_UNIFORM_LOCATION, (float)drawInfo.fogStart, (float)drawInfo.fogEnd);
        ARBSeparateShaderObjects.glProgramUniform4f((int)this.info.opaqueFragmentShader, (int)this.OPAQUE_FOG_COLOR_UNIFORM_LOCATION, (float)drawInfo.fogColor.x, (float)drawInfo.fogColor.y, (float)drawInfo.fogColor.z, (float)1.0f);
        ARBSeparateShaderObjects.glProgramUniform2f((int)this.info.cutoutFragmentShader, (int)this.CUTOUT_FOG_START_END_UNIFORM_LOCATION, (float)drawInfo.fogStart, (float)drawInfo.fogEnd);
        ARBSeparateShaderObjects.glProgramUniform4f((int)this.info.cutoutFragmentShader, (int)this.CUTOUT_FOG_COLOR_UNIFORM_LOCATION, (float)drawInfo.fogColor.x, (float)drawInfo.fogColor.y, (float)drawInfo.fogColor.z, (float)1.0f);
    }

    public void setupRenderPass(GLRenderPass renderPass) {
        int id;
        AbstractTexture texture;
        int pipeline;
        ARBSeparateShaderObjects.glProgramUniform1i((int)this.info.vertexShader, (int)this.VERT_QUAD_UNIFORM_LOCATION, (int)(renderPass.QUAD ? 1 : 0));
        ARBSeparateShaderObjects.glProgramUniform1i((int)this.info.vertexShader, (int)this.VERT_LIGHTING_UNIFORM_LOCATION, (int)(renderPass.LIGHTING ? 1 : 0));
        boolean OPAQUE = !renderPass.ALPHA_DISCARD;
        ARBSeparateShaderObjects.glProgramUniform1i((int)(OPAQUE ? this.info.opaqueFragmentShader : this.info.cutoutFragmentShader), (int)(OPAQUE ? this.OPAQUE_QUAD_UNIFORM_LOCATION : this.CUTOUT_QUAD_UNIFORM_LOCATION), (int)(renderPass.QUAD ? 1 : 0));
        ARBSeparateShaderObjects.glProgramUniform1i((int)(OPAQUE ? this.info.opaqueFragmentShader : this.info.cutoutFragmentShader), (int)(OPAQUE ? this.OPAQUE_LIGHTING_UNIFORM_LOCATION : this.CUTOUT_LIGHTING_UNIFORM_LOCATION), (int)(renderPass.LIGHTING ? 1 : 0));
        ARBSeparateShaderObjects.glProgramUniform1i((int)(OPAQUE ? this.info.opaqueFragmentShader : this.info.cutoutFragmentShader), (int)(OPAQUE ? this.OPAQUE_TEXTURE_UNIFORM_LOCATION : this.CUTOUT_TEXTURE_UNIFORM_LOCATION), (int)(renderPass.TEXTURE ? 1 : 0));
        int n = pipeline = OPAQUE ? this.info.opaquePipeline : this.info.cutoutPipeline;
        if (pipeline != this.currentPipeline) {
            this.currentAtlas = 0;
            ARBSeparateShaderObjects.glBindProgramPipeline((int)pipeline);
            this.currentPipeline = pipeline;
        }
        if ((texture = renderPass.texture()) != null && (id = texture.m_117963_()) != this.currentAtlas) {
            GL32C.glBindTexture((int)3553, (int)id);
            this.currentAtlas = id;
        }
    }

    public void resetBinds() {
        this.currentPipeline = 0;
        ARBSeparateShaderObjects.glBindProgramPipeline((int)0);
    }

    private static class Info {
        private int vertexShader = 0;
        private int opaqueFragmentShader = 0;
        private int cutoutFragmentShader = 0;
        private int opaquePipeline = 0;
        private int cutoutPipeline = 0;

        private Info() {
        }

        void clean() {
            GL32C.glDeleteProgram((int)this.vertexShader);
            GL32C.glDeleteProgram((int)this.opaqueFragmentShader);
            GL32C.glDeleteProgram((int)this.cutoutFragmentShader);
            ARBSeparateShaderObjects.glDeleteProgramPipelines((int)this.opaquePipeline);
            ARBSeparateShaderObjects.glDeleteProgramPipelines((int)this.cutoutPipeline);
        }
    }
}

