/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.gl;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.roguelogix.phosphophyllite.threading.Event;
import net.roguelogix.phosphophyllite.util.MethodsReturnNonnullByDefault;
import net.roguelogix.quartz.internal.Buffer;
import net.roguelogix.quartz.internal.QuartzCore;
import net.roguelogix.quartz.internal.common.B3DStateHelper;
import net.roguelogix.quartz.internal.gl.GLCore;
import org.lwjgl.opengl.GL33C;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.libc.LibCString;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GLBuffer
implements Buffer {
    private final int buffer;
    private final int usage;
    private int size;
    private final ByteBuffer[] byteBuffer = new ByteBuffer[1];
    private final ObjectArrayList<Runnable> slicers = new ObjectArrayList();
    private final ObjectArrayList<Allocation.Info> liveAllocations = new ObjectArrayList();
    private final ObjectArrayList<Allocation.Info> freeAllocations = new ObjectArrayList<Allocation.Info>(){

        public boolean add(@Nullable Allocation.Info allocation) {
            if (allocation == null) {
                return false;
            }
            int index = Collections.binarySearch(this, allocation);
            if (index < 0) {
                super.add(index ^= 0xFFFFFFFF, (Object)allocation);
            } else {
                super.set(index, (Object)allocation);
            }
            return true;
        }
    };
    private final ObjectArrayList<Consumer<Buffer>> reallocCallbacks = new ObjectArrayList();
    private int minDirty = Integer.MAX_VALUE;
    private int maxDirty = 0;

    public GLBuffer(boolean dynamic, int initialSize) {
        if (initialSize <= 0) {
            throw new IllegalArgumentException("Initial buffer size must be greater than 0");
        }
        this.size = initialSize;
        this.usage = dynamic ? 35048 : 35044;
        this.buffer = GL33C.glGenBuffers();
        B3DStateHelper.bindArrayBuffer(this.buffer);
        GL33C.glBufferData((int)34962, (long)initialSize, (int)this.usage);
        this.byteBuffer[0] = MemoryUtil.memAlloc((int)initialSize);
        this.freeAllocations.add((Object)new Allocation.Info(0, initialSize));
        ByteBuffer[] bufArray = this.byteBuffer;
        int buffer = this.buffer;
        QuartzCore.CLEANER.register(this, () -> {
            MemoryUtil.memFree((java.nio.Buffer)bufArray[0]);
            GLCore.deletionQueue.enqueue(() -> GL33C.glDeleteBuffers((int)buffer), new Event[0]);
        });
    }

    public GLBuffer(boolean dynamic) {
        this(dynamic, 1);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Allocation alloc(int size) {
        return this.alloc(size, 1);
    }

    @Override
    public Allocation alloc(int size, int alignment) {
        Pair<Allocation.Info, Allocation.Info> newAllocs;
        int alignmentBitmask = alignment - 1;
        this.collapseFreeAllocations();
        for (int i = 0; i < this.freeAllocations.size(); ++i) {
            Pair<Allocation.Info, Allocation.Info> newAllocs2;
            Allocation.Info freeAlloc = (Allocation.Info)this.freeAllocations.get(i);
            int nextValidAlignment = freeAlloc.offset + (alignment - 1) & -alignment;
            int alignmentWaste = nextValidAlignment - freeAlloc.offset;
            if (freeAlloc.size - alignmentWaste < size) continue;
            this.freeAllocations.remove(i);
            if (alignmentWaste > 0) {
                newAllocs2 = freeAlloc.split(alignmentWaste);
                this.freeAllocations.add((Object)((Allocation.Info)newAllocs2.getFirst()));
                freeAlloc = (Allocation.Info)newAllocs2.getSecond();
            }
            if (freeAlloc.size > size) {
                newAllocs2 = freeAlloc.split(size);
                freeAlloc = (Allocation.Info)newAllocs2.getFirst();
                this.freeAllocations.add((Object)((Allocation.Info)newAllocs2.getSecond()));
            }
            this.liveAllocations.add((Object)freeAlloc);
            return new Allocation(freeAlloc);
        }
        int endOffset = this.size;
        int minSize = this.size + size;
        if (!this.freeAllocations.isEmpty()) {
            Allocation.Info endAlloc = (Allocation.Info)this.freeAllocations.get(this.freeAllocations.size() - 1);
            if (endAlloc.offset + endAlloc.size == this.size) {
                minSize -= endAlloc.size;
                endOffset = endAlloc.offset;
            }
        }
        int alignmentWaste = endOffset & alignmentBitmask;
        this.expand(minSize += alignmentWaste);
        Allocation.Info alloc = (Allocation.Info)this.freeAllocations.pop();
        if (alignmentWaste > 0) {
            newAllocs = alloc.split(alignmentWaste);
            this.freeAllocations.add((Object)((Allocation.Info)newAllocs.getFirst()));
            alloc = (Allocation.Info)newAllocs.getSecond();
        }
        if (alloc.size > size) {
            newAllocs = alloc.split(size);
            alloc = (Allocation.Info)newAllocs.getFirst();
            this.freeAllocations.add((Object)((Allocation.Info)newAllocs.getSecond()));
        }
        this.liveAllocations.add((Object)alloc);
        return new Allocation(alloc);
    }

    public Allocation realloc(@Nullable Allocation allocation, int newSize) {
        return this.realloc(allocation, newSize, 1);
    }

    @Override
    public Buffer.Allocation realloc(@Nullable Buffer.Allocation bufAlloc, int newSize, int alignment) {
        if (!(bufAlloc instanceof Allocation)) {
            throw new IllegalArgumentException("Cannot realloc allocation from another buffer");
        }
        Allocation alloc = (Allocation)bufAlloc;
        return this.realloc(alloc, newSize, alignment);
    }

    public Allocation realloc(@Nullable Allocation allocation, int newSize, int alignment) {
        int i;
        if (allocation == null) {
            return this.alloc(newSize, alignment);
        }
        if (allocation.allocator() != this) {
            throw new IllegalArgumentException("Cannot realloc allocation from another buffer");
        }
        int liveIndex = this.liveAllocations.indexOf((Object)allocation.info);
        if (liveIndex == -1) {
            throw new IllegalArgumentException("Cannot realloc non-live allocation");
        }
        if (newSize <= allocation.info.size && (allocation.info.offset & alignment - 1) == 0) {
            int i2;
            if (newSize == allocation.info.size) {
                return allocation;
            }
            Allocation.Info removed = (Allocation.Info)this.liveAllocations.pop();
            if (liveIndex != this.liveAllocations.size()) {
                this.liveAllocations.set(liveIndex, (Object)removed);
            }
            Pair<Allocation.Info, Allocation.Info> newAllocInfos = allocation.info.split(newSize);
            Allocation.Info newAllocInfo = (Allocation.Info)newAllocInfos.getFirst();
            Allocation.Info freeAllocInfo = (Allocation.Info)newAllocInfos.getSecond();
            Allocation newAlloc = new Allocation(newAllocInfo);
            this.freeAllocations.add((Object)freeAllocInfo);
            this.liveAllocations.add((Object)newAllocInfo);
            long dstAddress = MemoryUtil.memAddress((ByteBuffer)newAlloc.byteBuffer[0]);
            long srcAddress = MemoryUtil.memAddress((ByteBuffer)allocation.byteBuffer[0]);
            int size = Math.min(newAlloc.byteBuffer[0].remaining(), allocation.byteBuffer[0].remaining());
            if (srcAddress != dstAddress) {
                LibCString.nmemmove((long)dstAddress, (long)srcAddress, (long)size);
                newAlloc.dirty();
            }
            for (i2 = 0; i2 < allocation.reallocCallbacks.size(); ++i2) {
                newAlloc.addReallocCallback((Consumer)allocation.reallocCallbacks.get(i2));
            }
            for (i2 = 0; i2 < allocation.sliceCallbacks.size(); ++i2) {
                newAlloc.addBufferSliceCallback((Consumer)allocation.sliceCallbacks.get(i2));
            }
            return newAlloc;
        }
        this.collapseFreeAllocations();
        Allocation.Info precedingAlloc = null;
        Allocation.Info followingAlloc = null;
        for (int i3 = 0; i3 < this.freeAllocations.size(); ++i3) {
            Allocation.Info freeAllocation = (Allocation.Info)this.freeAllocations.get(i3);
            if (freeAllocation.offset + freeAllocation.size == allocation.info.offset) {
                precedingAlloc = freeAllocation;
                continue;
            }
            if (freeAllocation.offset == allocation.info.offset + allocation.info.size) {
                followingAlloc = freeAllocation;
                break;
            }
            if (freeAllocation.offset > allocation.info.offset) break;
        }
        int fullBlockOffset = precedingAlloc == null ? allocation.info.offset : precedingAlloc.offset;
        int nextValidAlignment = fullBlockOffset + (alignment - 1) & -alignment;
        int alignmentWaste = nextValidAlignment - fullBlockOffset;
        int fullBlockSize = allocation.info.size;
        if (precedingAlloc != null) {
            fullBlockSize += precedingAlloc.size;
        }
        if (followingAlloc != null) {
            fullBlockSize += followingAlloc.size;
        } else if (allocation.info.offset + allocation.info.size == this.size) {
            this.freeAllocations.remove((Object)precedingAlloc);
            int minSize = fullBlockOffset + alignmentWaste + newSize;
            this.expand(minSize);
            followingAlloc = (Allocation.Info)this.freeAllocations.get(this.freeAllocations.size() - 1);
            fullBlockSize += followingAlloc.size;
        }
        if (fullBlockSize - alignmentWaste >= newSize) {
            int i4;
            Pair<Allocation.Info, Allocation.Info> newAllocs;
            this.freeAllocations.remove((Object)precedingAlloc);
            this.freeAllocations.remove((Object)followingAlloc);
            Allocation.Info newAllocInfo = new Allocation.Info(fullBlockOffset, fullBlockSize);
            if (alignmentWaste > 0) {
                newAllocs = newAllocInfo.split(alignmentWaste);
                this.freeAllocations.add((Object)((Allocation.Info)newAllocs.getFirst()));
                newAllocInfo = (Allocation.Info)newAllocs.getSecond();
            }
            if (newAllocInfo.size > newSize) {
                newAllocs = newAllocInfo.split(newSize);
                newAllocInfo = (Allocation.Info)newAllocs.getFirst();
                this.freeAllocations.add((Object)((Allocation.Info)newAllocs.getSecond()));
            }
            Allocation newAlloc = new Allocation(newAllocInfo);
            Allocation.Info removed = (Allocation.Info)this.liveAllocations.pop();
            if (liveIndex != this.liveAllocations.size()) {
                this.liveAllocations.set(liveIndex, (Object)removed);
            }
            this.liveAllocations.add((Object)newAllocInfo);
            long dstAddress = MemoryUtil.memAddress((ByteBuffer)newAlloc.byteBuffer[0]);
            long srcAddress = MemoryUtil.memAddress((ByteBuffer)allocation.byteBuffer[0]);
            int size = Math.min(newAlloc.byteBuffer[0].remaining(), allocation.byteBuffer[0].remaining());
            if (srcAddress != dstAddress) {
                LibCString.nmemmove((long)dstAddress, (long)srcAddress, (long)size);
                newAlloc.dirty();
            }
            for (i4 = 0; i4 < allocation.reallocCallbacks.size(); ++i4) {
                newAlloc.addReallocCallback((Consumer)allocation.reallocCallbacks.get(i4));
            }
            for (i4 = 0; i4 < allocation.sliceCallbacks.size(); ++i4) {
                newAlloc.addBufferSliceCallback((Consumer)allocation.sliceCallbacks.get(i4));
            }
            return newAlloc;
        }
        Allocation newAlloc = this.alloc(newSize, alignment);
        long dstAddress = MemoryUtil.memAddress((ByteBuffer)newAlloc.byteBuffer[0]);
        long srcAddress = MemoryUtil.memAddress((ByteBuffer)allocation.byteBuffer[0]);
        int size = Math.min(newAlloc.byteBuffer[0].remaining(), allocation.byteBuffer[0].remaining());
        LibCString.nmemcpy((long)dstAddress, (long)srcAddress, (long)size);
        newAlloc.dirty();
        this.free(allocation);
        for (i = 0; i < allocation.reallocCallbacks.size(); ++i) {
            newAlloc.addReallocCallback((Consumer)allocation.reallocCallbacks.get(i));
        }
        for (i = 0; i < allocation.sliceCallbacks.size(); ++i) {
            newAlloc.addBufferSliceCallback((Consumer)allocation.sliceCallbacks.get(i));
        }
        return newAlloc;
    }

    @Override
    public void addGPUReallocCallback(Consumer<Buffer> consumer) {
    }

    @Override
    public void free(Buffer.Allocation allocation) {
        if (allocation instanceof Allocation) {
            Allocation alloc = (Allocation)allocation;
            this.free(alloc);
        }
    }

    public void free(Allocation allocation) {
        this.free(allocation.info);
    }

    public void free(Allocation.Info allocation) {
        int index = this.liveAllocations.indexOf((Object)allocation);
        if (index == -1) {
            return;
        }
        Allocation.Info removed = (Allocation.Info)this.liveAllocations.pop();
        if (index != this.liveAllocations.size()) {
            this.liveAllocations.set(index, (Object)removed);
        }
        this.freeAllocations.add((Object)allocation);
        index = this.freeAllocations.indexOf((Object)allocation);
        this.collapseFreeAllocationWithNext(index - 1);
        this.collapseFreeAllocationWithNext(index);
    }

    @Override
    public void dirtyAll() {
        this.minDirty = 0;
        this.maxDirty = this.size;
    }

    public void dirtyRange(int min, int max) {
        this.minDirty = Math.min(min, this.minDirty);
        this.maxDirty = Math.max(max, this.maxDirty);
    }

    public void flush() {
        if (this.minDirty >= this.maxDirty) {
            return;
        }
        B3DStateHelper.bindArrayBuffer(this.buffer);
        GL33C.nglBufferSubData((int)34962, (long)this.minDirty, (long)(this.maxDirty - this.minDirty), (long)(MemoryUtil.memAddress((ByteBuffer)this.byteBuffer[0]) + (long)this.minDirty));
        this.minDirty = Integer.MAX_VALUE;
        this.maxDirty = 0;
    }

    @Override
    public void addCPUReallocCallback(Consumer<Buffer> consumer) {
        this.reallocCallbacks.add(consumer);
    }

    public int handle() {
        return this.buffer;
    }

    private void expand(int minSize) {
        if (this.size >= minSize) {
            return;
        }
        int oldSize = this.size;
        this.size = Integer.highestOneBit(minSize);
        if (this.size < minSize) {
            this.size <<= 1;
        }
        this.byteBuffer[0] = MemoryUtil.memRealloc((ByteBuffer)this.byteBuffer[0], (int)this.size);
        B3DStateHelper.bindArrayBuffer(this.buffer);
        GL33C.glBufferData((int)34962, (ByteBuffer)this.byteBuffer[0], (int)this.usage);
        this.freeAllocations.add((Object)new Allocation.Info(oldSize, this.size - oldSize));
        this.collapseFreeAllocationWithNext(this.freeAllocations.size() - 2);
        this.slicers.forEach(Runnable::run);
        this.reallocCallbacks.forEach(c -> c.accept(this));
    }

    private boolean collapseFreeAllocationWithNext(int freeAllocationIndex) {
        if (freeAllocationIndex < 0 || freeAllocationIndex >= this.freeAllocations.size() - 1) {
            return false;
        }
        Allocation.Info allocA = (Allocation.Info)this.freeAllocations.get(freeAllocationIndex);
        Allocation.Info allocB = (Allocation.Info)this.freeAllocations.get(freeAllocationIndex + 1);
        if (allocA.offset + allocA.size == allocB.offset) {
            this.freeAllocations.remove(freeAllocationIndex + 1);
            this.freeAllocations.remove(freeAllocationIndex);
            this.freeAllocations.add((Object)new Allocation.Info(allocA.offset, allocA.size + allocB.size));
            return true;
        }
        return false;
    }

    private void collapseFreeAllocations() {
        for (int i = 0; i < this.freeAllocations.size(); ++i) {
            if (!this.collapseFreeAllocationWithNext(i)) continue;
            --i;
        }
    }

    public class Allocation
    implements Buffer.Allocation {
        private final Info info;
        private final ByteBuffer[] byteBuffer;
        private final ObjectArrayList<Consumer<Buffer.Allocation>> reallocCallbacks = new ObjectArrayList();
        private final ObjectArrayList<Consumer<Buffer.Allocation>> sliceCallbacks;
        private final Runnable slicer;

        protected Allocation(Info info) {
            this.info = info;
            GLBuffer allocator = GLBuffer.this;
            ByteBuffer[] byteBuffer = new ByteBuffer[1];
            ObjectArrayList sliceCallbacks = new ObjectArrayList();
            WeakReference<Allocation> weakRef = new WeakReference<Allocation>(this);
            Runnable slicer = () -> {
                byteBuffer[0] = allocator.byteBuffer[0].slice(info.offset, info.size);
                byteBuffer[0].order(ByteOrder.nativeOrder());
                Allocation alloc = (Allocation)weakRef.get();
                if (alloc == null) {
                    return;
                }
                for (int i = 0; i < sliceCallbacks.size(); ++i) {
                    ((Consumer)sliceCallbacks.get(i)).accept(alloc);
                }
            };
            QuartzCore.CLEANER.register(this, () -> GLCore.deletionQueue.enqueue(() -> {
                allocator.free(info);
                allocator.slicers.remove((Object)slicer);
            }, new Event[0]));
            slicer.run();
            allocator.slicers.add((Object)slicer);
            this.byteBuffer = byteBuffer;
            this.sliceCallbacks = sliceCallbacks;
            this.slicer = slicer;
        }

        public void delete() {
            GLBuffer.this.free(this.info);
            GLBuffer.this.slicers.remove((Object)this.slicer);
        }

        @Override
        public ByteBuffer buffer() {
            return this.byteBuffer[0].rewind();
        }

        @Override
        public int offset() {
            return this.info.offset;
        }

        @Override
        public int size() {
            return this.info.size;
        }

        @Override
        public void dirty() {
            this.dirtyRange(0, this.info.size);
        }

        @Override
        public void dirtyRange(int offset, int size) {
            GLBuffer.this.dirtyRange(this.info.offset + offset, this.info.offset + offset + size);
        }

        @Override
        public GLBuffer allocator() {
            return GLBuffer.this;
        }

        @Override
        public void copy(int srcOffset, int dstOffset, int size) {
            long address = MemoryUtil.memAddress((ByteBuffer)this.byteBuffer[0]);
            long srcAddress = address + (long)srcOffset;
            long dstAddress = address + (long)dstOffset;
            LibCString.nmemmove((long)dstAddress, (long)srcAddress, (long)size);
            this.dirtyRange(dstOffset, size);
        }

        @Override
        public void addReallocCallback(Consumer<Buffer.Allocation> consumer) {
            consumer.accept(this);
            this.reallocCallbacks.add(consumer);
        }

        @Override
        public void addBufferSliceCallback(Consumer<Buffer.Allocation> consumer) {
            consumer.accept(this);
            this.sliceCallbacks.add(consumer);
        }

        @Override
        public void lock() {
        }

        @Override
        public void unlock() {
        }

        public int compareTo(Allocation other) {
            return Integer.compare(this.info.offset, other.info.offset);
        }

        private record Info(int offset, int size) implements Comparable<Info>
        {
            @Override
            public int compareTo(@Nonnull Info info) {
                return Integer.compare(this.offset, info.offset);
            }

            private Pair<Info, Info> split(int size) {
                if (size > this.size) {
                    throw new IllegalArgumentException("Cannot split allocation to larger size");
                }
                if (size == this.size) {
                    return new Pair((Object)new Info(this.offset, size), null);
                }
                return new Pair((Object)new Info(this.offset, size), (Object)new Info(this.offset + size, this.size - size));
            }
        }
    }
}

