/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.common;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.level.BlockAndTintGetter;
import net.roguelogix.phosphophyllite.util.MethodsReturnNonnullByDefault;
import net.roguelogix.quartz.DynamicLight;
import net.roguelogix.quartz.internal.Buffer;
import net.roguelogix.quartz.internal.QuartzCore;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class DynamicLightManager
implements DynamicLight.Manager {
    private final Buffer buffer;
    private final ObjectArrayList<WeakReference<Light>> lights = new ObjectArrayList();

    public DynamicLightManager(Buffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public Light createLight(DynamicLight.UpdateFunc updateFunc) {
        return new Light(this.buffer.alloc(128, 128), this.lights, updateFunc);
    }

    public Buffer buffer() {
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAll(BlockAndTintGetter blockAndTintGetter) {
        ObjectArrayList<WeakReference<Light>> objectArrayList = this.lights;
        synchronized (objectArrayList) {
            for (int i = 0; i < this.lights.size(); ++i) {
                Light light = (Light)((WeakReference)this.lights.get(i)).get();
                if (light == null) continue;
                light.update(blockAndTintGetter);
            }
        }
    }

    @Override
    public boolean owns(@Nullable DynamicLight dynamicLight) {
        if (dynamicLight instanceof Light) {
            Light light = (Light)dynamicLight;
            return light.allocation.allocator() == this.buffer;
        }
        return false;
    }

    public static class Light
    implements DynamicLight {
        final Buffer.Allocation allocation;
        ByteBuffer buffer;
        final DynamicLight.UpdateFunc updateCall;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Light(Buffer.Allocation allocation, ObjectArrayList<WeakReference<Light>> lights, DynamicLight.UpdateFunc updateCall) {
            this.allocation = allocation;
            this.updateCall = updateCall;
            WeakReference<Light> ref = new WeakReference<Light>(this);
            ObjectArrayList<WeakReference<Light>> objectArrayList = lights;
            synchronized (objectArrayList) {
                lights.add(ref);
            }
            allocation.addBufferSliceCallback(alloc -> {
                Light light = (Light)ref.get();
                if (light != null) {
                    light.buffer = alloc.buffer();
                }
            });
            QuartzCore.CLEANER.register(this, () -> {
                ObjectArrayList objectArrayList = lights;
                synchronized (objectArrayList) {
                    int index = lights.indexOf((Object)ref);
                    if (index != -1 && index != lights.size()) {
                        lights.set(index, (Object)((WeakReference)lights.pop()));
                    }
                }
            });
        }

        @Override
        public void write(int vertex, int vertexDirection, byte skyLight, byte blockLight, byte AO) {
            blockLight = (byte)(blockLight & 0x3F);
            skyLight = (byte)(skyLight & 0x3F);
            AO = (byte)(AO & 3);
            blockLight = (byte)(blockLight | AO << 6);
            vertexDirection += 2;
            vertexDirection &= 0xFF;
            this.buffer.put((vertex &= 7) * 12 + (vertexDirection -= 2) * 2, blockLight);
            this.buffer.put(vertex * 12 + vertexDirection * 2 + 1, skyLight);
        }

        @Override
        public void update(BlockAndTintGetter blockAndTintGetter) {
            if (this.updateCall != null) {
                this.updateCall.accept(this, blockAndTintGetter);
                this.allocation.dirty();
            }
        }

        public int id() {
            return this.allocation.offset() / 128;
        }
    }
}

