/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.management;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.network.chat.TranslatableComponent;

public class StructureName {
    public static List<String> HUTS = Collections.synchronizedList(new ArrayList());
    private static final Pattern levelPattern = Pattern.compile("[^0-9]+([0-9]+)$");
    private static final String LOCALIZED_SCHEMATIC_LEVEL = "com.ldtteam.structurize.gui.buildtool.hut.level";
    private String section = "";
    private String prefix = "";
    private String style = "";
    private String schematic = "";
    private String hut = "";

    public StructureName(String structureName) {
        this.init(structureName);
    }

    public StructureName(String prefix, String style, String schematic) {
        StringBuilder name = new StringBuilder(prefix);
        if (style != null && !style.isEmpty()) {
            name.append("/").append(style);
        }
        name.append("/").append(schematic);
        this.init(name.toString());
    }

    private void init(String structureName) {
        if (structureName.isEmpty()) {
            return;
        }
        Object name = structureName;
        if (((String)name).startsWith("scans/")) {
            this.prefix = "scans";
        } else if (((String)name).startsWith("cache/")) {
            this.prefix = "cache";
        } else {
            if (!((String)name).startsWith("schematics/")) {
                name = "schematics/" + (String)name;
            }
            this.prefix = "schematics";
        }
        name = ((String)name).substring(this.prefix.length() + 1);
        int lastSeparator = ((String)name).lastIndexOf("/");
        if (lastSeparator == -1) {
            this.schematic = name;
        } else {
            this.style = ((String)name).substring(0, lastSeparator);
            this.schematic = ((String)name).substring(lastSeparator + 1);
        }
        this.section = this.prefix;
        if (this.prefix.equals("schematics")) {
            this.hut = this.schematic.split("\\d+")[0].toLowerCase(Locale.ROOT);
            this.section = "schematics";
            if (HUTS.contains(this.hut)) {
                this.section = this.hut;
            } else {
                this.hut = "";
            }
        }
    }

    public String getHutName() {
        return this.hut;
    }

    public String getSection() {
        return this.section;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getStyle() {
        return this.style;
    }

    public String getSchematic() {
        return this.schematic;
    }

    public String getLocalizedName() {
        Matcher matcher;
        if (this.isHut() && (matcher = levelPattern.matcher(this.schematic)).find()) {
            int level = Integer.parseInt(matcher.group(1));
            return new TranslatableComponent(LOCALIZED_SCHEMATIC_LEVEL, new Object[]{level}).getString();
        }
        return this.schematic;
    }

    public boolean isHut() {
        return !this.hut.isEmpty();
    }

    public String toString() {
        if (this.style == null || this.style.isEmpty()) {
            return this.prefix + "/" + this.schematic;
        }
        return this.prefix + "/" + this.style + "/" + this.schematic;
    }
}

