/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.helpers;

import com.ldtteam.structurize.api.util.BlockPosUtil;
import com.ldtteam.structurize.api.util.Shape;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.placement.structure.CreativeStructureHandler;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.PlacementSettings;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

public final class Settings
implements INBTSerializable<CompoundTag> {
    public static final Settings instance = new Settings();
    private BlockPos pos = null;
    private boolean isMirrored = false;
    @Nullable
    private Blueprint blueprint = null;
    private int rotation = 0;
    private String structureName = null;
    private Optional<BlockPos> anchorPos = Optional.empty();
    private int groundOffset = 0;
    private String style = "";
    private int width = 1;
    private int height = 1;
    private int length = 1;
    private int frequency = 1;
    private String equation = "";
    private boolean hollow = false;
    private Shape shape = Shape.CUBE;
    private Tuple<BlockPos, BlockPos> box = null;
    private boolean staticSchematicMode = false;
    private String staticSchematicName = null;
    private Tuple<ItemStack, ItemStack> stack = new Tuple((Object)new ItemStack((ItemLike)Blocks.f_50074_), (Object)new ItemStack((ItemLike)Blocks.f_50074_));
    private boolean shouldRefresh = false;
    private boolean receivedInfo;
    private boolean isStructurizePass = false;
    private boolean renderLightPlaceholders;

    private Settings() {
    }

    public void startStructurizePass() {
        this.isStructurizePass = true;
    }

    public void endStructurizePass() {
        this.isStructurizePass = false;
    }

    public boolean isStructurizePass() {
        return this.isStructurizePass;
    }

    public boolean shouldRefresh() {
        if (!this.isStructurizePass()) {
            return false;
        }
        boolean ret = this.shouldRefresh;
        this.shouldRefresh = false;
        return ret;
    }

    public void scheduleRefresh() {
        this.shouldRefresh = true;
    }

    public void setupStaticMode(String name) {
        this.staticSchematicMode = true;
        this.staticSchematicName = name;
    }

    public BlockPos getPosition() {
        return this.pos;
    }

    public int getGroundOffset() {
        return this.groundOffset;
    }

    @Nullable
    public Tuple<BlockPos, BlockPos> getBox() {
        return this.box;
    }

    public void setBox(Tuple<BlockPos, BlockPos> box) {
        this.box = box;
    }

    public void setPosition(BlockPos position) {
        this.pos = position;
    }

    public void setGroundOffset(int offset) {
        this.pos = this.pos.m_6625_(this.groundOffset);
        this.groundOffset = offset;
        this.pos = this.pos.m_6630_(this.groundOffset);
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public int getWidth() {
        return this.width;
    }

    public int getLength() {
        return this.length;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void moveTo(BlockPos pos) {
        if (this.blueprint == null) {
            return;
        }
        this.pos = this.pos.m_141952_((Vec3i)pos);
    }

    @Nullable
    public Blueprint getActiveStructure() {
        CreativeStructureHandler structure;
        if (this.blueprint == null && this.structureName != null && !this.structureName.isEmpty() && this.pos != null && (structure = new CreativeStructureHandler((Level)Minecraft.m_91087_().f_91073_, new BlockPos(0, 0, 0), this.structureName, new PlacementSettings(instance.getMirror(), BlockUtils.getRotation(instance.getRotation())), true)).hasBluePrint()) {
            this.blueprint = structure.getBluePrint();
        }
        return this.blueprint;
    }

    public void setActiveSchematic(Blueprint blueprint) {
        if (blueprint == null) {
            this.resetBlueprint();
        } else {
            this.blueprint = blueprint;
            this.blueprint.rotateWithMirror(BlockPosUtil.getRotationFromRotations(this.rotation), this.isMirrored ? Mirror.FRONT_BACK : Mirror.NONE, (Level)Minecraft.m_91087_().f_91073_);
        }
    }

    public void reset() {
        this.resetBlueprint();
        this.rotation = 0;
        this.isMirrored = false;
        this.hollow = false;
        this.structureName = null;
        this.pos = null;
        this.groundOffset = 0;
        this.box = null;
        this.equation = "";
    }

    public void softReset() {
        this.resetBlueprint();
        this.hollow = false;
        this.structureName = null;
        this.pos = null;
        this.groundOffset = 0;
        this.box = null;
        this.equation = "";
    }

    public void resetBlueprint() {
        this.blueprint = null;
        this.staticSchematicMode = false;
        this.staticSchematicName = null;
    }

    public void setSchematicInfo(String structureName, int rotation) {
        this.structureName = structureName;
        this.rotation = rotation;
    }

    public String getStructureName() {
        return this.structureName;
    }

    public void setStructureName(String structureName) {
        this.structureName = structureName;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        int offset = rotation - this.rotation;
        this.rotation = rotation;
        if (this.blueprint != null) {
            this.blueprint.rotateWithMirror(offset == 1 || offset == -3 ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90, Mirror.NONE, (Level)Minecraft.m_91087_().f_91073_);
        }
        this.scheduleRefresh();
    }

    public void mirror() {
        if (this.blueprint == null) {
            return;
        }
        this.isMirrored = !this.isMirrored;
        this.blueprint.rotateWithMirror(Rotation.NONE, this.rotation % 2 == 0 ? Mirror.FRONT_BACK : Mirror.LEFT_RIGHT, (Level)Minecraft.m_91087_().f_91073_);
        this.scheduleRefresh();
    }

    public Mirror getMirror() {
        if (this.isMirrored) {
            return Mirror.FRONT_BACK;
        }
        return Mirror.NONE;
    }

    public boolean isStaticSchematicMode() {
        return this.staticSchematicMode;
    }

    public String getStaticSchematicName() {
        return this.staticSchematicName;
    }

    public void setShape(String s) {
        this.shape = Shape.valueOf(s);
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setBlock(ItemStack s, boolean mainBlock) {
        this.stack = mainBlock ? new Tuple((Object)s, (Object)((ItemStack)this.stack.m_14419_())) : new Tuple((Object)((ItemStack)this.stack.m_14418_()), (Object)s);
    }

    public ItemStack getBlock(boolean main) {
        return main ? (ItemStack)this.stack.m_14418_() : (ItemStack)this.stack.m_14419_();
    }

    public boolean isHollow() {
        return this.hollow;
    }

    public void setHollow(boolean hollow) {
        this.hollow = hollow;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.isMirrored = nbt.m_128471_("mirror");
        this.staticSchematicMode = nbt.m_128471_("static");
        this.hollow = nbt.m_128471_("hollow");
        this.renderLightPlaceholders = nbt.m_128471_("renderLight");
        this.groundOffset = nbt.m_128451_("gnd");
        this.rotation = nbt.m_128451_("rot");
        this.width = nbt.m_128451_("w");
        this.height = nbt.m_128451_("h");
        this.length = nbt.m_128451_("len");
        this.frequency = nbt.m_128451_("freq");
        this.shape = nbt.m_128441_("shape") ? Shape.values()[nbt.m_128451_("shape")] : Shape.CUBE;
        this.pos = nbt.m_128441_("pos") ? NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("pos")) : null;
        this.box = nbt.m_128441_("box") ? new Tuple((Object)NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("box")), (Object)NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("box2"))) : null;
        this.structureName = nbt.m_128441_("struct_name") ? nbt.m_128461_("struct_name") : null;
        this.staticSchematicName = nbt.m_128441_("static_name") ? nbt.m_128461_("static_name") : null;
        this.stack = nbt.m_128441_("stack") ? new Tuple((Object)ItemStack.m_41712_((CompoundTag)nbt.m_128469_("stack")), (Object)ItemStack.m_41712_((CompoundTag)nbt.m_128469_("stack2"))) : new Tuple((Object)new ItemStack((ItemLike)Blocks.f_50074_), (Object)new ItemStack((ItemLike)Blocks.f_50074_));
        if (nbt.m_128441_("equa")) {
            this.equation = nbt.m_128461_("equa");
        }
        if (nbt.m_128441_("anch_pos")) {
            this.anchorPos = Optional.of(NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("anch_pos")));
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("mirror", this.isMirrored);
        nbt.m_128379_("static", this.staticSchematicMode);
        nbt.m_128379_("hollow", this.hollow);
        nbt.m_128379_("renderLight", this.renderLightPlaceholders);
        nbt.m_128405_("gnd", this.groundOffset);
        nbt.m_128405_("rot", this.rotation);
        nbt.m_128405_("w", this.width);
        nbt.m_128405_("h", this.height);
        nbt.m_128405_("len", this.length);
        nbt.m_128405_("freq", this.frequency);
        if (this.shape != null) {
            nbt.m_128405_("shape", this.shape.ordinal());
        }
        if (this.pos != null) {
            nbt.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)this.pos));
        }
        if (this.box != null) {
            nbt.m_128365_("box", (Tag)NbtUtils.m_129224_((BlockPos)((BlockPos)this.box.m_14418_())));
            nbt.m_128365_("box2", (Tag)NbtUtils.m_129224_((BlockPos)((BlockPos)this.box.m_14419_())));
        }
        if (this.structureName != null) {
            nbt.m_128359_("struct_name", this.structureName);
        }
        if (this.staticSchematicName != null) {
            nbt.m_128359_("static_name", this.staticSchematicName);
        }
        if (this.stack != null) {
            nbt.m_128365_("stack", (Tag)((ItemStack)this.stack.m_14418_()).serializeNBT());
            nbt.m_128365_("stack2", (Tag)((ItemStack)this.stack.m_14419_()).serializeNBT());
        }
        if (!this.equation.isEmpty()) {
            nbt.m_128359_("equa", this.equation);
        }
        this.anchorPos.ifPresent(anch_pos -> nbt.m_128365_("anch_pos", (Tag)NbtUtils.m_129224_((BlockPos)anch_pos)));
        return nbt;
    }

    public void setEquation(String localEquation) {
        this.equation = localEquation;
    }

    public String getEquation() {
        return this.equation;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public Optional<BlockPos> getAnchorPos() {
        return this.anchorPos;
    }

    public void setAnchorPos(Optional<BlockPos> anchorPos) {
        this.anchorPos = anchorPos;
    }

    public boolean hasReceivedInfo() {
        return this.receivedInfo;
    }

    public void setReceivedInfo() {
        this.receivedInfo = true;
    }

    public void toggleLightPlaceholderRendering() {
        this.renderLightPlaceholders = !this.renderLightPlaceholders;
        this.scheduleRefresh();
    }

    public boolean renderLightPlaceholders() {
        return this.renderLightPlaceholders;
    }

    public boolean forceLightLevel() {
        return true;
    }

    public int getOurLightLevel() {
        return 15;
    }
}

