/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.event;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.commands.EntryPoint;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.management.Structures;
import com.ldtteam.structurize.network.messages.ServerUUIDMessage;
import com.ldtteam.structurize.network.messages.StructurizeStylesMessage;
import com.ldtteam.structurize.update.DomumOrnamentumUpdateHandler;
import com.ldtteam.structurize.update.UpdateMode;
import com.ldtteam.structurize.util.BackUpHelper;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EventSubscriber {
    private EventSubscriber() {
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        EntryPoint.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getEnvironment());
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        Structures.init();
        BackUpHelper.loadLinkSessionManager();
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        BackUpHelper.saveLinkSessionManager();
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Network.getNetwork().sendToPlayer(new ServerUUIDMessage(), serverPlayer);
            Network.getNetwork().sendToPlayer(new StructurizeStylesMessage(), serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        Level level = event.world;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (event.phase == TickEvent.Phase.START) {
                Manager.onWorldTick(serverLevel);
            }
        }
    }

    @SubscribeEvent
    public static void onMissingBlockMappings(RegistryEvent.MissingMappings<Block> missingBlockEvent) {
        ImmutableList missingBlocks = missingBlockEvent.getMappings("structurize");
        if (missingBlocks.isEmpty()) {
            return;
        }
        EventSubscriber.handleMissingMappingsDueToRestructureIn9af7543d7dcefa0bf7b52c2e809d6c8d48b803a6(missingBlocks, ForgeRegistries.BLOCKS);
    }

    @SubscribeEvent
    public static void onMissingItemMappings(RegistryEvent.MissingMappings<Item> missingBlockEvent) {
        ImmutableList missingItems = missingBlockEvent.getMappings("structurize");
        if (missingItems.isEmpty()) {
            return;
        }
        EventSubscriber.handleMissingMappingsDueToRestructureIn9af7543d7dcefa0bf7b52c2e809d6c8d48b803a6(missingItems, ForgeRegistries.ITEMS);
    }

    private static <T extends IForgeRegistryEntry<T>> void handleMissingMappingsDueToRestructureIn9af7543d7dcefa0bf7b52c2e809d6c8d48b803a6(ImmutableList<RegistryEvent.MissingMappings.Mapping<T>> missingMappings, IForgeRegistry<T> registry) {
        ImmutableMap replacementPatterns = ImmutableMap.builder().put((Object)Pattern.compile("(\\S+)?stone_brick(\\S+)?"), (Object)Lists.newArrayList((Object[])new String[]{"stone_bricks"})).put((Object)Pattern.compile("(\\S+)?cobble_stone(\\S+)?"), (Object)Lists.newArrayList((Object[])new String[]{"cobblestone"})).put((Object)Pattern.compile("(\\S+)?blockbrownbrick(\\S+)?"), (Object)Lists.newArrayList((Object[])new String[]{"brown_brick", "brown_brick_", "_brown_brick", "_brown_brick_"})).put((Object)Pattern.compile("(\\S+)?blockbeigebrick(\\S+)?"), (Object)Lists.newArrayList((Object[])new String[]{"beige_brick", "beige_brick_", "_beige_brick", "_beige_brick_"})).put((Object)Pattern.compile("(\\S+)?blockcreambrick(\\S+)?"), (Object)Lists.newArrayList((Object[])new String[]{"cream_brick", "cream_brick_", "_cream_brick", "_cream_brick_"})).put((Object)Pattern.compile("(\\S+)?_brick_(\\S+)?"), (Object)Lists.newArrayList((Object[])new String[]{"_bricks_"})).build();
        missingMappings.forEach(arg_0 -> EventSubscriber.lambda$handleMissingMappingsDueToRestructureIn9af7543d7dcefa0bf7b52c2e809d6c8d48b803a6$0((Map)replacementPatterns, registry, arg_0));
    }

    @SubscribeEvent
    public static void onGatherServerLevelCapabilities(AttachCapabilitiesEvent<Level> attachCapabilitiesEvent) {
        Object object = attachCapabilitiesEvent.getObject();
        if (!(object instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)object;
        if (Structurize.getConfig().getServer().updateMode.get() == UpdateMode.DISABLED) {
            return;
        }
        File regionDirectory = new File(serverLevel.m_142572_().f_129744_.m_197394_(serverLevel.m_46472_()).toFile(), "region");
        regionDirectory.mkdirs();
        File[] regionFiles = regionDirectory.listFiles((file, s) -> s.endsWith(".mca"));
        List lowestRegionCorners = Arrays.stream(regionFiles != null ? regionFiles : new File[]{}).map(file -> file.getName().replace("r.", "").replace(".mca", "")).map(coordinate -> coordinate.split("\\.")).map(coordinates -> new Tuple((Object)Integer.parseInt(coordinates[0]), (Object)Integer.parseInt(coordinates[1]))).map(regionCoordinate -> new ChunkPos((Integer)regionCoordinate.m_14418_() << 5, (Integer)regionCoordinate.m_14419_() << 5)).collect(Collectors.toList());
        for (ChunkPos lowestRegionCorner : lowestRegionCorners) {
            for (int x = 0; x < 32; ++x) {
                for (int z = 0; z < 32; ++z) {
                    ChunkPos chunkPos = new ChunkPos(lowestRegionCorner.f_45578_ + x, lowestRegionCorner.f_45579_ + z);
                    try {
                        CompoundTag chunkTag = serverLevel.m_7726_().f_8325_.m_140427_(chunkPos);
                        if (chunkTag == null) continue;
                        if (Structurize.getConfig().getServer().updateMode.get() == UpdateMode.DOMUM_ORNAMENTUM) {
                            DomumOrnamentumUpdateHandler.updateChunkTag(chunkTag, chunkPos);
                        }
                        serverLevel.m_7726_().f_8325_.m_63502_(chunkPos, chunkTag);
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private static /* synthetic */ void lambda$handleMissingMappingsDueToRestructureIn9af7543d7dcefa0bf7b52c2e809d6c8d48b803a6$0(Map replacementPatterns, IForgeRegistry registry, RegistryEvent.MissingMappings.Mapping mapping) {
        if (mapping.key.m_135815_().equals("placeholderblock")) {
            mapping.ignore();
            return;
        }
        String namespace = mapping.key.m_135827_();
        String path = mapping.key.m_135815_();
        for (Map.Entry patternToReplace : replacementPatterns.entrySet()) {
            Matcher patternMatcher = ((Pattern)patternToReplace.getKey()).matcher(path);
            if (!patternMatcher.find()) continue;
            for (String replacementCandidate : (List)patternToReplace.getValue()) {
                String replacedPath = patternMatcher.replaceAll("$1" + replacementCandidate + "$2");
                ResourceLocation remappedObjectKey = new ResourceLocation(namespace, replacedPath);
                if (!registry.containsKey(remappedObjectKey)) continue;
                IForgeRegistryEntry remappedObject = registry.getValue(remappedObjectKey);
                mapping.remap(remappedObject);
                return;
            }
        }
    }
}

