/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.commands;

import com.ldtteam.structurize.commands.AbstractCommand;
import com.ldtteam.structurize.commands.arguments.MultipleStringArgument;
import com.ldtteam.structurize.management.linksession.ChannelsEnum;
import com.ldtteam.structurize.management.linksession.LinkSessionManager;
import com.ldtteam.structurize.util.LanguageHandler;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class LinkSessionCommand {

    protected static class Leave
    extends AbstractCommand {
        private static final String NAME = "leave";
        private static final String TARGET_ARG = "targets";

        protected Leave() {
        }

        protected static LiteralArgumentBuilder<CommandSourceStack> build() {
            return (LiteralArgumentBuilder)Leave.newLiteral(NAME).then(Leave.newArgument(TARGET_ARG, MultipleStringArgument.multipleString((s, p) -> LinkSessionManager.INSTANCE.getSessionNamesOf(p.m_142081_()))).executes(s -> Leave.onExecute((CommandContext<CommandSourceStack>)s)));
        }

        private static int onExecute(CommandContext<CommandSourceStack> command) throws CommandSyntaxException {
            ServerPlayer sender = ((CommandSourceStack)command.getSource()).m_81375_();
            MinecraftServer server = ((CommandSourceStack)command.getSource()).m_81377_();
            String name = MultipleStringArgument.getResult(command, TARGET_ARG);
            if (server.m_6846_().m_11255_(name) != null) {
                LinkSessionManager.INSTANCE.removeMemberOfSession(server.m_6846_().m_11255_(name).m_142081_(), sender.m_142081_());
                sender.m_6352_((Component)new TextComponent("Leaving a session owned by \"" + name + "\"."), sender.m_142081_());
            }
            return 1;
        }
    }

    protected static class AcceptInvite
    extends AbstractCommand {
        private static final String NAME = "acceptinvite";
        private static final String UUID_ARG = "targets";

        protected AcceptInvite() {
        }

        protected static LiteralArgumentBuilder<CommandSourceStack> build() {
            return (LiteralArgumentBuilder)((LiteralArgumentBuilder)AcceptInvite.newLiteral(NAME).executes(s -> AcceptInvite.onExecute((CommandContext<CommandSourceStack>)s, false))).then(AcceptInvite.newArgument(UUID_ARG, MessageArgument.m_96832_()).executes(s -> AcceptInvite.onExecute((CommandContext<CommandSourceStack>)s, true)));
        }

        private static int onExecute(CommandContext<CommandSourceStack> command, boolean withUUID) throws CommandSyntaxException {
            ServerPlayer sender = ((CommandSourceStack)command.getSource()).m_81375_();
            UUID senderUUID = sender.m_142081_();
            String ownerName = null;
            if (withUUID) {
                try {
                    ownerName = LinkSessionManager.INSTANCE.consumeInviteWithCheck(senderUUID, sender.m_36316_().getName(), UUID.fromString(MessageArgument.m_96835_(command, (String)UUID_ARG).getString()));
                }
                catch (IllegalArgumentException e) {
                    AcceptInvite.throwSyntaxException("Unexpected error");
                }
                if (ownerName == null) {
                    AcceptInvite.throwSyntaxException("structurize.command.ls.invite.timeout");
                }
            } else {
                ownerName = LinkSessionManager.INSTANCE.consumeInvite(senderUUID, sender.m_36316_().getName());
                if (ownerName == null) {
                    AcceptInvite.throwSyntaxException("structurize.command.ls.invite.noopen");
                }
            }
            sender.m_6352_((Component)LanguageHandler.buildChatComponent("structurize.command.ls.invite.accepted", ownerName), sender.m_142081_());
            return 1;
        }
    }

    protected static class MuteChannel
    extends AbstractCommand {
        private static final String NAME = "mutechannel";

        protected MuteChannel() {
        }

        protected static LiteralArgumentBuilder<CommandSourceStack> build() {
            LiteralArgumentBuilder<CommandSourceStack> root = MuteChannel.newLiteral(NAME);
            for (ChannelsEnum ch : ChannelsEnum.values()) {
                root.then(MuteChannel.newLiteral(ch.getCommandName()).executes(s -> MuteChannel.onExecute((CommandContext<CommandSourceStack>)s, ch)));
            }
            return root;
        }

        public List<String> getTabCompletions() {
            return Stream.of(ChannelsEnum.values()).map(ch -> ch.getCommandName()).collect(Collectors.toList());
        }

        private static int onExecute(CommandContext<CommandSourceStack> command, ChannelsEnum ch) throws CommandSyntaxException {
            ServerPlayer sender = ((CommandSourceStack)command.getSource()).m_81375_();
            UUID senderUUID = sender.m_142081_();
            if (ch != null) {
                LinkSessionManager.INSTANCE.setMuteState(senderUUID, ch, !LinkSessionManager.INSTANCE.getMuteState(senderUUID, ch));
            }
            return 1;
        }
    }

    protected static class AboutMe
    extends AbstractCommand {
        private static final String NAME = "aboutme";

        protected AboutMe() {
        }

        protected static LiteralArgumentBuilder<CommandSourceStack> build() {
            return (LiteralArgumentBuilder)AboutMe.newLiteral(NAME).executes(s -> AboutMe.onExecute((CommandContext<CommandSourceStack>)s));
        }

        private static int onExecute(CommandContext<CommandSourceStack> command) throws CommandSyntaxException {
            ServerPlayer sender = ((CommandSourceStack)command.getSource()).m_81375_();
            UUID senderUUID = sender.m_142081_();
            List<String> ownerSession = LinkSessionManager.INSTANCE.getMembersNamesOf(senderUUID);
            sender.m_6352_((Component)new TextComponent("Info about \"" + sender.m_36316_().getName() + "\":"), sender.m_142081_());
            String ownerName = LinkSessionManager.INSTANCE.hasInvite(senderUUID);
            if (ownerName == null) {
                sender.m_6352_((Component)new TextComponent("  \u00a7cYou have no open invite."), sender.m_142081_());
            } else {
                sender.m_6352_((Component)new TextComponent("  \u00a7aYou have an open invite from " + ownerName + "."), sender.m_142081_());
            }
            if (ownerSession.isEmpty()) {
                sender.m_6352_((Component)new TextComponent("  \u00a7cYou don't have your own session."), sender.m_142081_());
            } else {
                sender.m_6352_((Component)new TextComponent("  \u00a7aYou own a session with:"), sender.m_142081_());
                for (String name : ownerSession) {
                    if (!name.equals("null")) {
                        sender.m_6352_((Component)new TextComponent("    \u00a77" + name), sender.m_142081_());
                        continue;
                    }
                    sender.m_6352_((Component)new TextComponent("    \u00a77Unknown name"), sender.m_142081_());
                }
            }
            ownerSession = LinkSessionManager.INSTANCE.getSessionNamesOf(senderUUID);
            if (ownerSession.isEmpty()) {
                sender.m_6352_((Component)new TextComponent("  \u00a7cYou are not a part of other sessions."), sender.m_142081_());
            } else {
                sender.m_6352_((Component)new TextComponent("  \u00a7aYou are in sessions owned by:"), sender.m_142081_());
                for (String name : ownerSession) {
                    sender.m_6352_((Component)new TextComponent("    \u00a77" + name), sender.m_142081_());
                }
            }
            sender.m_6352_((Component)new TextComponent("  \u00a7aChannels:"), sender.m_142081_());
            for (ChannelsEnum ch : ChannelsEnum.values()) {
                if (LinkSessionManager.INSTANCE.getMuteState(senderUUID, ch)) {
                    sender.m_6352_((Component)new TextComponent(String.format("    \u00a77%s:\u00a7r \u00a7c%s", ch.getCommandName(), "muted")), sender.m_142081_());
                    continue;
                }
                sender.m_6352_((Component)new TextComponent(String.format("    \u00a77%s:\u00a7r \u00a7a%s", ch.getCommandName(), "unmuted")), sender.m_142081_());
            }
            return 1;
        }
    }

    protected static class SendMessage
    extends AbstractCommand {
        private static final String NAME = "sendmessage";
        private static final String MESSAGE_ARG = "message";

        protected SendMessage() {
        }

        protected static LiteralArgumentBuilder<CommandSourceStack> build() {
            return (LiteralArgumentBuilder)SendMessage.newLiteral(NAME).then(SendMessage.newArgument(MESSAGE_ARG, MessageArgument.m_96832_()).executes(s -> SendMessage.onExecute((CommandContext<CommandSourceStack>)s)));
        }

        private static int onExecute(CommandContext<CommandSourceStack> command) throws CommandSyntaxException {
            ServerPlayer sender = ((CommandSourceStack)command.getSource()).m_81375_();
            MinecraftServer server = ((CommandSourceStack)command.getSource()).m_81377_();
            UUID senderUUID = sender.m_142081_();
            Set<UUID> uniqueMembers = LinkSessionManager.INSTANCE.execute(senderUUID, ChannelsEnum.COMMAND_MESSAGE);
            TranslatableComponent msgWithHead = new TranslatableComponent("commands.message.display.incoming", new Object[]{LanguageHandler.buildChatComponent("structurize.command.ls.message.head", "Structurize", sender.m_36316_().getName()), MessageArgument.m_96835_(command, (String)MESSAGE_ARG)});
            if (LinkSessionManager.INSTANCE.getMuteState(senderUUID, ChannelsEnum.COMMAND_MESSAGE)) {
                SendMessage.throwSyntaxException("structurize.command.ls.message.muted");
            }
            if (uniqueMembers.size() == 1) {
                SendMessage.throwSyntaxException("structurize.command.ls.message.norecipient");
            }
            msgWithHead.m_6270_(msgWithHead.m_7383_().m_131140_(ChatFormatting.GRAY).m_131136_(Boolean.valueOf(true)));
            uniqueMembers.forEach(member -> {
                ServerPlayer target = server.m_6846_().m_11259_(member);
                if (target != null) {
                    target.m_6352_((Component)msgWithHead, target.m_142081_());
                }
            });
            return uniqueMembers.size();
        }
    }

    protected static class RemovePlayer
    extends AbstractCommand {
        private static final String NAME = "removeplayer";
        private static final String TARGETS_ARG = "targets";

        protected RemovePlayer() {
        }

        protected static LiteralArgumentBuilder<CommandSourceStack> build() {
            return (LiteralArgumentBuilder)RemovePlayer.newLiteral(NAME).then(RemovePlayer.newArgument(TARGETS_ARG, GameProfileArgument.m_94584_()).executes(s -> RemovePlayer.onExecute((CommandContext<CommandSourceStack>)s)));
        }

        private static int onExecute(CommandContext<CommandSourceStack> command) throws CommandSyntaxException {
            ServerPlayer sender = ((CommandSourceStack)command.getSource()).m_81375_();
            MinecraftServer server = ((CommandSourceStack)command.getSource()).m_81377_();
            UUID ownerUUID = sender.m_142081_();
            if (LinkSessionManager.INSTANCE.getMembersOf(ownerUUID).isEmpty()) {
                RemovePlayer.throwSyntaxException("structurize.command.ls.generic.dontexist");
            }
            int timesSucceeded = 0;
            for (GameProfile gp : GameProfileArgument.m_94590_(command, (String)TARGETS_ARG)) {
                String name = gp.getName();
                ServerPlayer target = server.m_6846_().m_11255_(name);
                if (target == null) continue;
                LinkSessionManager.INSTANCE.removeMemberOfSession(ownerUUID, target.m_142081_());
                sender.m_6352_((Component)LanguageHandler.buildChatComponent("structurize.command.ls.remove.done", name, sender.m_36316_().getName()), sender.m_142081_());
                ++timesSucceeded;
            }
            return timesSucceeded;
        }
    }

    protected static class AddPlayer
    extends AbstractCommand {
        private static final String NAME = "addplayer";
        private static final String TARGETS_ARG = "targets";

        protected AddPlayer() {
        }

        protected static LiteralArgumentBuilder<CommandSourceStack> build() {
            return (LiteralArgumentBuilder)AddPlayer.newLiteral(NAME).then(AddPlayer.newArgument(TARGETS_ARG, GameProfileArgument.m_94584_()).executes(s -> AddPlayer.onExecute((CommandContext<CommandSourceStack>)s)));
        }

        private static int onExecute(CommandContext<CommandSourceStack> command) throws CommandSyntaxException {
            ServerPlayer sender = ((CommandSourceStack)command.getSource()).m_81375_();
            MinecraftServer server = ((CommandSourceStack)command.getSource()).m_81377_();
            UUID ownerUUID = sender.m_142081_();
            MutableComponent acceptButton = LanguageHandler.buildChatComponent("structurize.command.ls.invite.accept", new Object[0]);
            MutableComponent inviteMsg = LanguageHandler.buildChatComponent("structurize.command.ls.invite.message", sender.m_36316_().getName());
            acceptButton.m_6270_(acceptButton.m_7383_().m_131140_(ChatFormatting.DARK_RED).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/structurize linksession acceptinvite " + ownerUUID.toString())));
            inviteMsg.m_7220_((Component)acceptButton);
            if (LinkSessionManager.INSTANCE.getMembersOf(ownerUUID).isEmpty()) {
                AddPlayer.throwSyntaxException("structurize.command.ls.generic.dontexist");
            }
            int timesSucceeded = 0;
            for (GameProfile gp : GameProfileArgument.m_94590_(command, (String)TARGETS_ARG)) {
                ServerPlayer target = server.m_6846_().m_11259_(gp.getId());
                if (target == null) continue;
                LinkSessionManager.INSTANCE.createInvite(target.m_142081_(), ownerUUID);
                target.m_6352_((Component)inviteMsg, target.m_142081_());
                sender.m_6352_((Component)LanguageHandler.buildChatComponent("structurize.command.ls.invite.done", gp.getName(), sender.m_36316_().getName()), ownerUUID);
                ++timesSucceeded;
            }
            return timesSucceeded;
        }
    }

    protected static class Destroy
    extends AbstractCommand {
        private static final String NAME = "destroy";

        protected Destroy() {
        }

        protected static LiteralArgumentBuilder<CommandSourceStack> build() {
            return (LiteralArgumentBuilder)Destroy.newLiteral(NAME).executes(s -> Destroy.onExecute((CommandContext<CommandSourceStack>)s));
        }

        private static int onExecute(CommandContext<CommandSourceStack> command) throws CommandSyntaxException {
            ServerPlayer sender = ((CommandSourceStack)command.getSource()).m_81375_();
            UUID ownerUUID = sender.m_142081_();
            if (LinkSessionManager.INSTANCE.destroySession(ownerUUID)) {
                sender.m_6352_((Component)LanguageHandler.buildChatComponent("structurize.command.ls.destroy.done", sender.m_36316_().getName()), sender.m_142081_());
            } else {
                Destroy.throwSyntaxException("structurize.command.ls.generic.dontexist");
            }
            return 1;
        }
    }

    protected static class Create
    extends AbstractCommand {
        private static final String NAME = "create";

        protected Create() {
        }

        protected static LiteralArgumentBuilder<CommandSourceStack> build() {
            return (LiteralArgumentBuilder)Create.newLiteral(NAME).executes(s -> Create.onExecute((CommandContext<CommandSourceStack>)s));
        }

        private static int onExecute(CommandContext<CommandSourceStack> command) throws CommandSyntaxException {
            ServerPlayer sender = ((CommandSourceStack)command.getSource()).m_81375_();
            UUID ownerUUID = sender.m_142081_();
            if (!LinkSessionManager.INSTANCE.getMembersOf(ownerUUID).isEmpty()) {
                Create.throwSyntaxException("structurize.command.ls.create.already");
            }
            LinkSessionManager.INSTANCE.createSession(ownerUUID);
            LinkSessionManager.INSTANCE.addOrUpdateMemberInSession(ownerUUID, ownerUUID, sender.m_36316_().getName());
            sender.m_6352_((Component)LanguageHandler.buildChatComponent("structurize.command.ls.create.done", sender.m_36316_().getName()), sender.m_142081_());
            return 1;
        }
    }
}

