/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui;

import com.ldtteam.blockui.Color;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.EntityIcon;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.api.util.ItemStorage;
import com.ldtteam.structurize.blocks.interfaces.IBlueprintDataProvider;
import com.ldtteam.structurize.client.gui.AbstractWindowSkeleton;
import com.ldtteam.structurize.client.gui.WindowReplaceBlock;
import com.ldtteam.structurize.client.gui.WindowUndoRedo;
import com.ldtteam.structurize.helpers.Settings;
import com.ldtteam.structurize.network.messages.RemoveBlockMessage;
import com.ldtteam.structurize.network.messages.RemoveEntityMessage;
import com.ldtteam.structurize.network.messages.ScanOnServerMessage;
import com.ldtteam.structurize.network.messages.UpdateScanToolMessage;
import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.placement.handlers.placement.PlacementHandlers;
import com.ldtteam.structurize.util.BlockUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class WindowScan
extends AbstractWindowSkeleton {
    private static final String BUILDING_NAME_RESOURCE_SUFFIX = ":gui/windowscantool.xml";
    private static final String CHEST_WARNING = "chestwarning";
    private final Map<String, ItemStorage> resources = new HashMap<String, ItemStorage>();
    private final Map<String, Entity> entities = new HashMap<String, Entity>();
    public static final int WHITE = Color.getByName((String)"white", (int)0);
    private BlockPos pos1;
    private BlockPos pos2;
    private Optional<BlockPos> anchorPos;
    private String filter = "";
    private final TextField pos1x;
    private final TextField pos1y;
    private final TextField pos1z;
    private final TextField pos2x;
    private final TextField pos2y;
    private final TextField pos2z;
    private final ScrollingList resourceList;
    private final ScrollingList entityList;

    public WindowScan(BlockPos pos1, BlockPos pos2, Optional<BlockPos> anchorPos) {
        super("structurize:gui/windowscantool.xml");
        this.pos1 = pos1;
        this.pos2 = pos2;
        this.anchorPos = anchorPos;
        this.registerButton("confirm", this::confirmClicked);
        this.registerButton("cancel", this::discardClicked);
        this.registerButton("showRes", this::showResClicked);
        this.registerButton("removeEntity", this::removeEntity);
        this.registerButton("removeBlock", this::removeBlock);
        this.registerButton("replaceBlock", this::replaceBlock);
        this.registerButton("undoredo", (Button b) -> {
            this.close();
            new WindowUndoRedo().open();
        });
        this.pos1x = (TextField)this.findPaneOfTypeByID("pos1x", TextField.class);
        this.pos1y = (TextField)this.findPaneOfTypeByID("pos1y", TextField.class);
        this.pos1z = (TextField)this.findPaneOfTypeByID("pos1z", TextField.class);
        this.pos2x = (TextField)this.findPaneOfTypeByID("pos2x", TextField.class);
        this.pos2y = (TextField)this.findPaneOfTypeByID("pos2y", TextField.class);
        this.pos2z = (TextField)this.findPaneOfTypeByID("pos2z", TextField.class);
        this.resourceList = (ScrollingList)this.findPaneOfTypeByID("resources", ScrollingList.class);
        this.entityList = (ScrollingList)this.findPaneOfTypeByID("entities", ScrollingList.class);
    }

    private void showResClicked() {
        ((TextField)this.findPaneOfTypeByID("filter", TextField.class)).show();
        ((Button)this.findPaneOfTypeByID("showRes", Button.class)).hide();
        this.updateResources();
    }

    private void removeEntity(Button button) {
        int x1 = Integer.parseInt(this.pos1x.getText());
        int y1 = Integer.parseInt(this.pos1y.getText());
        int z1 = Integer.parseInt(this.pos1z.getText());
        int x2 = Integer.parseInt(this.pos2x.getText());
        int y2 = Integer.parseInt(this.pos2y.getText());
        int z2 = Integer.parseInt(this.pos2z.getText());
        int row = this.entityList.getListElementIndexByPane((Pane)button);
        Entity entity = new ArrayList<Entity>(this.entities.values()).get(row);
        Network.getNetwork().sendToServer(new RemoveEntityMessage(new BlockPos(x1, y1, z1), new BlockPos(x2, y2, z2), entity.m_7755_().getString()));
        this.entities.remove(entity.m_7755_().getString());
        this.updateEntitylist();
    }

    private void removeBlock(Button button) {
        int x1 = Integer.parseInt(this.pos1x.getText());
        int y1 = Integer.parseInt(this.pos1y.getText());
        int z1 = Integer.parseInt(this.pos1z.getText());
        int x2 = Integer.parseInt(this.pos2x.getText());
        int y2 = Integer.parseInt(this.pos2y.getText());
        int z2 = Integer.parseInt(this.pos2z.getText());
        int row = this.resourceList.getListElementIndexByPane((Pane)button);
        ArrayList<ItemStorage> tempRes = new ArrayList<ItemStorage>(this.resources.values());
        ItemStack stack = ((ItemStorage)tempRes.get(row)).getItemStack();
        Network.getNetwork().sendToServer(new RemoveBlockMessage(new BlockPos(x1, y1, z1), new BlockPos(x2, y2, z2), stack));
        int hashCode = stack.m_41782_() ? stack.m_41783_().hashCode() : 0;
        this.resources.remove(stack.m_41778_() + ":" + stack.m_41773_() + "-" + hashCode);
        this.updateResourceList();
    }

    private void replaceBlock(Button button) {
        int x1 = Integer.parseInt(this.pos1x.getText());
        int y1 = Integer.parseInt(this.pos1y.getText());
        int z1 = Integer.parseInt(this.pos1z.getText());
        int x2 = Integer.parseInt(this.pos2x.getText());
        int y2 = Integer.parseInt(this.pos2y.getText());
        int z2 = Integer.parseInt(this.pos2z.getText());
        int row = this.resourceList.getListElementIndexByPane((Pane)button);
        ArrayList<ItemStorage> tempRes = new ArrayList<ItemStorage>(this.resources.values());
        new WindowReplaceBlock(((ItemStorage)tempRes.get(row)).getItemStack(), new BlockPos(x1, y1, z1), new BlockPos(x2, y2, z2), (BOWindow)this).open();
    }

    public void onOpened() {
        BlockEntity tile;
        super.onOpened();
        if (!Minecraft.m_91087_().f_91074_.m_7500_()) {
            this.pos1x.disable();
            this.pos1y.disable();
            this.pos1z.disable();
            this.pos2x.disable();
            this.pos2y.disable();
            this.pos2z.disable();
        }
        this.pos1x.setText(String.valueOf(this.pos1.m_123341_()));
        this.pos1y.setText(String.valueOf(this.pos1.m_123342_()));
        this.pos1z.setText(String.valueOf(this.pos1.m_123343_()));
        this.pos2x.setText(String.valueOf(this.pos2.m_123341_()));
        this.pos2y.setText(String.valueOf(this.pos2.m_123342_()));
        this.pos2z.setText(String.valueOf(this.pos2.m_123343_()));
        Settings.instance.setAnchorPos(this.anchorPos);
        Settings.instance.setBox((Tuple<BlockPos, BlockPos>)new Tuple((Object)this.pos1, (Object)this.pos2));
        if (this.anchorPos.isPresent() && (tile = Minecraft.m_91087_().f_91074_.f_19853_.m_7702_(this.anchorPos.get())) instanceof IBlueprintDataProvider && !((IBlueprintDataProvider)tile).getSchematicName().isEmpty()) {
            ((TextField)this.findPaneOfTypeByID("name", TextField.class)).setText(((IBlueprintDataProvider)tile).getSchematicName());
        }
        ((TextField)this.findPaneOfTypeByID("filter", TextField.class)).setHandler(input -> {
            this.filter = ((TextField)this.findPaneOfTypeByID("filter", TextField.class)).getText();
            this.updateResources();
        });
    }

    private void discardClicked() {
        Settings.instance.setAnchorPos(Optional.empty());
        Settings.instance.setBox(null);
        this.close();
    }

    private void confirmClicked() {
        String name = ((TextField)this.findPaneOfTypeByID("name", TextField.class)).getText();
        int x1 = Integer.parseInt(this.pos1x.getText());
        int y1 = Integer.parseInt(this.pos1y.getText());
        int z1 = Integer.parseInt(this.pos1z.getText());
        int x2 = Integer.parseInt(this.pos2x.getText());
        int y2 = Integer.parseInt(this.pos2y.getText());
        int z2 = Integer.parseInt(this.pos2z.getText());
        Network.getNetwork().sendToServer(new ScanOnServerMessage(new BlockPos(x1, y1, z1), new BlockPos(x2, y2, z2), name, true, Settings.instance.getAnchorPos()));
        Settings.instance.setAnchorPos(Optional.empty());
        Settings.instance.setBox(null);
        Settings.instance.setStructureName(null);
        this.close();
    }

    private void updateResources() {
        BlockPos def = Minecraft.m_91087_().f_91074_.m_142538_();
        try {
            int x1 = this.pos1x.getText().isEmpty() ? def.m_123341_() : Integer.parseInt(this.pos1x.getText());
            int y1 = this.pos1y.getText().isEmpty() ? def.m_123342_() : Integer.parseInt(this.pos1y.getText());
            int z1 = this.pos1z.getText().isEmpty() ? def.m_123343_() : Integer.parseInt(this.pos1z.getText());
            this.pos1 = new BlockPos(x1, y1, z1);
            int x2 = this.pos2x.getText().isEmpty() ? def.m_123341_() : Integer.parseInt(this.pos2x.getText());
            int y2 = this.pos2y.getText().isEmpty() ? def.m_123342_() : Integer.parseInt(this.pos2y.getText());
            int z2 = this.pos2z.getText().isEmpty() ? def.m_123343_() : Integer.parseInt(this.pos2z.getText());
            this.pos2 = new BlockPos(x2, y2, z2);
        }
        catch (NumberFormatException e) {
            Minecraft.m_91087_().f_91074_.m_6352_((Component)new TextComponent("Invalid Number - Closing!"), Minecraft.m_91087_().f_91074_.m_142081_());
            this.close();
            return;
        }
        Settings.instance.setAnchorPos(this.anchorPos);
        Settings.instance.setBox((Tuple<BlockPos, BlockPos>)new Tuple((Object)this.pos1, (Object)this.pos2));
        Network.getNetwork().sendToServer(new UpdateScanToolMessage(this.pos1, this.pos2));
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        this.resources.clear();
        this.entities.clear();
        if (this.findPaneByID("showRes").isVisible()) {
            return;
        }
        for (int x = Math.min(this.pos1.m_123341_(), this.pos2.m_123341_()); x <= Math.max(this.pos1.m_123341_(), this.pos2.m_123341_()); ++x) {
            for (int y = Math.min(this.pos1.m_123342_(), this.pos2.m_123342_()); y <= Math.max(this.pos1.m_123342_(), this.pos2.m_123342_()); ++y) {
                for (int z = Math.min(this.pos1.m_123343_(), this.pos2.m_123343_()); z <= Math.max(this.pos1.m_123343_(), this.pos2.m_123343_()); ++z) {
                    BlockPos here = new BlockPos(x, y, z);
                    BlockState blockState = world.m_8055_(here);
                    BlockEntity tileEntity = world.m_7702_(here);
                    List list = world.m_45976_(Entity.class, new AABB(here));
                    for (Entity entity : list) {
                        if (this.entities.containsKey(entity.m_7755_().getString()) || !entity.m_6095_().m_20584_() && !entity.m_6095_().equals(EntityType.f_20464_) || !this.filter.isEmpty() && !entity.m_7755_().getString().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) && !entity.toString().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US))) continue;
                        this.entities.put(entity.m_7755_().getString(), entity);
                    }
                    @Nullable Block block = blockState.m_60734_();
                    if (block == Blocks.f_50016_ || block == Blocks.f_50626_ || block == Blocks.f_50627_) {
                        this.addNeededResource(new ItemStack((ItemLike)Blocks.f_50016_, 1), 1);
                        continue;
                    }
                    boolean handled = false;
                    for (IPlacementHandler handler : PlacementHandlers.handlers) {
                        if (!handler.canHandle((Level)world, BlockPos.f_121853_, blockState)) continue;
                        List<ItemStack> itemList = handler.getRequiredItems((Level)world, here, blockState, tileEntity == null ? null : tileEntity.m_187480_(), true);
                        for (ItemStack stack : itemList) {
                            this.addNeededResource(stack, 1);
                        }
                        handled = true;
                        break;
                    }
                    if (handled) continue;
                    this.addNeededResource(BlockUtils.getItemStackFromBlockState(blockState), 1);
                }
            }
        }
        ((ScrollingList)this.window.findPaneOfTypeByID("resources", ScrollingList.class)).refreshElementPanes();
        this.updateResourceList();
        this.updateEntitylist();
    }

    public void addNeededResource(@Nullable ItemStack res, int amount) {
        if (res == null || amount == 0) {
            return;
        }
        int hashCode = res.m_41782_() ? res.m_41783_().hashCode() : 0;
        ItemStorage resource = this.resources.get(res.m_41778_() + ":" + res.m_41773_() + "-" + hashCode);
        if (resource == null) {
            resource = new ItemStorage(res);
            resource.setAmount(amount);
        } else {
            resource.setAmount(resource.getAmount() + amount);
        }
        if (this.filter.isEmpty() || res.m_41778_().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) || res.m_41786_().getString().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US))) {
            this.resources.put(res.m_41778_() + ":" + res.m_41773_() + "-" + hashCode, resource);
        }
    }

    public void updateEntitylist() {
        this.entityList.enable();
        this.entityList.show();
        final ArrayList<Entity> tempEntities = new ArrayList<Entity>(this.entities.values());
        this.entityList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return tempEntities.size();
            }

            public void updateElement(int index, Pane rowPane) {
                Entity entity = (Entity)tempEntities.get(index);
                ((EntityIcon)rowPane.findPaneOfTypeByID("resourceIcon", EntityIcon.class)).setEntity(entity);
                ((Text)rowPane.findPaneOfTypeByID("resourceName", Text.class)).setText(entity.m_7755_());
                if (!Minecraft.m_91087_().f_91074_.m_7500_()) {
                    ((Button)rowPane.findPaneOfTypeByID("removeEntity", Button.class)).hide();
                }
            }
        });
    }

    public void updateResourceList() {
        this.resourceList.enable();
        this.resourceList.show();
        ((Text)this.window.findPaneOfTypeByID(CHEST_WARNING, Text.class)).show();
        final ArrayList<ItemStorage> tempRes = new ArrayList<ItemStorage>(this.resources.values());
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return tempRes.size();
            }

            public void updateElement(int index, Pane rowPane) {
                ItemStorage resource = (ItemStorage)tempRes.get(index);
                Text resourceLabel = (Text)rowPane.findPaneOfTypeByID("resourceName", Text.class);
                Text quantityLabel = (Text)rowPane.findPaneOfTypeByID("resourceQuantity", Text.class);
                resourceLabel.setText(resource.getItemStack().m_41786_());
                quantityLabel.setText((MutableComponent)new TextComponent(Integer.toString(resource.getAmount())));
                resourceLabel.setColors(WHITE);
                quantityLabel.setColors(WHITE);
                ItemStack copy = resource.getItemStack().m_41777_();
                copy.m_41764_(1);
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(copy);
                if (!Minecraft.m_91087_().f_91074_.m_7500_()) {
                    ((Button)rowPane.findPaneOfTypeByID("removeBlock", Button.class)).hide();
                    ((Button)rowPane.findPaneOfTypeByID("replaceBlock", Button.class)).hide();
                }
            }
        });
    }
}

