/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import twilightforest.entity.TFPart;

public abstract class TFPartRenderer<T extends TFPart<?>, M extends ListModel<T>>
extends EntityRenderer<T> {
    protected final M entityModel;

    public TFPartRenderer(EntityRendererProvider.Context renderManager, M model) {
        super(renderManager);
        this.entityModel = model;
    }

    public void render(T entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int light) {
        int packedLightIn = this.f_114476_.m_114394_(entityIn.getParent(), partialTicks);
        super.m_7392_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.m_85836_();
        float f = Mth.m_14189_((float)partialTicks, (float)((TFPart)((Object)entityIn)).prevRenderYawOffset, (float)((TFPart)((Object)entityIn)).renderYawOffset);
        float f6 = Mth.m_14179_((float)partialTicks, (float)((TFPart)((Object)entityIn)).f_19860_, (float)entityIn.m_146909_());
        float f7 = this.handleRotationFloat(entityIn, partialTicks);
        this.applyRotations(entityIn, matrixStackIn, f7, f, partialTicks);
        matrixStackIn.m_85841_(-1.0f, -1.0f, 1.0f);
        matrixStackIn.m_85837_(0.0, (double)-1.501f, 0.0);
        float f8 = 0.0f;
        float f5 = 0.0f;
        this.entityModel.m_6839_(entityIn, f5, f8, partialTicks);
        this.entityModel.m_6973_(entityIn, f5, f8, f7, f, f6);
        Minecraft minecraft = Minecraft.m_91087_();
        boolean flag = this.isVisible(entityIn);
        boolean flag1 = !flag && !entityIn.m_20177_((Player)minecraft.f_91074_);
        boolean flag2 = minecraft.m_91314_(entityIn);
        RenderType rendertype = this.getRenderType(entityIn, flag, flag1, flag2);
        if (rendertype != null) {
            VertexConsumer ivertexbuilder = bufferIn.m_6299_(rendertype);
            int i = this.getPackedOverlay(entityIn, this.getOverlayProgress(entityIn, partialTicks));
            this.entityModel.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, i, 1.0f, 1.0f, 1.0f, flag1 ? 0.15f : 1.0f);
        }
        matrixStackIn.m_85849_();
    }

    protected float getOverlayProgress(T livingEntityIn, float partialTicks) {
        return 0.0f;
    }

    public int getPackedOverlay(T livingEntityIn, float uIn) {
        if (livingEntityIn.getParent() instanceof LivingEntity) {
            return OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)uIn), (int)OverlayTexture.m_118096_((((LivingEntity)livingEntityIn.getParent()).f_20916_ > 0 || ((LivingEntity)livingEntityIn.getParent()).f_20919_ > 0 ? 1 : 0) != 0));
        }
        return OverlayTexture.f_118083_;
    }

    @Nullable
    protected RenderType getRenderType(T p_230496_1_, boolean p_230496_2_, boolean p_230496_3_, boolean p_230496_4_) {
        ResourceLocation resourcelocation = this.m_5478_((Entity)p_230496_1_);
        if (p_230496_3_) {
            return RenderType.m_110467_((ResourceLocation)resourcelocation);
        }
        if (p_230496_2_) {
            return this.entityModel.m_103119_(resourcelocation);
        }
        return p_230496_4_ ? RenderType.m_110491_((ResourceLocation)resourcelocation) : null;
    }

    protected float handleRotationFloat(T livingBase, float partialTicks) {
        return (float)((TFPart)((Object)livingBase)).f_19797_ + partialTicks;
    }

    protected void applyRotations(T entityLiving, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        if (((TFPart)((Object)entityLiving)).deathTime > 0) {
            float f = ((float)((TFPart)((Object)entityLiving)).deathTime + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.m_14116_((float)f)) > 1.0f) {
                f = 1.0f;
            }
            matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(f * this.getDeathMaxRotation(entityLiving)));
        }
    }

    protected float getDeathMaxRotation(T entityLivingBaseIn) {
        return 90.0f;
    }

    protected boolean isVisible(T livingEntityIn) {
        return !livingEntityIn.m_20145_();
    }
}

