/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client;

import java.util.Objects;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IWeatherRenderHandler;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;
import twilightforest.TFConfig;
import twilightforest.TFEventListener;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;
import twilightforest.client.BugModelAnimationHelper;
import twilightforest.client.PatchModelLoader;
import twilightforest.client.RenderEffect;
import twilightforest.client.TwilightForestRenderInfo;
import twilightforest.client.model.item.FullbrightBakedModel;
import twilightforest.client.model.item.TintIndexAwareFullbrightBakedModel;
import twilightforest.client.renderer.TFWeatherRenderer;
import twilightforest.client.renderer.entity.ShieldLayer;
import twilightforest.client.renderer.tileentity.TwilightChestRenderer;
import twilightforest.compat.CuriosCompat;
import twilightforest.compat.IECompat;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.item.EnderBowItem;
import twilightforest.item.IceBowItem;
import twilightforest.item.SeekerBowItem;
import twilightforest.item.SkullCandleItem;
import twilightforest.item.TFItems;
import twilightforest.item.TripleBowItem;
import twilightforest.item.TrophyItem;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="twilightforest", value={Dist.CLIENT})
public class TFClientEvents {
    private static final MutableComponent WIP_TEXT_0 = new TranslatableComponent("twilightforest.misc.wip0").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED));
    private static final MutableComponent WIP_TEXT_1 = new TranslatableComponent("twilightforest.misc.wip1").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED));
    private static final MutableComponent NYI_TEXT = new TranslatableComponent("twilightforest.misc.nyi").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED));
    public static int time = 0;
    private static int rotationTickerI = 0;
    private static int sineTickerI = 0;
    public static float rotationTicker = 0.0f;
    public static float sineTicker = 0.0f;
    public static final float PI = (float)Math.PI;
    private static final int SINE_TICKER_BOUND = 627;

    @SubscribeEvent
    public static void preOverlay(RenderGameOverlayEvent.PreLayer event) {
        if (event.getOverlay() == ForgeIngameGui.MOUNT_HEALTH_ELEMENT && TFEventListener.isRidingUnfriendly((LivingEntity)Minecraft.m_91087_().f_91074_)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderWorldLast(RenderLevelLastEvent event) {
        EntityRenderer renderer;
        if (!((Boolean)TFConfig.CLIENT_CONFIG.firstPersonEffects.get()).booleanValue()) {
            return;
        }
        Options settings = Minecraft.m_91087_().f_91066_;
        if (settings.m_92176_() != CameraType.FIRST_PERSON || settings.f_92062_) {
            return;
        }
        Entity entity = Minecraft.m_91087_().m_91288_();
        if (entity instanceof LivingEntity && (renderer = Minecraft.m_91087_().m_91290_().m_114382_(entity)) instanceof LivingEntityRenderer) {
            for (RenderEffect effect : RenderEffect.VALUES) {
                if (!effect.shouldRender((LivingEntity)entity, true)) continue;
                effect.render((LivingEntity)entity, (EntityModel<? extends LivingEntity>)((LivingEntityRenderer)renderer).m_7200_(), 0.0, 0.0, 0.0, event.getPartialTick(), true);
            }
        }
    }

    @SubscribeEvent
    public static void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91073_ != null && "twilightforest".equals(minecraft.f_91073_.m_46472_().m_135782_().m_135827_()) && minecraft.f_91065_ != null) {
                minecraft.f_91065_.f_92980_ = 0.0f;
            }
            if (minecraft.f_91074_ != null && TFEventListener.isRidingUnfriendly((LivingEntity)minecraft.f_91074_) && minecraft.f_91065_ != null) {
                minecraft.f_91065_.m_93063_(TextComponent.f_131282_, false);
            }
        }
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        IWeatherRenderHandler weatherRenderer;
        if (event.phase != TickEvent.Phase.END || Minecraft.m_91087_().m_91104_()) {
            return;
        }
        ++time;
        Minecraft mc = Minecraft.m_91087_();
        float partial = mc.m_91296_();
        rotationTickerI = rotationTickerI >= 359 ? 0 : rotationTickerI + 1;
        sineTickerI = sineTickerI >= 627 ? 0 : sineTickerI + 1;
        rotationTicker = (float)rotationTickerI + partial;
        sineTicker += partial;
        BugModelAnimationHelper.animate();
        DimensionSpecialEffects info = (DimensionSpecialEffects)DimensionSpecialEffects.f_108857_.get((Object)TwilightForestMod.prefix("renderer"));
        if (!mc.m_91104_() && mc.f_91073_ != null && info instanceof TwilightForestRenderInfo && (weatherRenderer = info.getWeatherRenderHandler()) instanceof TFWeatherRenderer) {
            ((TFWeatherRenderer)weatherRenderer).tick();
        }
    }

    @SubscribeEvent
    public static void tooltipEvent(ItemTooltipEvent event) {
        ItemStack item = event.getItemStack();
        if (!item.m_204117_(ItemTagGenerator.WIP) && !item.m_204117_(ItemTagGenerator.NYI)) {
            return;
        }
        if (item.m_204117_(ItemTagGenerator.WIP)) {
            event.getToolTip().add(WIP_TEXT_0);
            event.getToolTip().add(WIP_TEXT_1);
        } else {
            event.getToolTip().add(NYI_TEXT);
        }
    }

    @SubscribeEvent
    public static void FOVUpdate(EntityViewRenderEvent.FieldOfView event) {
        Item useItem;
        LivingEntity living;
        Entity entity = event.getCamera().m_90592_();
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_6117_() && ((useItem = living.m_21211_().m_41720_()) instanceof TripleBowItem || useItem instanceof EnderBowItem || useItem instanceof IceBowItem || useItem instanceof SeekerBowItem)) {
            float f = ((float)living.m_21252_() + (float)event.getPartialTicks()) / 20.0f;
            f = f > 1.0f ? 1.0f : f * f;
            event.setFOV(event.getFOV() * (double)(1.0f - f * 0.15f));
        }
    }

    @SubscribeEvent
    public static void unrenderHeadWithTrophies(RenderLivingEvent<?, ?> event) {
        EntityModel entityModel;
        boolean visible;
        ItemStack stack = event.getEntity().m_6844_(EquipmentSlot.HEAD);
        boolean bl = visible = !(stack.m_41720_() instanceof TrophyItem) && !(stack.m_41720_() instanceof SkullCandleItem) && !TFClientEvents.areCuriosEquipped(event.getEntity());
        if (!visible && (entityModel = event.getRenderer().m_7200_()) instanceof HeadedModel) {
            HeadedModel headedModel = (HeadedModel)entityModel;
            headedModel.m_5585_().f_104207_ = false;
            EntityModel entityModel2 = event.getRenderer().m_7200_();
            if (entityModel2 instanceof HumanoidModel) {
                HumanoidModel humanoidModel = (HumanoidModel)entityModel2;
                humanoidModel.f_102809_.f_104207_ = false;
            }
        }
    }

    private static boolean areCuriosEquipped(LivingEntity entity) {
        if (ModList.get().isLoaded("curios")) {
            return CuriosCompat.isTrophyCurioEquipped(entity) || CuriosCompat.isSkullCurioEquipped(entity);
        }
        return false;
    }

    @Mod.EventBusSubscriber(modid="twilightforest", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBusEvents {
        @SubscribeEvent
        public static void registerLoaders(ModelRegistryEvent event) {
            ModelLoaderRegistry.registerLoader((ResourceLocation)TwilightForestMod.prefix("patch"), (IModelLoader)PatchModelLoader.INSTANCE);
        }

        @Deprecated
        @SubscribeEvent
        public static void modelBake(ModelBakeEvent event) {
            ModBusEvents.fullbrightItem(event, TFItems.FIERY_INGOT);
            ModBusEvents.fullbrightItem(event, TFItems.FIERY_BOOTS);
            ModBusEvents.fullbrightItem(event, TFItems.FIERY_CHESTPLATE);
            ModBusEvents.fullbrightItem(event, TFItems.FIERY_HELMET);
            ModBusEvents.fullbrightItem(event, TFItems.FIERY_LEGGINGS);
            ModBusEvents.fullbrightItem(event, TFItems.FIERY_PICKAXE);
            ModBusEvents.fullbrightItem(event, TFItems.FIERY_SWORD);
            ModBusEvents.fullbrightItem(event, TFItems.RED_THREAD);
            ModBusEvents.fullbrightBlock(event, TFBlocks.FIERY_BLOCK);
            if (!ModList.get().isLoaded("ctm")) {
                ModBusEvents.tintedFullbrightBlock(event, TFBlocks.PINK_CASTLE_RUNE_BRICK, FullbrightBakedModel::disableCache);
                ModBusEvents.tintedFullbrightBlock(event, TFBlocks.BLUE_CASTLE_RUNE_BRICK, FullbrightBakedModel::disableCache);
                ModBusEvents.tintedFullbrightBlock(event, TFBlocks.YELLOW_CASTLE_RUNE_BRICK, FullbrightBakedModel::disableCache);
                ModBusEvents.tintedFullbrightBlock(event, TFBlocks.VIOLET_CASTLE_RUNE_BRICK, FullbrightBakedModel::disableCache);
            }
            if (ModList.get().isLoaded("immersiveengineering")) {
                IECompat.registerShaderModels(event);
            }
        }

        private static void fullbrightItem(ModelBakeEvent event, RegistryObject<Item> item) {
            ModBusEvents.fullbrightItem(event, item, f -> f);
        }

        private static void fullbrightItem(ModelBakeEvent event, RegistryObject<Item> item, UnaryOperator<FullbrightBakedModel> process) {
            ModBusEvents.fullbright(event, Objects.requireNonNull(item.getId()), "inventory", process);
        }

        private static void fullbrightBlock(ModelBakeEvent event, RegistryObject<Block> block) {
            ModBusEvents.fullbrightBlock(event, block, f -> f);
        }

        private static void fullbrightBlock(ModelBakeEvent event, RegistryObject<Block> block, UnaryOperator<FullbrightBakedModel> process) {
            ModBusEvents.fullbright(event, Objects.requireNonNull(block.getId()), "inventory", process);
            ModBusEvents.fullbright(event, Objects.requireNonNull(block.getId()), "", process);
        }

        private static void fullbright(ModelBakeEvent event, ResourceLocation rl, String state, UnaryOperator<FullbrightBakedModel> process) {
            ModelResourceLocation mrl = new ModelResourceLocation(rl, state);
            event.getModelRegistry().put(mrl, (BakedModel)process.apply(new FullbrightBakedModel((BakedModel)event.getModelRegistry().get(mrl))));
        }

        private static void tintedFullbrightItem(ModelBakeEvent event, RegistryObject<Item> item) {
            ModBusEvents.tintedFullbrightItem(event, item, f -> f);
        }

        private static void tintedFullbrightItem(ModelBakeEvent event, RegistryObject<Item> item, UnaryOperator<FullbrightBakedModel> process) {
            ModBusEvents.tintedFullbright(event, Objects.requireNonNull(item.getId()), "inventory", process);
        }

        private static void tintedFullbrightBlock(ModelBakeEvent event, RegistryObject<Block> block) {
            ModBusEvents.tintedFullbrightBlock(event, block, f -> f);
        }

        private static void tintedFullbrightBlock(ModelBakeEvent event, RegistryObject<Block> block, UnaryOperator<FullbrightBakedModel> process) {
            ModBusEvents.tintedFullbright(event, Objects.requireNonNull(block.getId()), "inventory", process);
            ModBusEvents.tintedFullbright(event, Objects.requireNonNull(block.getId()), "", process);
        }

        private static void tintedFullbright(ModelBakeEvent event, ResourceLocation rl, String state, UnaryOperator<FullbrightBakedModel> process) {
            ModelResourceLocation mrl = new ModelResourceLocation(rl, state);
            event.getModelRegistry().put(mrl, (BakedModel)process.apply(new TintIndexAwareFullbrightBakedModel((BakedModel)event.getModelRegistry().get(mrl))));
        }

        @SubscribeEvent
        public static void texStitch(TextureStitchEvent.Pre evt) {
            TextureAtlas map = evt.getAtlas();
            if (Sheets.f_110740_.equals((Object)map.m_118330_())) {
                TwilightChestRenderer.MATERIALS.values().stream().flatMap(e -> e.values().stream()).map(Material::m_119203_).forEach(arg_0 -> ((TextureStitchEvent.Pre)evt).addSprite(arg_0));
            }
            if (Sheets.f_110737_.equals((Object)map.m_118330_()) || Sheets.f_110738_.equals((Object)map.m_118330_())) {
                for (BannerPattern pattern : BannerPattern.values()) {
                    if (!pattern.m_58572_().startsWith("twilightforest")) continue;
                    evt.addSprite(pattern.m_58577_(Sheets.f_110737_.equals((Object)map.m_118330_())));
                }
            }
            evt.addSprite(TwilightForestMod.prefix("block/mosspatch"));
        }

        @SubscribeEvent
        public static void registerModels(ModelRegistryEvent event) {
            ForgeModelBakery.addSpecialModel((ResourceLocation)ShieldLayer.LOC);
            ForgeModelBakery.addSpecialModel((ResourceLocation)new ModelResourceLocation(TwilightForestMod.prefix("trophy"), "inventory"));
            ForgeModelBakery.addSpecialModel((ResourceLocation)new ModelResourceLocation(TwilightForestMod.prefix("trophy_minor"), "inventory"));
            ForgeModelBakery.addSpecialModel((ResourceLocation)new ModelResourceLocation(TwilightForestMod.prefix("trophy_quest"), "inventory"));
            ForgeModelBakery.addSpecialModel((ResourceLocation)TwilightForestMod.prefix("block/casket_obsidian"));
            ForgeModelBakery.addSpecialModel((ResourceLocation)TwilightForestMod.prefix("block/casket_stone"));
            ForgeModelBakery.addSpecialModel((ResourceLocation)TwilightForestMod.prefix("block/casket_basalt"));
        }
    }
}

