/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.capabilities;

import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import twilightforest.capabilities.shield.IShieldCapability;
import twilightforest.capabilities.shield.ShieldCapabilityHandler;

public class CapabilityList {
    public static final Capability<IShieldCapability> SHIELDS = CapabilityManager.get((CapabilityToken)new CapabilityToken<IShieldCapability>(){});

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(IShieldCapability.class);
    }

    public static void attachEntityCapability(final AttachCapabilitiesEvent<Entity> e) {
        if (e.getObject() instanceof LivingEntity) {
            e.addCapability(IShieldCapability.ID, (ICapabilityProvider)new ICapabilitySerializable<CompoundTag>(){
                final LazyOptional<IShieldCapability> inst = LazyOptional.of(() -> {
                    ShieldCapabilityHandler i = new ShieldCapabilityHandler();
                    i.setEntity((LivingEntity)e.getObject());
                    return i;
                });

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                    return SHIELDS.orEmpty(capability, this.inst.cast());
                }

                public CompoundTag serializeNBT() {
                    return (CompoundTag)((IShieldCapability)this.inst.orElseThrow(NullPointerException::new)).serializeNBT();
                }

                public void deserializeNBT(CompoundTag nbt) {
                    ((IShieldCapability)this.inst.orElseThrow(NullPointerException::new)).deserializeNBT((Tag)nbt);
                }
            });
        }
    }
}

