/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.settings;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.main.MainSettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;

public abstract class StorageSettingsHandler
extends SettingsHandler {
    public static final String SOPHISTICATED_STORAGE_SETTINGS_PLAYER_TAG = "sophisticatedStorageSettings";

    private static void onPlayerClone(PlayerEvent.Clone event) {
        CompoundTag oldData = event.getOriginal().getPersistentData();
        CompoundTag newData = event.getPlayer().getPersistentData();
        if (oldData.m_128441_(SOPHISTICATED_STORAGE_SETTINGS_PLAYER_TAG)) {
            newData.m_128365_(SOPHISTICATED_STORAGE_SETTINGS_PLAYER_TAG, oldData.m_128423_(SOPHISTICATED_STORAGE_SETTINGS_PLAYER_TAG));
        }
    }

    protected StorageSettingsHandler(CompoundTag contentsNbt, Runnable markContentsDirty, Supplier<InventoryHandler> inventoryHandlerSupplier, Supplier<RenderInfo> renderInfoSupplier) {
        super(contentsNbt, markContentsDirty, inventoryHandlerSupplier, renderInfoSupplier);
    }

    protected abstract int getNumberOfDisplayItems();

    protected CompoundTag getSettingsNbtFromContentsNbt(CompoundTag contentsNbt) {
        return contentsNbt;
    }

    protected void addItemDisplayCategory(Supplier<InventoryHandler> inventoryHandlerSupplier, Supplier<RenderInfo> renderInfoSupplier, CompoundTag settingsNbt) {
        this.addSettingsCategory(settingsNbt, "item_display", this.markContentsDirty, (categoryNbt, saveNbt) -> new ItemDisplaySettingsCategory(inventoryHandlerSupplier, renderInfoSupplier, categoryNbt, saveNbt, this.getNumberOfDisplayItems(), () -> (MemorySettingsCategory)this.getTypeCategory(MemorySettingsCategory.class)));
    }

    protected void addGlobalSettingsCategory(CompoundTag settingsNbt) {
        this.addSettingsCategory(settingsNbt, "global", this.markContentsDirty, (categoryNbt, saveNbt) -> new MainSettingsCategory(categoryNbt, saveNbt, SOPHISTICATED_STORAGE_SETTINGS_PLAYER_TAG));
    }

    protected void saveCategoryNbt(CompoundTag settingsNbt, String categoryName, CompoundTag tag) {
        this.contentsNbt.m_128365_(categoryName, (Tag)tag);
    }

    public void reloadFrom(CompoundTag contentsNbt) {
        this.contentsNbt = contentsNbt;
        super.reloadFrom(contentsNbt);
    }

    static {
        MinecraftForge.EVENT_BUS.addListener(StorageSettingsHandler::onPlayerClone);
    }
}

