/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.network;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu;

public class OpenStorageInventoryMessage {
    private final BlockPos pos;

    public OpenStorageInventoryMessage(BlockPos pos) {
        this.pos = pos;
    }

    public static void encode(OpenStorageInventoryMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130064_(msg.pos);
    }

    public static OpenStorageInventoryMessage decode(FriendlyByteBuf packetBuffer) {
        return new OpenStorageInventoryMessage(packetBuffer.m_130135_());
    }

    static void onMessage(OpenStorageInventoryMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> OpenStorageInventoryMessage.handleMessage(context.getSender(), msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(@Nullable ServerPlayer player, OpenStorageInventoryMessage msg) {
        if (player == null) {
            return;
        }
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((w, p, pl) -> new StorageContainerMenu(w, pl, msg.pos), WorldHelper.getBlockEntity((BlockGetter)player.f_19853_, (BlockPos)msg.pos, StorageBlockEntity.class).map(StorageBlockEntity::getDisplayName).orElse(TextComponent.f_131282_)), (BlockPos)msg.pos);
    }
}

