/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.p3pp3rf1y.sophisticatedcore.controller.ILinkable;
import net.p3pp3rf1y.sophisticatedcore.util.ItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class StorageToolItem
extends ItemBase {
    private static final String CONTROLLER_POS_TAG = "controllerPos";

    public StorageToolItem() {
        super(new Item.Properties().m_41487_(1), SophisticatedStorage.CREATIVE_TAB);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        Block blockClicked = level.m_8055_(pos).m_60734_();
        ItemStack tool = context.m_43722_();
        if (blockClicked == ModBlocks.CONTROLLER.get()) {
            this.setControllerLink(tool, pos);
            return InteractionResult.SUCCESS;
        }
        if (WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, ILinkable.class).map(linkable -> {
            StorageToolItem.getControllerLink(tool).ifPresentOrElse(arg_0 -> ((ILinkable)linkable).linkToController(arg_0), () -> ((ILinkable)linkable).unlinkFromController());
            return true;
        }).orElse(false).booleanValue()) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack tool;
        if (player.m_6144_() && StorageToolItem.getControllerLink(tool = player.m_21120_(usedHand)).isPresent()) {
            this.removeControllerLink(tool);
            return InteractionResultHolder.m_19090_((Object)tool);
        }
        return super.m_7203_(level, player, usedHand);
    }

    private void setControllerLink(ItemStack tool, BlockPos pos) {
        NBTHelper.setLong((ItemStack)tool, (String)CONTROLLER_POS_TAG, (long)pos.m_121878_());
    }

    public static Optional<BlockPos> getControllerLink(ItemStack tool) {
        return NBTHelper.getLong((ItemStack)tool, (String)CONTROLLER_POS_TAG).map(BlockPos::m_122022_);
    }

    private void removeControllerLink(ItemStack tool) {
        NBTHelper.removeTag((ItemStack)tool, (String)CONTROLLER_POS_TAG);
    }

    public static Component getOverlayMessage(ItemStack tool) {
        return StorageToolItem.getControllerLink(tool).map(controllerPos -> StorageTranslationHelper.INSTANCE.translItemOverlayMessage(tool.m_41720_(), "linking", controllerPos.m_123341_(), controllerPos.m_123342_(), controllerPos.m_123343_())).orElseGet(() -> StorageTranslationHelper.INSTANCE.translItemOverlayMessage(tool.m_41720_(), "unlinking", new Object[0]));
    }
}

