/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.util.ColorHelper;
import net.p3pp3rf1y.sophisticatedcore.util.ItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class StorageTierUpgradeItem
extends ItemBase {
    private static final Map<TierUpgrade, Map<Block, TierUpgradeDefinition<?>>> TIER_UPGRADE_DEFINITIONS = Map.of(TierUpgrade.BASIC, new HashMap(new ImmutableMap.Builder().put((Object)Blocks.f_50618_, new VanillaTierUpgradeDefinition<BarrelBlockEntity>((EnumProperty<Direction>)BlockStateProperties.f_61372_, BarrelBlockEntity.class, blockEntity -> blockEntity.f_155050_.m_155450_() > 0, (StorageBlockBase)ModBlocks.BARREL.get(), WoodType.f_61831_)).put((Object)Blocks.f_50087_, new VanillaTierUpgradeDefinition<ChestBlockEntity>((EnumProperty<Direction>)ChestBlock.f_51478_, ChestBlockEntity.class, chestBlockEntity -> chestBlockEntity.f_155324_.m_155450_() > 0, (StorageBlockBase)ModBlocks.CHEST.get(), WoodType.f_61830_)).put((Object)Blocks.f_50456_, new VanillaTierUpgradeDefinition<ShulkerBoxBlockEntity>((EnumProperty<Direction>)ShulkerBoxBlock.f_56183_, ShulkerBoxBlockEntity.class, shulkerBoxBlockEntity -> shulkerBoxBlockEntity.f_59646_ > 0, (StorageBlockBase)ModBlocks.SHULKER_BOX.get(), null)).put((Object)Blocks.f_50457_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.WHITE, (net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.SHULKER_BOX.get())).put((Object)Blocks.f_50458_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.ORANGE, (net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.SHULKER_BOX.get())).put((Object)Blocks.f_50459_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.MAGENTA, (net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.SHULKER_BOX.get())).put((Object)Blocks.f_50460_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.LIGHT_BLUE, (net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.SHULKER_BOX.get())).put((Object)Blocks.f_50461_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.YELLOW, (net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.SHULKER_BOX.get())).put((Object)Blocks.f_50462_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.LIME, (net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.SHULKER_BOX.get())).put((Object)Blocks.f_50463_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.PINK, (net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.SHULKER_BOX.get())).put((Object)Blocks.f_50464_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.GRAY, (net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.SHULKER_BOX.get())).put((Object)Blocks.f_50465_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.LIGHT_GRAY, (net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.SHULKER_BOX.get())).put((Object)Blocks.f_50466_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.CYAN, (net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.SHULKER_BOX.get())).put((Object)Blocks.f_50520_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.PURPLE, (net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.SHULKER_BOX.get())).put((Object)Blocks.f_50521_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.BLUE, (net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.SHULKER_BOX.get())).put((Object)Blocks.f_50522_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.BROWN, (net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.SHULKER_BOX.get())).put((Object)Blocks.f_50523_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.GREEN, (net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.SHULKER_BOX.get())).put((Object)Blocks.f_50524_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.RED, (net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.SHULKER_BOX.get())).put((Object)Blocks.f_50525_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.BLACK, (net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.SHULKER_BOX.get())).build()), TierUpgrade.BASIC_TO_IRON, new HashMap(new ImmutableMap.Builder().put((Object)Blocks.f_50618_, new VanillaTierUpgradeDefinition<BarrelBlockEntity>((EnumProperty<Direction>)BlockStateProperties.f_61372_, BarrelBlockEntity.class, blockEntity -> blockEntity.f_155050_.m_155450_() > 0, (StorageBlockBase)ModBlocks.IRON_BARREL.get(), WoodType.f_61831_)).put((Object)Blocks.f_50087_, new VanillaTierUpgradeDefinition<ChestBlockEntity>((EnumProperty<Direction>)ChestBlock.f_51478_, ChestBlockEntity.class, blockEntity -> blockEntity.f_155324_.m_155450_() > 0, (StorageBlockBase)ModBlocks.IRON_CHEST.get(), WoodType.f_61830_)).put((Object)Blocks.f_50456_, new VanillaTierUpgradeDefinition<ShulkerBoxBlockEntity>((EnumProperty<Direction>)ShulkerBoxBlock.f_56183_, ShulkerBoxBlockEntity.class, blockEntity -> blockEntity.f_59646_ > 0, (StorageBlockBase)ModBlocks.IRON_SHULKER_BOX.get(), null)).put((Object)Blocks.f_50457_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.WHITE, (net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.IRON_SHULKER_BOX.get())).put((Object)Blocks.f_50458_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.ORANGE, (net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.IRON_SHULKER_BOX.get())).put((Object)Blocks.f_50459_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.MAGENTA, (net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.IRON_SHULKER_BOX.get())).put((Object)Blocks.f_50460_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.LIGHT_BLUE, (net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.IRON_SHULKER_BOX.get())).put((Object)Blocks.f_50461_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.YELLOW, (net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.IRON_SHULKER_BOX.get())).put((Object)Blocks.f_50462_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.LIME, (net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.IRON_SHULKER_BOX.get())).put((Object)Blocks.f_50463_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.PINK, (net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.IRON_SHULKER_BOX.get())).put((Object)Blocks.f_50464_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.GRAY, (net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.IRON_SHULKER_BOX.get())).put((Object)Blocks.f_50465_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.LIGHT_GRAY, (net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.IRON_SHULKER_BOX.get())).put((Object)Blocks.f_50466_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.CYAN, (net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.IRON_SHULKER_BOX.get())).put((Object)Blocks.f_50520_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.PURPLE, (net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.IRON_SHULKER_BOX.get())).put((Object)Blocks.f_50521_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.BLUE, (net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.IRON_SHULKER_BOX.get())).put((Object)Blocks.f_50522_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.BROWN, (net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.IRON_SHULKER_BOX.get())).put((Object)Blocks.f_50523_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.GREEN, (net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.IRON_SHULKER_BOX.get())).put((Object)Blocks.f_50524_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.RED, (net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.IRON_SHULKER_BOX.get())).put((Object)Blocks.f_50525_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.BLACK, (net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.IRON_SHULKER_BOX.get())).put((Object)((Block)ModBlocks.BARREL.get()), (Object)new StorageTierUpgradeDefinition(BlockStateProperties.f_61372_, (StorageBlockBase)ModBlocks.IRON_BARREL.get())).put((Object)((Block)ModBlocks.CHEST.get()), (Object)new StorageTierUpgradeDefinition(ChestBlock.f_51478_, (StorageBlockBase)ModBlocks.IRON_CHEST.get())).put((Object)((Block)ModBlocks.SHULKER_BOX.get()), (Object)new StorageTierUpgradeDefinition(BlockStateProperties.f_61372_, (StorageBlockBase)ModBlocks.IRON_SHULKER_BOX.get())).build()), TierUpgrade.IRON_TO_GOLD, new HashMap<Block, StorageTierUpgradeDefinition>(Map.of((Block)ModBlocks.IRON_BARREL.get(), new StorageTierUpgradeDefinition(BlockStateProperties.f_61372_, (StorageBlockBase)ModBlocks.GOLD_BARREL.get()), (Block)ModBlocks.IRON_CHEST.get(), new StorageTierUpgradeDefinition(ChestBlock.f_51478_, (StorageBlockBase)ModBlocks.GOLD_CHEST.get()), (Block)ModBlocks.IRON_SHULKER_BOX.get(), new StorageTierUpgradeDefinition(BlockStateProperties.f_61372_, (StorageBlockBase)ModBlocks.GOLD_SHULKER_BOX.get()))), TierUpgrade.GOLD_TO_DIAMOND, new HashMap<Block, StorageTierUpgradeDefinition>(Map.of((Block)ModBlocks.GOLD_BARREL.get(), new StorageTierUpgradeDefinition(BlockStateProperties.f_61372_, (StorageBlockBase)ModBlocks.DIAMOND_BARREL.get()), (Block)ModBlocks.GOLD_CHEST.get(), new StorageTierUpgradeDefinition(ChestBlock.f_51478_, (StorageBlockBase)ModBlocks.DIAMOND_CHEST.get()), (Block)ModBlocks.GOLD_SHULKER_BOX.get(), new StorageTierUpgradeDefinition(BlockStateProperties.f_61372_, (StorageBlockBase)ModBlocks.DIAMOND_SHULKER_BOX.get()))), TierUpgrade.DIAMOND_TO_NETHERITE, new HashMap<Block, StorageTierUpgradeDefinition>(Map.of((Block)ModBlocks.DIAMOND_BARREL.get(), new StorageTierUpgradeDefinition(BlockStateProperties.f_61372_, (StorageBlockBase)ModBlocks.NETHERITE_BARREL.get()), (Block)ModBlocks.DIAMOND_CHEST.get(), new StorageTierUpgradeDefinition(ChestBlock.f_51478_, (StorageBlockBase)ModBlocks.NETHERITE_CHEST.get()), (Block)ModBlocks.DIAMOND_SHULKER_BOX.get(), new StorageTierUpgradeDefinition(BlockStateProperties.f_61372_, (StorageBlockBase)ModBlocks.NETHERITE_SHULKER_BOX.get()))));
    private final TierUpgrade tier;
    private final boolean hasTooltip;

    public static void addTierUpgradeDefinition(TierUpgrade tier, Block block, TierUpgradeDefinition<?> tierUpgradeDefinition) {
        TIER_UPGRADE_DEFINITIONS.get((Object)tier).put(block, tierUpgradeDefinition);
    }

    public StorageTierUpgradeItem(TierUpgrade tier) {
        this(tier, false);
    }

    public StorageTierUpgradeItem(TierUpgrade tier, boolean hasTooltip) {
        super(new Item.Properties().m_41487_(1), SophisticatedStorage.CREATIVE_TAB);
        this.tier = tier;
        this.hasTooltip = hasTooltip;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        if (this.hasTooltip) {
            tooltipComponents.addAll(StorageTranslationHelper.INSTANCE.getTranslatedLines(stack.m_41720_().m_5524_() + ".tooltip", null, new ChatFormatting[]{ChatFormatting.DARK_GRAY}));
        }
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.PASS;
        }
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        if (TIER_UPGRADE_DEFINITIONS.get((Object)this.tier).containsKey(state.m_60734_())) {
            TierUpgradeDefinition<?> def = TIER_UPGRADE_DEFINITIONS.get((Object)this.tier).get(state.m_60734_());
            return WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, def.blockEntityClass()).map(be -> this.tryUpgradeStorage(stack, context, pos, level, state, def, (BlockEntity)be)).orElse(InteractionResult.PASS);
        }
        return super.onItemUseFirst(stack, context);
    }

    private <B extends BlockEntity> InteractionResult tryUpgradeStorage(ItemStack stack, UseOnContext context, BlockPos pos, Level level, BlockState state, TierUpgradeDefinition<B> def, BlockEntity blockEntity) {
        BlockEntity be = (BlockEntity)def.blockEntityClass().cast(blockEntity);
        if (def.isUpgradingBlocked().test(be)) {
            return InteractionResult.PASS;
        }
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (!def.upgradeStorage(player, pos, level, state, be)) {
            return InteractionResult.PASS;
        }
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        return InteractionResult.SUCCESS;
    }

    public static enum TierUpgrade {
        BASIC,
        BASIC_TO_IRON,
        IRON_TO_GOLD,
        GOLD_TO_DIAMOND,
        DIAMOND_TO_NETHERITE;

    }

    private static abstract class TierUpgradeDefinition<B extends BlockEntity> {
        private final EnumProperty<Direction> facingProperty;
        private final Class<B> blockEntityClass;
        private final Predicate<B> isUpgradingBlocked;
        private final StorageBlockBase newBlock;

        private TierUpgradeDefinition(EnumProperty<Direction> facingProperty, Class<B> blockEntityClass, Predicate<B> isUpgradingBlocked, StorageBlockBase newBlock) {
            this.facingProperty = facingProperty;
            this.blockEntityClass = blockEntityClass;
            this.isUpgradingBlocked = isUpgradingBlocked;
            this.newBlock = newBlock;
        }

        public EnumProperty<Direction> facingProperty() {
            return this.facingProperty;
        }

        public Class<B> blockEntityClass() {
            return this.blockEntityClass;
        }

        public Predicate<B> isUpgradingBlocked() {
            return this.isUpgradingBlocked;
        }

        public StorageBlockBase newBlock() {
            return this.newBlock;
        }

        abstract boolean upgradeStorage(@Nullable Player var1, BlockPos var2, Level var3, BlockState var4, B var5);
    }

    public static class VanillaTierUpgradeDefinition<B extends RandomizableContainerBlockEntity>
    extends TierUpgradeDefinition<B> {
        @Nullable
        private final WoodType woodType;
        private final int color;

        public VanillaTierUpgradeDefinition(EnumProperty<Direction> facingProperty, Class<B> blockEntityClass, Predicate<B> isUpgradingBlocked, StorageBlockBase newBlock, @Nullable WoodType woodType) {
            this(facingProperty, blockEntityClass, isUpgradingBlocked, newBlock, woodType, -1);
        }

        private VanillaTierUpgradeDefinition(EnumProperty<Direction> facingProperty, Class<B> blockEntityClass, Predicate<B> isUpgradingBlocked, StorageBlockBase newBlock, @Nullable WoodType woodType, DyeColor color) {
            this(facingProperty, blockEntityClass, isUpgradingBlocked, newBlock, woodType, ColorHelper.getColor((float[])color.m_41068_()));
        }

        private VanillaTierUpgradeDefinition(EnumProperty<Direction> facingProperty, Class<B> blockEntityClass, Predicate<B> isUpgradingBlocked, StorageBlockBase newBlock, @Nullable WoodType woodType, int color) {
            super(facingProperty, blockEntityClass, isUpgradingBlocked, newBlock);
            this.woodType = woodType;
            this.color = color;
        }

        @Nullable
        public WoodType woodType() {
            return this.woodType;
        }

        @Override
        boolean upgradeStorage(@Nullable Player player, BlockPos pos, Level level, BlockState state, B be) {
            if (player == null || !be.m_7525_(player)) {
                return false;
            }
            Direction facing = (Direction)state.m_61143_((Property)this.facingProperty());
            Component customName = be.m_7770_();
            NonNullList items = NonNullList.m_122779_();
            for (int slot = 0; slot < be.m_6643_(); ++slot) {
                items.add(slot, (Object)be.m_8020_(slot));
            }
            BlockState newBlockState = this.newBlock().m_49966_();
            newBlockState = (BlockState)newBlockState.m_61124_((Property)this.facingProperty(), (Comparable)facing);
            StorageBlockEntity newBlockEntity = this.newBlock().newBlockEntity(pos, newBlockState);
            this.setStorageItemsNameAndWoodType(newBlockEntity, customName, (NonNullList<ItemStack>)items, this.woodType());
            newBlockEntity.setUpdateBlockRender();
            this.replaceBlockAndBlockEntity(newBlockState, newBlockEntity, pos, level);
            newBlockEntity.tryToAddToController();
            WorldHelper.notifyBlockUpdate((BlockEntity)newBlockEntity);
            return true;
        }

        private void replaceBlockAndBlockEntity(BlockState newBlockState, BlockEntity newBlockEntity, BlockPos pos, Level level) {
            level.m_46747_(pos);
            level.m_7471_(pos, false);
            level.m_7731_(pos, newBlockState, 3);
            level.m_151523_(newBlockEntity);
        }

        private void setStorageItemsNameAndWoodType(StorageBlockEntity newBe, @Nullable Component customName, NonNullList<ItemStack> items, @Nullable WoodType woodType) {
            StorageWrapper storageWrapper;
            InventoryHandler inventoryHandler;
            if (customName != null) {
                newBe.setCustomName(customName);
            }
            if ((inventoryHandler = (storageWrapper = newBe.getStorageWrapper()).getInventoryHandler()).getSlots() < items.size()) {
                inventoryHandler.setSize(items.size());
            }
            for (int slot = 0; slot < items.size(); ++slot) {
                inventoryHandler.setStackInSlot(slot, (ItemStack)items.get(slot));
            }
            if (woodType != null && newBe instanceof WoodStorageBlockEntity) {
                WoodStorageBlockEntity wbe = (WoodStorageBlockEntity)newBe;
                wbe.setWoodType(woodType);
            }
            if (this.color > -1) {
                storageWrapper.setMainColor(this.color);
                storageWrapper.setAccentColor(this.color);
            }
        }
    }

    private static class VanillaTintedShulkerBoxTierUpgradeDefinition
    extends VanillaTierUpgradeDefinition<ShulkerBoxBlockEntity> {
        private VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor color, net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock newBlock) {
            super((EnumProperty<Direction>)ShulkerBoxBlock.f_56183_, ShulkerBoxBlockEntity.class, shulkerBoxBlockEntity -> shulkerBoxBlockEntity.f_59646_ > 0, (StorageBlockBase)newBlock, null, color);
        }
    }

    private static class StorageTierUpgradeDefinition
    extends TierUpgradeDefinition<StorageBlockEntity> {
        private StorageTierUpgradeDefinition(DirectionProperty facingProperty, StorageBlockBase newBlock) {
            super((EnumProperty<Direction>)facingProperty, StorageBlockEntity.class, storageBlockEntity -> {
                WoodStorageBlockEntity wbe;
                return storageBlockEntity.isOpen() || storageBlockEntity instanceof WoodStorageBlockEntity && (wbe = (WoodStorageBlockEntity)((Object)storageBlockEntity)).isPacked();
            }, newBlock);
        }

        @Override
        boolean upgradeStorage(@Nullable Player player, BlockPos pos, Level level, BlockState state, StorageBlockEntity blockEntity) {
            CompoundTag beTag = new CompoundTag();
            blockEntity.m_183515_(beTag);
            Direction facing = (Direction)state.m_61143_(this.facingProperty());
            BlockState newBlockState = this.newBlock().m_49966_();
            newBlockState = (BlockState)newBlockState.m_61124_(this.facingProperty(), (Comparable)facing);
            StorageBlockEntity newBlockEntity = this.newBlock().newBlockEntity(pos, newBlockState);
            int newInventorySize = newBlockEntity.getStorageWrapper().getInventoryHandler().getSlots();
            int newUpgradeSize = newBlockEntity.getStorageWrapper().getUpgradeHandler().getSlots();
            newBlockEntity.m_142466_(beTag);
            blockEntity.setBeingUpgraded();
            level.m_46747_(pos);
            level.m_7471_(pos, false);
            level.m_7731_(pos, newBlockState, 3);
            level.m_151523_((BlockEntity)newBlockEntity);
            newBlockEntity.increaseStorageSize(newInventorySize - newBlockEntity.getStorageWrapper().getInventoryHandler().getSlots(), newUpgradeSize - newBlockEntity.getStorageWrapper().getUpgradeHandler().getSlots());
            WorldHelper.notifyBlockUpdate((BlockEntity)newBlockEntity);
            return true;
        }
    }
}

