/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.p3pp3rf1y.sophisticatedstorage.data.CopyStorageDataFunction;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class StorageBlockLootProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    StorageBlockLootProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_6865_(HashCache cache) throws IOException {
        HashMap<ResourceLocation, LootTable.Builder> tables = new HashMap<ResourceLocation, LootTable.Builder>();
        tables.put(ModBlocks.BARREL.getId(), StorageBlockLootProvider.getStorage((Item)ModBlocks.BARREL_ITEM.get()));
        tables.put(ModBlocks.IRON_BARREL.getId(), StorageBlockLootProvider.getStorage((Item)ModBlocks.IRON_BARREL_ITEM.get()));
        tables.put(ModBlocks.GOLD_BARREL.getId(), StorageBlockLootProvider.getStorage((Item)ModBlocks.GOLD_BARREL_ITEM.get()));
        tables.put(ModBlocks.DIAMOND_BARREL.getId(), StorageBlockLootProvider.getStorage((Item)ModBlocks.DIAMOND_BARREL_ITEM.get()));
        tables.put(ModBlocks.NETHERITE_BARREL.getId(), StorageBlockLootProvider.getStorage((Item)ModBlocks.NETHERITE_BARREL_ITEM.get()));
        tables.put(ModBlocks.CHEST.getId(), StorageBlockLootProvider.getStorage((Item)ModBlocks.CHEST_ITEM.get()));
        tables.put(ModBlocks.IRON_CHEST.getId(), StorageBlockLootProvider.getStorage((Item)ModBlocks.IRON_CHEST_ITEM.get()));
        tables.put(ModBlocks.GOLD_CHEST.getId(), StorageBlockLootProvider.getStorage((Item)ModBlocks.GOLD_CHEST_ITEM.get()));
        tables.put(ModBlocks.DIAMOND_CHEST.getId(), StorageBlockLootProvider.getStorage((Item)ModBlocks.DIAMOND_CHEST_ITEM.get()));
        tables.put(ModBlocks.NETHERITE_CHEST.getId(), StorageBlockLootProvider.getStorage((Item)ModBlocks.NETHERITE_CHEST_ITEM.get()));
        tables.put(ModBlocks.SHULKER_BOX.getId(), StorageBlockLootProvider.getStorage((Item)ModBlocks.SHULKER_BOX_ITEM.get()));
        tables.put(ModBlocks.IRON_SHULKER_BOX.getId(), StorageBlockLootProvider.getStorage((Item)ModBlocks.IRON_SHULKER_BOX_ITEM.get()));
        tables.put(ModBlocks.GOLD_SHULKER_BOX.getId(), StorageBlockLootProvider.getStorage((Item)ModBlocks.GOLD_SHULKER_BOX_ITEM.get()));
        tables.put(ModBlocks.DIAMOND_SHULKER_BOX.getId(), StorageBlockLootProvider.getStorage((Item)ModBlocks.DIAMOND_SHULKER_BOX_ITEM.get()));
        tables.put(ModBlocks.NETHERITE_SHULKER_BOX.getId(), StorageBlockLootProvider.getStorage((Item)ModBlocks.NETHERITE_SHULKER_BOX_ITEM.get()));
        tables.put(ModBlocks.CONTROLLER.getId(), StorageBlockLootProvider.createSingleItemTable((ItemLike)ModBlocks.CONTROLLER_ITEM.get()));
        tables.put(ModBlocks.STORAGE_LINK.getId(), StorageBlockLootProvider.createSingleItemTable((ItemLike)ModBlocks.STORAGE_LINK_ITEM.get()));
        for (Map.Entry e : tables.entrySet()) {
            Path path = StorageBlockLootProvider.getPath(this.generator.m_123916_(), (ResourceLocation)e.getKey());
            DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)LootTables.m_79200_((LootTable)((LootTable.Builder)e.getValue()).m_79165_(LootContextParamSets.f_81421_).m_79167_()), (Path)path);
        }
    }

    public String m_6055_() {
        return "SophisticatedStorage block loot tables";
    }

    private static Path getPath(Path root, ResourceLocation id) {
        return root.resolve("data/" + id.m_135827_() + "/loot_tables/blocks/" + id.m_135815_() + ".json");
    }

    private static LootTable.Builder getStorage(Item storageItem) {
        LootPoolSingletonContainer.Builder entry = LootItem.m_79579_((ItemLike)storageItem);
        LootPool.Builder pool = LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)entry).m_5577_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_5577_((LootItemFunction.Builder)CopyStorageDataFunction.builder());
        return LootTable.m_79147_().m_79161_(pool);
    }

    protected static LootTable.Builder createSingleItemTable(ItemLike item) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item)));
    }
}

