/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.common;

import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.network.SyncPlayerSettingsMessage;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsManager;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.ItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;

public class CommonEventHandler {
    private static final int AVERAGE_MAX_ITEM_ENTITY_DROP_COUNT = 20;

    public void registerHandlers() {
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addListener(this::onPlayerLoggedIn);
        eventBus.addListener(this::onPlayerChangedDimension);
        eventBus.addListener(this::onPlayerRespawn);
        eventBus.addListener(this::onBlockBreak);
    }

    private void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        this.sendPlayerSettingsToClient(event.getPlayer());
    }

    private void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        this.sendPlayerSettingsToClient(event.getPlayer());
    }

    private void sendPlayerSettingsToClient(Player player) {
        String playerTagName = "sophisticatedStorageSettings";
        SophisticatedCore.PACKET_HANDLER.sendToClient((ServerPlayer)player, (Object)new SyncPlayerSettingsMessage(playerTagName, SettingsManager.getPlayerSettingsTag((Player)player, (String)playerTagName)));
    }

    private void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        this.sendPlayerSettingsToClient(event.getPlayer());
    }

    private void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!(event.getState().m_60734_() instanceof WoodStorageBlockBase) || player.m_6144_()) {
            return;
        }
        Level level = player.m_183503_();
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)event.getPos(), WoodStorageBlockEntity.class).ifPresent(wbe -> {
            if (wbe.isPacked()) {
                return;
            }
            AtomicInteger droppedItemEntityCount = new AtomicInteger(0);
            InventoryHelper.iterate((IItemHandler)wbe.getStorageWrapper().getInventoryHandler(), (slot, stack) -> {
                if (stack.m_41619_()) {
                    return;
                }
                droppedItemEntityCount.addAndGet((int)Math.ceil((double)stack.m_41613_() / (double)Math.min(stack.m_41741_(), 20)));
            });
            if (droppedItemEntityCount.get() > (Integer)Config.COMMON.tooManyItemEntityDrops.get()) {
                event.setCanceled(true);
                ItemBase packingTapeItem = (ItemBase)ModItems.PACKING_TAPE.get();
                Component packingTapeItemName = packingTapeItem.m_7626_(new ItemStack((ItemLike)packingTapeItem));
                if (packingTapeItemName instanceof TranslatableComponent) {
                    TranslatableComponent c = (TranslatableComponent)packingTapeItemName;
                    c.m_130940_(ChatFormatting.GREEN);
                }
                player.m_6352_(StorageTranslationHelper.INSTANCE.translStatusMessage("too_many_item_entity_drops", new Object[]{event.getState().m_60734_().m_49954_().m_130940_(ChatFormatting.GREEN), new TextComponent(String.valueOf(droppedItemEntityCount.get())).m_130940_(ChatFormatting.RED), packingTapeItemName}), Util.f_137441_);
            }
        });
    }
}

