/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ShulkerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DisplayItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

@OnlyIn(value=Dist.CLIENT)
public class ShulkerBoxRenderer
implements BlockEntityRenderer<ShulkerBoxBlockEntity> {
    private static final String ENTITY_SHULKER_BOX_FOLDER = "entity/shulker_box/";
    public static final Material BASE_TIER_MATERIAL = new Material(Sheets.f_110735_, SophisticatedStorage.getRL("entity/shulker_box/base_tier"));
    public static final Material IRON_TIER_MATERIAL = new Material(Sheets.f_110735_, SophisticatedStorage.getRL("entity/shulker_box/iron_tier"));
    public static final Material GOLD_TIER_MATERIAL = new Material(Sheets.f_110735_, SophisticatedStorage.getRL("entity/shulker_box/gold_tier"));
    public static final Material DIAMOND_TIER_MATERIAL = new Material(Sheets.f_110735_, SophisticatedStorage.getRL("entity/shulker_box/diamond_tier"));
    public static final Material NETHERITE_TIER_MATERIAL = new Material(Sheets.f_110735_, SophisticatedStorage.getRL("entity/shulker_box/netherite_tier"));
    public static final Material TINTABLE_MAIN_MATERIAL = new Material(Sheets.f_110735_, SophisticatedStorage.getRL("entity/shulker_box/tintable_main"));
    public static final Material TINTABLE_ACCENT_MATERIAL = new Material(Sheets.f_110735_, SophisticatedStorage.getRL("entity/shulker_box/tintable_accent"));
    public static final Material NO_TINT_MATERIAL = new Material(Sheets.f_110735_, SophisticatedStorage.getRL("entity/shulker_box/no_tint"));
    private final ShulkerModel<?> model;

    public ShulkerBoxRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new ShulkerModel(context.m_173582_(ModelLayers.f_171180_));
    }

    public void render(ShulkerBoxBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        VertexConsumer vertexconsumer;
        BlockState blockstate;
        BlockState blockState = blockEntity.m_58900_();
        Direction direction = Direction.UP;
        if (blockEntity.m_58898_() && (blockstate = blockEntity.m_58904_().m_8055_(blockEntity.m_58899_())).m_60734_() instanceof ShulkerBoxBlock) {
            direction = (Direction)blockstate.m_61143_(ShulkerBoxBlock.FACING);
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_85841_(0.9995f, 0.9995f, 0.9995f);
        poseStack.m_85845_(direction.m_122406_());
        poseStack.m_85841_(1.0f, -1.0f, -1.0f);
        poseStack.m_85837_(0.0, -1.0, 0.0);
        ModelPart lidPart = this.model.m_103742_();
        lidPart.m_104227_(0.0f, 24.0f - blockEntity.getProgress(partialTick) * 0.5f * 16.0f, 0.0f);
        lidPart.f_104204_ = 270.0f * blockEntity.getProgress(partialTick) * ((float)Math.PI / 180);
        int mainColor = blockEntity.getStorageWrapper().getMainColor();
        int accentColor = blockEntity.getStorageWrapper().getAccentColor();
        if (mainColor == -1 || accentColor == -1) {
            vertexconsumer = NO_TINT_MATERIAL.m_119194_(bufferSource, RenderType::m_110458_);
            this.model.m_7695_(poseStack, vertexconsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (mainColor > -1) {
            this.renderTintedModel(poseStack, bufferSource, packedLight, packedOverlay, mainColor, TINTABLE_MAIN_MATERIAL);
        }
        if (accentColor > -1) {
            this.renderTintedModel(poseStack, bufferSource, packedLight, packedOverlay, accentColor, TINTABLE_ACCENT_MATERIAL);
        }
        vertexconsumer = this.getTierMaterial(blockState.m_60734_()).m_119194_(bufferSource, RenderType::m_110458_);
        this.model.m_7695_(poseStack, vertexconsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
        DisplayItemRenderer.renderDisplayItem(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, 0.5, 0.5);
    }

    private Material getTierMaterial(Block block) {
        if (block == ModBlocks.IRON_SHULKER_BOX.get()) {
            return IRON_TIER_MATERIAL;
        }
        if (block == ModBlocks.GOLD_SHULKER_BOX.get()) {
            return GOLD_TIER_MATERIAL;
        }
        if (block == ModBlocks.DIAMOND_SHULKER_BOX.get()) {
            return DIAMOND_TIER_MATERIAL;
        }
        if (block == ModBlocks.NETHERITE_SHULKER_BOX.get()) {
            return NETHERITE_TIER_MATERIAL;
        }
        return BASE_TIER_MATERIAL;
    }

    private void renderTintedModel(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, int mainColor, Material material) {
        float tintRed = (float)(mainColor >> 16 & 0xFF) / 255.0f;
        float tingGreen = (float)(mainColor >> 8 & 0xFF) / 255.0f;
        float tintBlue = (float)(mainColor & 0xFF) / 255.0f;
        VertexConsumer vertexconsumer = material.m_119194_(bufferSource, RenderType::m_110458_);
        this.model.m_7695_(poseStack, vertexconsumer, packedLight, packedOverlay, tintRed, tingGreen, tintBlue, 1.0f);
    }
}

