/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;

public class ShulkerBoxDynamicModel
implements IModelGeometry<ShulkerBoxDynamicModel> {
    private static final String BLOCK_BREAK_FOLDER = "block/break/";
    public static final ResourceLocation TINTABLE_BREAK_TEXTURE = SophisticatedStorage.getRL("block/break/tintable_shulker_box");
    public static final ResourceLocation MAIN_BREAK_TEXTURE = SophisticatedStorage.getRL("block/break/shulker_box");

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        return new ShulkerBoxBakedModel();
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return Collections.emptySet();
    }

    private static class ShulkerBoxBakedModel
    implements BakedModel {
        private static final ModelProperty<Boolean> HAS_MAIN_COLOR = new ModelProperty();

        private ShulkerBoxBakedModel() {
        }

        public List<BakedQuad> m_6840_(@Nullable BlockState state, @Nullable Direction side, Random rand) {
            return Collections.emptyList();
        }

        public boolean m_7541_() {
            return true;
        }

        public boolean m_7539_() {
            return true;
        }

        public boolean m_7547_() {
            return true;
        }

        public boolean m_7521_() {
            return true;
        }

        public TextureAtlasSprite m_6160_() {
            BakedModel model = Minecraft.m_91087_().m_91304_().m_119422_(BlockModelShaper.m_110895_((BlockState)Blocks.f_50705_.m_49966_()));
            return model.m_6160_();
        }

        @Nonnull
        public IModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, IModelData modelData) {
            return WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).map(be -> {
                ModelDataMap.Builder builder = new ModelDataMap.Builder();
                builder.withInitial(HAS_MAIN_COLOR, (Object)(be.getStorageWrapper().getMainColor() > -1 ? 1 : 0));
                return builder.build();
            }).orElse((IModelData)EmptyModelData.INSTANCE);
        }

        public TextureAtlasSprite getParticleIcon(IModelData data) {
            ResourceLocation texture = TINTABLE_BREAK_TEXTURE;
            if (Boolean.FALSE.equals(data.getData(HAS_MAIN_COLOR))) {
                texture = MAIN_BREAK_TEXTURE;
            }
            return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(texture);
        }

        public ItemOverrides m_7343_() {
            return new ItemOverrides(){};
        }
    }

    public static final class Loader
    implements IModelLoader<ShulkerBoxDynamicModel> {
        public static final Loader INSTANCE = new Loader();

        public ShulkerBoxDynamicModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            return new ShulkerBoxDynamicModel();
        }

        public void m_6213_(ResourceManager resourceManager) {
        }
    }
}

