/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;

public class DisplayItemRenderer {
    public static final float SMALL_3D_ITEM_SCALE = 0.65f;
    static final float BIG_2D_ITEM_SCALE = 0.65f;
    static final float SMALL_2D_ITEM_SCALE = 0.35f;
    private static final Cache<Integer, Double> ITEM_HASHCODE_OFFSETS = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build();

    private DisplayItemRenderer() {
    }

    public static void renderDisplayItem(StorageBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, double yCenterTranslation, double blockSideOffset) {
        blockEntity.getStorageWrapper().getRenderInfo().getItemDisplayRenderInfo().getDisplayItem().ifPresent(displayItem -> {
            BlockState blockState = blockEntity.m_58900_();
            Block patt2388$temp = blockState.m_60734_();
            if (!(patt2388$temp instanceof StorageBlockBase)) {
                return;
            }
            StorageBlockBase storageBlock = (StorageBlockBase)patt2388$temp;
            Direction facing = storageBlock.getFacing(blockState);
            Minecraft minecraft = Minecraft.m_91087_();
            DisplayItemRenderer.renderSingleItem(poseStack, bufferSource, packedLight, packedOverlay, yCenterTranslation, blockSideOffset, facing, minecraft, displayItem, false, 0, 1);
        });
    }

    public static void renderDisplayItems(StorageBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, double yCenterTranslation, double blockSideOffset, boolean renderOnlyCustom) {
        List displayItems = blockEntity.getStorageWrapper().getRenderInfo().getItemDisplayRenderInfo().getDisplayItems();
        if (displayItems.isEmpty()) {
            return;
        }
        BlockState blockState = blockEntity.m_58900_();
        Block block = blockState.m_60734_();
        if (!(block instanceof StorageBlockBase)) {
            return;
        }
        StorageBlockBase storageBlock = (StorageBlockBase)block;
        Direction facing = storageBlock.getFacing(blockState);
        Minecraft minecraft = Minecraft.m_91087_();
        int displayItemIndex = 0;
        int displayItemCount = displayItems.size();
        for (RenderInfo.DisplayItem displayItem : displayItems) {
            DisplayItemRenderer.renderSingleItem(poseStack, bufferSource, packedLight, packedOverlay, yCenterTranslation, blockSideOffset, facing, minecraft, displayItem, renderOnlyCustom, displayItemIndex, displayItemCount);
            ++displayItemIndex;
        }
    }

    private static void renderSingleItem(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, double yCenterTranslation, double blockSideOffset, Direction facing, Minecraft minecraft, RenderInfo.DisplayItem displayItem, boolean renderOnlyCustom, int displayItemIndex, int displayItemCount) {
        ItemStack item = displayItem.getItem();
        BakedModel itemModel = minecraft.m_91291_().m_174264_(item, null, (LivingEntity)minecraft.f_91074_, 0);
        if (!itemModel.m_7521_() && renderOnlyCustom) {
            return;
        }
        float itemOffset = (float)DisplayItemRenderer.getDisplayItemOffset(item, itemModel, displayItemCount == 1 ? 1.0f : 0.65f);
        poseStack.m_85836_();
        Vec3i normal = facing.m_122436_();
        Vector3f offset = new Vector3f((float)(blockSideOffset + (double)itemOffset), (float)blockSideOffset + itemOffset, (float)(blockSideOffset + (double)itemOffset));
        offset.m_122263_((float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_());
        Vector3f frontOffset = DisplayItemRenderer.getDisplayItemIndexFrontOffset(displayItemIndex, displayItemCount, (float)yCenterTranslation, facing);
        offset.m_122253_(frontOffset);
        poseStack.m_85837_((double)offset.m_122239_(), (double)offset.m_122260_(), (double)offset.m_122269_());
        poseStack.m_85845_(DisplayItemRenderer.getNorthBasedRotation(facing));
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_((float)displayItem.getRotation()));
        float itemScale = displayItemCount == 1 ? (itemModel.m_7539_() ? 1.0f : 0.65f) : (itemModel.m_7539_() ? 0.65f : 0.35f);
        poseStack.m_85841_(itemScale, itemScale, itemScale);
        minecraft.m_91291_().m_115143_(item, ItemTransforms.TransformType.FIXED, false, poseStack, bufferSource, packedLight, packedOverlay, itemModel);
        poseStack.m_85849_();
    }

    public static double getDisplayItemOffset(ItemStack item, BakedModel itemModel, float additionalScale) {
        int hash = ItemStackKey.getHashCode((ItemStack)item) * 31 + Float.hashCode(additionalScale);
        Double offset = (Double)ITEM_HASHCODE_OFFSETS.getIfPresent((Object)hash);
        if (offset != null) {
            return offset;
        }
        offset = DisplayItemRenderer.calculateDisplayItemOffset(item, itemModel, additionalScale);
        ITEM_HASHCODE_OFFSETS.put((Object)hash, (Object)offset);
        return offset;
    }

    private static double calculateDisplayItemOffset(ItemStack item, BakedModel itemModel, float additionalScale) {
        Item item2;
        double itemOffset = 0.0;
        if (itemModel.m_7539_() && (item2 = item.m_41720_()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item2;
            Block block = blockItem.m_40614_();
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null) {
                itemOffset = DisplayItemRenderer.calculateOffsetFromModelOrShape(itemModel, block, level, additionalScale);
            }
        }
        return itemOffset;
    }

    private static double calculateOffsetFromModelOrShape(BakedModel itemModel, Block block, ClientLevel level, float additionalScale) {
        if (itemModel.m_7521_()) {
            return DisplayItemRenderer.transformBoundsCornersAndCalculateOffset(itemModel, DisplayItemRenderer.getBoundsCornersFromShape(block, level), additionalScale);
        }
        return DisplayItemRenderer.transformBoundsCornersAndCalculateOffset(itemModel, DisplayItemRenderer.getBoundsCornersFromModel(itemModel, (Level)level), additionalScale);
    }

    private static double transformBoundsCornersAndCalculateOffset(BakedModel itemModel, Set<Vector3f> points, float additionalScale) {
        ItemTransform transform = itemModel.m_7442_().m_111808_(ItemTransforms.TransformType.FIXED);
        points = DisplayItemRenderer.scalePoints(points, transform.f_111757_);
        points = DisplayItemRenderer.rotatePoints(points, transform.f_111755_);
        points = DisplayItemRenderer.translatePoints(points, transform.f_111756_);
        float zScale = transform.f_111757_.m_122269_();
        return ((double)(zScale * 1.0f) / 8.0 - DisplayItemRenderer.getMaxZ(points)) * (double)additionalScale;
    }

    private static Set<Vector3f> getBoundsCornersFromShape(Block block, ClientLevel level) {
        VoxelShape shape = block.m_5940_(block.m_49966_(), (BlockGetter)level, BlockPos.f_121853_, CollisionContext.m_82749_());
        return DisplayItemRenderer.getCornerPointsRelativeToCenter(shape.m_83215_());
    }

    private static Set<Vector3f> getBoundsCornersFromModel(BakedModel itemModel, Level level) {
        float minX = 2.0f;
        float minY = 2.0f;
        float minZ = 2.0f;
        float maxX = -2.0f;
        float maxY = -2.0f;
        float maxZ = -2.0f;
        for (Direction direction : Direction.values()) {
            List quads = itemModel.getQuads(null, direction, level.f_46441_, (IModelData)EmptyModelData.INSTANCE);
            for (BakedQuad quad : quads) {
                int i = 0;
                int[] verts = quad.m_111303_();
                while (i + 2 < verts.length) {
                    float x = Float.intBitsToFloat(verts[i]);
                    float y = Float.intBitsToFloat(verts[i + 1]);
                    float z = Float.intBitsToFloat(verts[i + 2]);
                    minX = Math.min(minX, x);
                    maxX = Math.max(maxX, x);
                    minY = Math.min(minY, y);
                    maxY = Math.max(maxY, y);
                    minZ = Math.min(minZ, z);
                    maxZ = Math.max(maxZ, z);
                    i += 8;
                }
            }
        }
        List quads = itemModel.getQuads(null, null, level.f_46441_, (IModelData)EmptyModelData.INSTANCE);
        for (BakedQuad quad : quads) {
            int i = 0;
            int[] verts = quad.m_111303_();
            while (i + 2 < verts.length) {
                float x = Float.intBitsToFloat(verts[i]);
                float y = Float.intBitsToFloat(verts[i + 1]);
                float z = Float.intBitsToFloat(verts[i + 2]);
                minX = Math.min(minX, x);
                maxX = Math.max(maxX, x);
                minY = Math.min(minY, y);
                maxY = Math.max(maxY, y);
                minZ = Math.min(minZ, z);
                maxZ = Math.max(maxZ, z);
                i += 8;
            }
        }
        return DisplayItemRenderer.getCornerPointsRelativeToCenter(minX, minY, minZ, maxX, maxY, maxZ);
    }

    private static double getMaxZ(Set<Vector3f> points) {
        float maxZ = Float.MIN_VALUE;
        for (Vector3f point : points) {
            if (!(point.m_122269_() > maxZ)) continue;
            maxZ = point.m_122269_();
        }
        return maxZ;
    }

    private static Set<Vector3f> translatePoints(Set<Vector3f> points, Vector3f translation) {
        return DisplayItemRenderer.transformPoints(points, point -> {
            point.m_122267_(translation);
            return point;
        });
    }

    private static Set<Vector3f> rotatePoints(Set<Vector3f> points, Vector3f rotation) {
        Quaternion rot = new Quaternion(rotation.m_122239_(), rotation.m_122260_(), rotation.m_122269_(), true);
        return DisplayItemRenderer.transformPoints(points, point -> {
            point.m_122251_(rot);
            return point;
        });
    }

    private static Set<Vector3f> scalePoints(Set<Vector3f> points, Vector3f scale) {
        return DisplayItemRenderer.transformPoints(points, point -> new Vector3f(point.m_122239_() * scale.m_122239_(), point.m_122260_() * scale.m_122260_(), point.m_122269_() * scale.m_122269_()));
    }

    private static Set<Vector3f> transformPoints(Set<Vector3f> points, UnaryOperator<Vector3f> transform) {
        HashSet<Vector3f> ret = new HashSet<Vector3f>();
        for (Vector3f point : points) {
            ret.add((Vector3f)transform.apply(point));
        }
        return ret;
    }

    private static Set<Vector3f> getCornerPointsRelativeToCenter(AABB aabb) {
        return DisplayItemRenderer.getCornerPointsRelativeToCenter((float)aabb.f_82288_, (float)aabb.f_82289_, (float)aabb.f_82290_, (float)aabb.f_82291_, (float)aabb.f_82292_, (float)aabb.f_82293_);
    }

    private static Set<Vector3f> getCornerPointsRelativeToCenter(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        HashSet<Vector3f> ret = new HashSet<Vector3f>();
        ret.add(new Vector3f(0.5f - minX, 0.5f - minY, 0.5f - minZ));
        ret.add(new Vector3f(0.5f - minX, 0.5f - minY, 0.5f - maxZ));
        ret.add(new Vector3f(0.5f - minX, 0.5f - maxY, 0.5f - minZ));
        ret.add(new Vector3f(0.5f - minX, 0.5f - maxY, 0.5f - maxZ));
        ret.add(new Vector3f(0.5f - maxX, 0.5f - minY, 0.5f - minZ));
        ret.add(new Vector3f(0.5f - maxX, 0.5f - minY, 0.5f - maxZ));
        ret.add(new Vector3f(0.5f - maxX, 0.5f - maxY, 0.5f - minZ));
        ret.add(new Vector3f(0.5f - maxX, 0.5f - maxY, 0.5f - maxZ));
        return ret;
    }

    public static Vector3f getDisplayItemIndexFrontOffset(int displayItemIndex, int displayItemCount, Direction dir) {
        return DisplayItemRenderer.getDisplayItemIndexFrontOffset(displayItemIndex, displayItemCount, 0.5f, dir);
    }

    public static Vector3f getDisplayItemIndexFrontOffset(int displayItemIndex, int displayItemCount, float centerYOffset, Direction dir) {
        Vector3f frontOffset;
        if (displayItemCount <= 0 || displayItemCount > 4) {
            frontOffset = new Vector3f(0.0f, 0.0f, 0.5f);
        } else if (displayItemCount == 1) {
            frontOffset = new Vector3f(0.5f, centerYOffset, 0.5f);
        } else if (displayItemCount == 2) {
            float halfCenterYOffset = centerYOffset / 2.0f;
            frontOffset = new Vector3f(0.5f, displayItemIndex == 0 ? centerYOffset + halfCenterYOffset : halfCenterYOffset, 0.5f);
        } else if (displayItemCount == 3) {
            float xOffset = 0.5f;
            if (displayItemIndex > 0) {
                xOffset = 0.75f - (float)(displayItemIndex - 1) * 0.5f;
            }
            float halfCenterYOffset = centerYOffset / 2.0f;
            frontOffset = new Vector3f(xOffset, displayItemIndex == 0 ? centerYOffset + halfCenterYOffset : halfCenterYOffset, 0.5f);
        } else {
            float halfCenterYOffset = centerYOffset / 2.0f;
            frontOffset = new Vector3f(displayItemIndex == 0 || displayItemIndex == 2 ? centerYOffset + halfCenterYOffset : halfCenterYOffset, displayItemIndex == 0 || displayItemIndex == 1 ? centerYOffset + halfCenterYOffset : halfCenterYOffset, 0.5f);
        }
        frontOffset.m_122272_(-0.5f, -0.5f, -0.5f);
        frontOffset.m_122251_(DisplayItemRenderer.getNorthBasedRotation(dir));
        frontOffset.m_122272_(0.5f, 0.5f, 0.5f);
        return frontOffset;
    }

    public static Quaternion getNorthBasedRotation(Direction dir) {
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> Vector3f.f_122223_.m_122240_(-90.0f);
            case Direction.UP -> Vector3f.f_122223_.m_122240_(90.0f);
            case Direction.NORTH -> Quaternion.f_80118_.m_80161_();
            case Direction.SOUTH -> Vector3f.f_122225_.m_122240_(180.0f);
            case Direction.WEST -> Vector3f.f_122225_.m_122240_(90.0f);
            case Direction.EAST -> Vector3f.f_122225_.m_122240_(-90.0f);
        };
    }
}

