/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.OptionalDouble;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.ControllerBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageToolItem;

public class ControllerRenderer
implements BlockEntityRenderer<ControllerBlockEntity> {
    public void render(ControllerBlockEntity controller, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        InventoryHelper.getItemFromEitherHand((Player)player, (Item)((Item)ModItems.DEBUG_TOOL.get())).ifPresent(storageTool -> this.renderConnectedStorageBlocksInfo(controller, Direction.m_122382_((Entity)player)[0].m_122424_(), poseStack, bufferSource));
        InventoryHelper.getItemFromEitherHand((Player)player, (Item)((Item)ModItems.STORAGE_TOOL.get())).ifPresent(storageTool -> {
            if (StorageToolItem.getControllerLink(storageTool).map(controllerPos -> controllerPos.equals((Object)controller.m_58899_())).orElse(false).booleanValue()) {
                this.renderBlockOutline(controller.m_58899_(), controller.m_58899_(), level, poseStack, bufferSource, DyeColor.LIGHT_BLUE.m_41068_());
            }
            this.renderLinkedBlocksOutline(controller, level, poseStack, bufferSource);
        });
    }

    private void renderConnectedStorageBlocksInfo(ControllerBlockEntity controller, Direction playerLookDirection, PoseStack poseStack, MultiBufferSource bufferSource) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        double zScale = 0.001;
        float scale = 0.015f;
        int storageOrder = 1;
        for (BlockPos position : controller.getStoragePositions()) {
            BlockPos controllerPos = controller.m_58899_();
            double translateX = (double)position.m_123341_() + 0.5 - (double)controllerPos.m_123341_() + 0.501 * (double)playerLookDirection.m_122436_().m_123341_();
            double translateY = (double)position.m_123342_() + 0.5 - (double)controllerPos.m_123342_() + 0.501 * (double)playerLookDirection.m_122436_().m_123342_();
            double translateZ = (double)position.m_123343_() + 0.5 - (double)controllerPos.m_123343_() + 0.501 * (double)playerLookDirection.m_122436_().m_123343_();
            poseStack.m_85836_();
            poseStack.m_85837_(translateX, translateY, translateZ);
            Quaternion rotation = playerLookDirection.m_122406_();
            rotation.m_80148_(Vector3f.f_122223_.m_122240_(-90.0f));
            poseStack.m_85845_(rotation);
            poseStack.m_85837_((double)-0.45f, (double)0.45f, 0.0);
            poseStack.m_85841_(scale, -scale, (float)zScale);
            fontRenderer.m_92811_("Order: " + storageOrder, 0.0f, 0.0f, DyeColor.WHITE.m_41071_(), false, poseStack.m_85850_().m_85861_(), bufferSource, true, 0, 0xF000F0);
            poseStack.m_85837_(0.0, 10.0, 0.0);
            fontRenderer.m_92811_("Slots: " + controller.getSlots(storageOrder - 1), 0.0f, 0.0f, DyeColor.WHITE.m_41071_(), false, poseStack.m_85850_().m_85861_(), bufferSource, true, 0, 0xF000F0);
            poseStack.m_85849_();
            ++storageOrder;
        }
    }

    private void renderLinkedBlocksOutline(ControllerBlockEntity controller, ClientLevel level, PoseStack poseStack, MultiBufferSource bufferSource) {
        controller.getLinkedBlocks().forEach(pos -> {
            BlockState state = level.m_8055_(pos);
            VoxelShape shape = state.m_60734_().m_5940_(state, (BlockGetter)level, pos, CollisionContext.m_82749_());
            this.renderLineBetweenBlocks(controller.m_58899_(), (BlockPos)pos, shape, poseStack, bufferSource, DyeColor.LIME.m_41068_());
            this.renderBlockOutline(controller.m_58899_(), (BlockPos)pos, shape, poseStack, bufferSource, DyeColor.LIME.m_41068_());
        });
    }

    private void renderLineBetweenBlocks(BlockPos initialPos, BlockPos pos, VoxelShape shape, PoseStack poseStack, MultiBufferSource bufferSource, float[] color) {
        if (shape.m_83281_()) {
            return;
        }
        float red = color[0];
        float green = color[1];
        float blue = color[2];
        Vec3 center = shape.m_83215_().m_82399_();
        VertexConsumer pBuffer = bufferSource.m_6299_(LineRenderType.LINES);
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        Matrix3f matrix3f = poseStack.m_85850_().m_85864_();
        float normalX = (float)((double)(pos.m_123341_() - initialPos.m_123341_()) + (0.5 - center.m_7096_()));
        float normalY = (float)((double)(pos.m_123342_() - initialPos.m_123342_()) + (0.5 - center.m_7098_()));
        float normalZ = (float)((double)(pos.m_123343_() - initialPos.m_123343_()) + (0.5 - center.m_7094_()));
        pBuffer.m_85982_(matrix4f, 0.5f, 0.5f, 0.5f).m_85950_(red, green, blue, 255.0f).m_85977_(matrix3f, normalX, normalY, normalZ).m_5752_();
        pBuffer.m_85982_(matrix4f, (float)((double)(pos.m_123341_() - initialPos.m_123341_()) + center.m_7096_()), (float)((double)(pos.m_123342_() - initialPos.m_123342_()) + center.m_7098_()), (float)((double)(pos.m_123343_() - initialPos.m_123343_()) + center.m_7094_())).m_85950_(red, green, blue, 255.0f).m_85977_(matrix3f, normalX, normalY, normalZ).m_5752_();
    }

    private void renderBlockOutline(BlockPos controllerPos, BlockPos pos, ClientLevel level, PoseStack poseStack, MultiBufferSource bufferSource, float[] color) {
        BlockState state = level.m_8055_(pos);
        VoxelShape shape = state.m_60734_().m_5940_(state, (BlockGetter)level, pos, CollisionContext.m_82749_());
        this.renderBlockOutline(controllerPos, pos, shape, poseStack, bufferSource, color);
    }

    private void renderBlockOutline(BlockPos controllerPos, BlockPos pos, VoxelShape shape, PoseStack poseStack, MultiBufferSource bufferSource, float[] color) {
        VertexConsumer vertexConsumer = bufferSource.m_6299_(LineRenderType.LINES);
        float red = color[0];
        float green = color[1];
        float blue = color[2];
        LevelRenderer.m_109782_((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (VoxelShape)shape, (double)(-controllerPos.m_123341_() + pos.m_123341_()), (double)(-controllerPos.m_123342_() + pos.m_123342_()), (double)(-controllerPos.m_123343_() + pos.m_123343_()), (float)red, (float)green, (float)blue, (float)1.0f);
    }

    public boolean shouldRenderOffScreen(ControllerBlockEntity pBlockEntity) {
        return true;
    }

    private static class LineRenderType
    extends RenderType {
        private static final RenderType LINES = RenderType.m_173209_((String)"storage_lines", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173095_).m_110663_(f_110111_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.empty())).m_110669_(f_110119_).m_110661_(RenderStateShard.f_110110_).m_110691_(false));

        public LineRenderType(String pName, VertexFormat pFormat, VertexFormat.Mode pMode, int pBufferSize, boolean pAffectsCrumbling, boolean pSortOnUpload, Runnable pSetupState, Runnable pClearState) {
            super(pName, pFormat, pMode, pBufferSize, pAffectsCrumbling, pSortOnUpload, pSetupState, pClearState);
        }
    }
}

