/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.QuadTransformer;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.common.model.TransformationHelper;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageTier;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.client.StorageTextureManager;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DisplayItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public class BarrelDynamicModel
implements IModelGeometry<BarrelDynamicModel> {
    private final Map<String, Map<ModelPart, UnbakedModel>> woodModels;
    private static final BarrelDynamicModel INSTANCE;
    private static final Map<String, Map<ModelPart, Map<String, Material>>> WOOD_TEXTURES;

    private static void addBarrelMaterial(WoodType woodType, Map<String, Material> textures, StorageTextureManager.BarrelMaterial barrelMaterial, StorageTextureManager.BarrelFace barrelFace) {
        StorageTextureManager.INSTANCE.getBarrelMaterial(woodType, barrelFace, barrelMaterial).ifPresent(mat -> textures.put(barrelFace.name().toLowerCase(Locale.ROOT), (Material)mat));
    }

    public static Collection<Map<ModelPart, Map<String, Material>>> getWoodTextures() {
        return WOOD_TEXTURES.values();
    }

    public BarrelDynamicModel(Map<String, Map<ModelPart, UnbakedModel>> woodModels) {
        this.woodModels = woodModels;
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.woodModels.forEach((woodName, partModels) -> {
            ImmutableMap.Builder partBuilder = ImmutableMap.builder();
            partModels.forEach((part, model) -> {
                BakedModel bakedModel = model.m_7611_(bakery, spriteGetter, modelTransform, modelLocation);
                if (bakedModel != null) {
                    partBuilder.put((Object)part, (Object)bakedModel);
                }
            });
            builder.put(woodName, (Object)partBuilder.build());
        });
        return new BarrelBakedModel((Map<String, Map<ModelPart, BakedModel>>)builder.build());
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.woodModels.forEach((woodName, partModels) -> partModels.forEach((part, model) -> builder.addAll((Iterable)model.m_5500_(modelGetter, missingTextureErrors))));
        return builder.build();
    }

    static {
        WOOD_TEXTURES = new HashMap<String, Map<ModelPart, Map<String, Material>>>();
        WoodStorageBlockBase.CUSTOM_TEXTURE_WOOD_TYPES.forEach(woodType -> {
            String woodName = woodType.m_61846_();
            ImmutableMap.Builder modelPartTexturesBuilder = ImmutableMap.builder();
            for (ModelPart modelPart : ModelPart.values()) {
                HashMap<String, Material> textures = new HashMap<String, Material>();
                for (StorageTextureManager.BarrelMaterial barrelMaterial : modelPart.barrelMaterials) {
                    BarrelDynamicModel.addBarrelMaterial(woodType, textures, barrelMaterial, StorageTextureManager.BarrelFace.TOP);
                    BarrelDynamicModel.addBarrelMaterial(woodType, textures, barrelMaterial, StorageTextureManager.BarrelFace.BOTTOM);
                    BarrelDynamicModel.addBarrelMaterial(woodType, textures, barrelMaterial, StorageTextureManager.BarrelFace.SIDE);
                    if (modelPart != ModelPart.MAIN && modelPart != ModelPart.MAIN_OPEN) continue;
                    StorageTextureManager.INSTANCE.getBarrelMaterial((WoodType)woodType, StorageTextureManager.BarrelFace.TOP, StorageTextureManager.BarrelMaterial.HANDLE).ifPresent(mat -> textures.put("handle", (Material)mat));
                }
                modelPartTexturesBuilder.put((Object)modelPart, textures);
            }
            WOOD_TEXTURES.put(woodName, (Map<ModelPart, Map<String, Material>>)modelPartTexturesBuilder.build());
        });
        ImmutableMap.Builder woodModelsBuilder = ImmutableMap.builder();
        WOOD_TEXTURES.forEach((woodName, modelPartMaterials) -> {
            ImmutableMap.Builder modelsBuilder = ImmutableMap.builder();
            modelPartMaterials.forEach((modelPart, materials) -> {
                ImmutableMap.Builder texturesBuilder = ImmutableMap.builder();
                materials.forEach((textureName, material) -> texturesBuilder.put(textureName, (Object)Either.left((Object)material)));
                modelsBuilder.put((Object)modelPart, (Object)new BlockModel(modelPart.modelName, Collections.emptyList(), (Map)texturesBuilder.build(), true, null, ItemTransforms.f_111786_, Collections.emptyList()));
            });
            woodModelsBuilder.put(woodName, (Object)modelsBuilder.build());
        });
        INSTANCE = new BarrelDynamicModel((Map<String, Map<ModelPart, UnbakedModel>>)woodModelsBuilder.build());
    }

    private static class BarrelBakedModel
    implements IDynamicBakedModel {
        private static final QuadTransformer MOVE_TO_CORNER = new QuadTransformer(new Transformation(new Vector3f(-0.5f, -0.5f, -0.5f), null, null, null));
        private static final Map<Direction, QuadTransformer> DIRECTION_ROTATES = Map.of(Direction.UP, BarrelBakedModel.getDirectionRotationTransform(Direction.UP), Direction.DOWN, BarrelBakedModel.getDirectionRotationTransform(Direction.DOWN), Direction.NORTH, BarrelBakedModel.getDirectionRotationTransform(Direction.NORTH), Direction.SOUTH, BarrelBakedModel.getDirectionRotationTransform(Direction.SOUTH), Direction.WEST, BarrelBakedModel.getDirectionRotationTransform(Direction.WEST), Direction.EAST, BarrelBakedModel.getDirectionRotationTransform(Direction.EAST));
        private static final LoadingCache<Direction, Cache<Integer, QuadTransformer>> DIRECTION_MOVES_3D_ITEMS = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Direction, Cache<Integer, QuadTransformer>>(){

            public Cache<Integer, QuadTransformer> load(Direction key) {
                return CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
            }
        });
        private static final QuadTransformer SCALE_BIG_2D_ITEM = new QuadTransformer(new Transformation(null, null, new Vector3f(0.65f, 0.65f, 0.65f), null));
        private static final QuadTransformer SCALE_SMALL_3D_ITEM = new QuadTransformer(new Transformation(null, null, new Vector3f(0.65f, 0.65f, 0.65f), null));
        private static final QuadTransformer SCALE_SMALL_2D_ITEM = new QuadTransformer(new Transformation(null, null, new Vector3f(0.35f, 0.35f, 0.35f), null));
        private StorageTier barrelStorageTier;
        private static final Cache<Integer, QuadTransformer> DIRECTION_MOVE_BACK_TO_SIDE = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
        private static final ModelProperty<String> WOOD_NAME = new ModelProperty();
        private static final ModelProperty<Boolean> IS_PACKED = new ModelProperty();
        private static final ModelProperty<Boolean> HAS_MAIN_COLOR = new ModelProperty();
        private static final ModelProperty<Boolean> HAS_ACCENT_COLOR = new ModelProperty();
        private static final ModelProperty<List<RenderInfo.DisplayItem>> DISPLAY_ITEMS = new ModelProperty();
        private static final Map<ItemTransforms.TransformType, Transformation> TRANSFORMS;
        private static final ItemTransforms ITEM_TRANSFORMS;
        private final Map<String, Map<ModelPart, BakedModel>> woodModelParts;
        private final ItemOverrides barrelItemOverrides = new BarrelItemOverrides(this);
        private Item barrelItem = Items.f_41852_;
        @Nullable
        private String barrelWoodName = null;
        private boolean barrelHasMainColor = false;
        private boolean barrelHasAccentColor = false;
        private boolean barrelIsPacked = false;
        private static final Cache<Integer, List<BakedQuad>> BAKED_QUADS_CACHE;
        private static final Map<Integer, QuadTransformer> DISPLAY_ROTATIONS;

        private static QuadTransformer getDirectionRotationTransform(Direction dir) {
            return new QuadTransformer(new Transformation(null, DisplayItemRenderer.getNorthBasedRotation(dir), null, null));
        }

        private static QuadTransformer getDirectionMoveBackToSide(Direction dir, float distFromCenter, int displayItemIndex, int displayItemCount) {
            int hash = BarrelBakedModel.calculateMoveBackToSideHash(dir, distFromCenter, displayItemIndex, displayItemCount);
            QuadTransformer transform = (QuadTransformer)DIRECTION_MOVE_BACK_TO_SIDE.getIfPresent((Object)hash);
            if (transform == null) {
                Vec3i normal = dir.m_122436_();
                Vector3f offset = new Vector3f(distFromCenter, distFromCenter, distFromCenter);
                offset.m_122263_((float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_());
                Vector3f frontOffset = DisplayItemRenderer.getDisplayItemIndexFrontOffset(displayItemIndex, displayItemCount, dir);
                offset.m_122253_(frontOffset);
                transform = new QuadTransformer(new Transformation(offset, null, null, null));
                DIRECTION_MOVE_BACK_TO_SIDE.put((Object)hash, (Object)transform);
            }
            return transform;
        }

        private static int calculateMoveBackToSideHash(Direction dir, float distFromCenter, int displayItemIndex, int displayItemCount) {
            int hash = dir.hashCode();
            hash = 31 * hash + Float.hashCode(distFromCenter);
            hash = 31 * hash + displayItemIndex;
            hash = 31 * hash + displayItemCount;
            return hash;
        }

        public BarrelBakedModel(Map<String, Map<ModelPart, BakedModel>> woodModelParts) {
            this.woodModelParts = woodModelParts;
        }

        private static ItemTransforms createItemTransforms() {
            return new ItemTransforms(BarrelBakedModel.fromTransformation(TRANSFORMS.get(ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND)), BarrelBakedModel.fromTransformation(TRANSFORMS.get(ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND)), BarrelBakedModel.fromTransformation(TRANSFORMS.get(ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND)), BarrelBakedModel.fromTransformation(TRANSFORMS.get(ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND)), BarrelBakedModel.fromTransformation(TRANSFORMS.get(ItemTransforms.TransformType.HEAD)), BarrelBakedModel.fromTransformation(TRANSFORMS.get(ItemTransforms.TransformType.GUI)), BarrelBakedModel.fromTransformation(TRANSFORMS.get(ItemTransforms.TransformType.GROUND)), BarrelBakedModel.fromTransformation(TRANSFORMS.get(ItemTransforms.TransformType.FIXED)));
        }

        private static ItemTransform fromTransformation(Transformation transformation) {
            return new ItemTransform(transformation.m_121105_().m_175217_(), transformation.m_175940_(), transformation.m_175941_());
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData extraData) {
            StorageTier storageTier;
            boolean isPacked;
            boolean hasAccentColor;
            boolean hasMainColor;
            int hash = this.createHash(state, side, extraData);
            List quads = (List)BAKED_QUADS_CACHE.getIfPresent((Object)hash);
            if (quads != null) {
                return quads;
            }
            String woodName = null;
            if (state != null) {
                hasMainColor = Boolean.TRUE.equals(extraData.getData(HAS_MAIN_COLOR));
                hasAccentColor = Boolean.TRUE.equals(extraData.getData(HAS_ACCENT_COLOR));
                if (extraData.hasProperty(WOOD_NAME)) {
                    woodName = (String)extraData.getData(WOOD_NAME);
                }
                isPacked = this.isPacked(extraData);
                storageTier = this.getStorageTier(state);
            } else {
                woodName = this.barrelWoodName;
                hasMainColor = this.barrelHasMainColor;
                hasAccentColor = this.barrelHasAccentColor;
                isPacked = this.barrelIsPacked;
                storageTier = this.barrelStorageTier;
            }
            ArrayList<BakedQuad> ret = new ArrayList<BakedQuad>();
            Map<ModelPart, BakedModel> modelParts = this.getWoodModelParts(woodName);
            if (modelParts.isEmpty()) {
                return Collections.emptyList();
            }
            if (!hasMainColor || !hasAccentColor) {
                this.addPartQuads(state, side, rand, ret, modelParts, state != null && Boolean.TRUE.equals(state.m_61143_((Property)BarrelBlock.OPEN)) ? ModelPart.BASE_OPEN : ModelPart.BASE);
            }
            this.addTintableModelQuads(state, side, rand, ret, hasMainColor, hasAccentColor, modelParts);
            this.addTierQuads(state, side, rand, storageTier, ret, modelParts);
            if (isPacked) {
                this.addPartQuads(state, side, rand, ret, modelParts, ModelPart.PACKED);
            } else {
                this.addDisplayItemQuads(state, side, rand, ret, extraData);
            }
            BAKED_QUADS_CACHE.put((Object)hash, ret);
            return ret;
        }

        private boolean isPacked(IModelData extraData) {
            return extraData.hasProperty(IS_PACKED) && Boolean.TRUE.equals(extraData.getData(IS_PACKED));
        }

        @Nonnull
        private StorageTier getStorageTier(@Nonnull BlockState state) {
            StorageTier storageTier;
            Block block = state.m_60734_();
            if (block instanceof BarrelBlock) {
                BarrelBlock barrelBlock = (BarrelBlock)block;
                storageTier = barrelBlock.getStorageTier();
            } else {
                storageTier = StorageTier.WOOD;
            }
            return storageTier;
        }

        private void addTierQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, StorageTier storageTier, List<BakedQuad> ret, Map<ModelPart, BakedModel> modelParts) {
            ModelPart tierModelPart = switch (storageTier) {
                default -> throw new IncompatibleClassChangeError();
                case StorageTier.WOOD -> ModelPart.WOOD_TIER;
                case StorageTier.IRON -> ModelPart.IRON_TIER;
                case StorageTier.GOLD -> ModelPart.GOLD_TIER;
                case StorageTier.DIAMOND -> ModelPart.DIAMOND_TIER;
                case StorageTier.NETHERITE -> ModelPart.NETHERITE_TIER;
            };
            this.addPartQuads(state, side, rand, ret, modelParts, tierModelPart);
        }

        private int createHash(@Nullable BlockState state, @Nullable Direction side, IModelData data) {
            int hash = state != null ? this.getInWorldBlockHash(state, data) : this.getItemBlockHash();
            hash = hash * 31 + (side == null ? 0 : side.m_122411_() + 1);
            hash = this.getDisplayItemsHash(data, hash);
            return hash;
        }

        private int getItemBlockHash() {
            int hash = this.barrelItem.hashCode();
            hash = hash * 31 + (this.barrelWoodName != null ? this.barrelWoodName.hashCode() + 1 : 0);
            hash = hash * 31 + (this.barrelHasMainColor ? 1 : 0);
            hash = hash * 31 + (this.barrelHasAccentColor ? 1 : 0);
            hash = hash * 31 + (this.barrelIsPacked ? 1 : 0);
            return hash;
        }

        private int getInWorldBlockHash(BlockState state, IModelData data) {
            int hash = state.m_60734_().hashCode();
            hash = hash * 31 + ((Direction)state.m_61143_((Property)BarrelBlock.FACING)).m_122411_();
            hash = hash * 31 + (Boolean.TRUE.equals(state.m_61143_((Property)BarrelBlock.OPEN)) ? 1 : 0);
            hash = hash * 31 + (data.hasProperty(WOOD_NAME) ? ((String)data.getData(WOOD_NAME)).hashCode() + 1 : 0);
            hash = hash * 31 + (data.hasProperty(HAS_MAIN_COLOR) && Boolean.TRUE.equals(data.getData(HAS_MAIN_COLOR)) ? 1 : 0);
            hash = hash * 31 + (data.hasProperty(HAS_ACCENT_COLOR) && Boolean.TRUE.equals(data.getData(HAS_ACCENT_COLOR)) ? 1 : 0);
            hash = hash * 31 + (this.isPacked(data) ? 1 : 0);
            return hash;
        }

        private int getDisplayItemsHash(IModelData data, int hash) {
            if (data.hasProperty(DISPLAY_ITEMS)) {
                List displayItems = (List)data.getData(DISPLAY_ITEMS);
                for (RenderInfo.DisplayItem displayItem : displayItems) {
                    hash = hash * 31 + this.getDisplayItemHash(displayItem);
                }
            }
            return hash;
        }

        private int getDisplayItemHash(RenderInfo.DisplayItem displayItem) {
            int hash = displayItem.getRotation();
            hash = hash * 31 + ItemStackKey.getHashCode((ItemStack)displayItem.getItem());
            return hash;
        }

        private void addDisplayItemQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, List<BakedQuad> ret, IModelData data) {
            if (state == null || side != null) {
                return;
            }
            List displayItems = (List)data.getData(DISPLAY_ITEMS);
            if (displayItems != null && !displayItems.isEmpty()) {
                Minecraft minecraft = Minecraft.m_91087_();
                ItemRenderer itemRenderer = minecraft.m_91291_();
                int index = 0;
                for (RenderInfo.DisplayItem displayItem : displayItems) {
                    ItemStack item = displayItem.getItem();
                    BakedModel model = itemRenderer.m_174264_(item, null, (LivingEntity)minecraft.f_91074_, 0);
                    if (!model.m_7521_()) {
                        int rotation = displayItem.getRotation();
                        for (Direction face : Direction.values()) {
                            this.addRenderedItemSide(state, rand, ret, item, model, rotation, face, index, displayItems.size());
                        }
                        this.addRenderedItemSide(state, rand, ret, item, model, rotation, null, index, displayItems.size());
                    }
                    ++index;
                }
            }
        }

        private void addRenderedItemSide(BlockState state, Random rand, List<BakedQuad> ret, ItemStack displayItem, BakedModel model, int rotation, @Nullable Direction dir, int displayItemIndex, int displayItemCount) {
            List quads = model.m_6840_(null, dir, rand);
            quads = MOVE_TO_CORNER.processMany(quads);
            quads = new QuadTransformer(TransformationHelper.toTransformation((ItemTransform)model.m_7442_().m_111808_(ItemTransforms.TransformType.FIXED))).processMany(quads);
            if (!model.m_7539_()) {
                quads = displayItemCount == 1 ? SCALE_BIG_2D_ITEM.processMany(quads) : SCALE_SMALL_2D_ITEM.processMany(quads);
            } else if (displayItemCount > 1) {
                quads = SCALE_SMALL_3D_ITEM.processMany(quads);
            }
            if (rotation != 0) {
                quads = this.getDisplayRotation(rotation).processMany(quads);
            }
            Direction facing = (Direction)state.m_61143_((Property)BarrelBlock.FACING);
            quads = DIRECTION_ROTATES.get(facing).processMany(quads);
            if (model.m_7539_()) {
                QuadTransformer transformer = this.getDirectionMove(displayItem, model, facing, displayItemIndex, displayItemCount, displayItemCount == 1 ? 1.0f : 0.65f);
                quads = transformer.processMany(quads);
                this.recalculateDirections(quads);
            } else {
                quads = this.getDirectionMove(displayItem, model, facing, displayItemIndex, displayItemCount, 1.0f).processMany(quads);
            }
            this.updateTintIndexes(quads, displayItemIndex);
            ret.addAll(quads);
        }

        private void updateTintIndexes(List<BakedQuad> quads, int displayItemIndex) {
            int offset = (displayItemIndex + 1) * 10;
            quads.forEach(quad -> {
                if (quad.f_111293_ >= 0) {
                    quad.f_111293_ += offset;
                }
            });
        }

        private void recalculateDirections(List<BakedQuad> quads) {
            quads.forEach(quad -> {
                quad.f_111294_ = FaceBakery.m_111612_((int[])quad.m_111303_());
            });
        }

        private QuadTransformer getDirectionMove(ItemStack displayItem, BakedModel model, Direction direction, int displayItemIndex, int displayItemCount, float itemScale) {
            int hash = this.calculateDirectionMoveHash(displayItem, displayItemIndex, displayItemCount);
            Cache directionCache = (Cache)DIRECTION_MOVES_3D_ITEMS.getUnchecked((Object)direction);
            QuadTransformer transformer = (QuadTransformer)directionCache.getIfPresent((Object)hash);
            if (transformer == null) {
                double offset = 0.0;
                if (model.m_7539_()) {
                    offset = DisplayItemRenderer.getDisplayItemOffset(displayItem, model, itemScale);
                }
                transformer = BarrelBakedModel.getDirectionMoveBackToSide(direction, (float)(0.5 + offset), displayItemIndex, displayItemCount);
                directionCache.put((Object)hash, (Object)transformer);
            }
            return transformer;
        }

        private int calculateDirectionMoveHash(ItemStack displayItem, int displayItemIndex, int displayItemCount) {
            int hashCode = ItemStackKey.getHashCode((ItemStack)displayItem);
            hashCode = hashCode * 31 + displayItemIndex;
            hashCode = hashCode * 31 + displayItemCount;
            return hashCode;
        }

        private QuadTransformer getDisplayRotation(int rotation) {
            return DISPLAY_ROTATIONS.computeIfAbsent(rotation, r -> new QuadTransformer(new Transformation(null, Vector3f.f_122227_.m_122240_((float)rotation), null, null)));
        }

        private void addTintableModelQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, List<BakedQuad> ret, boolean hasMainColor, boolean hasAccentColor, Map<ModelPart, BakedModel> modelParts) {
            if (hasMainColor) {
                this.addPartQuads(state, side, rand, ret, modelParts, state != null && (Boolean)state.m_61143_((Property)BarrelBlock.OPEN) != false ? ModelPart.MAIN_OPEN : ModelPart.MAIN);
            }
            if (hasAccentColor) {
                this.addPartQuads(state, side, rand, ret, modelParts, ModelPart.ACCENT);
            }
            if (hasMainColor || hasAccentColor) {
                this.addPartQuads(state, side, rand, ret, modelParts, ModelPart.METAL_BANDS);
            }
        }

        private void addPartQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, List<BakedQuad> ret, Map<ModelPart, BakedModel> modelParts, ModelPart part) {
            if (modelParts.containsKey((Object)part)) {
                ret.addAll(modelParts.get((Object)part).getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE));
            }
        }

        private Map<ModelPart, BakedModel> getWoodModelParts(@Nullable String barrelWoodName) {
            if (this.woodModelParts.containsKey(barrelWoodName)) {
                return this.woodModelParts.get(barrelWoodName);
            }
            return this.woodModelParts.values().iterator().next();
        }

        public boolean m_7541_() {
            return false;
        }

        public boolean m_7539_() {
            return true;
        }

        public boolean m_7547_() {
            return true;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return this.getWoodModelParts(null).get((Object)ModelPart.BASE).m_6160_();
        }

        public ItemTransforms m_7442_() {
            return ITEM_TRANSFORMS;
        }

        public TextureAtlasSprite getParticleIcon(IModelData data) {
            if (data.hasProperty(HAS_MAIN_COLOR) && Boolean.TRUE.equals(data.getData(HAS_MAIN_COLOR))) {
                return this.getWoodModelParts(null).get((Object)ModelPart.MAIN).getParticleIcon(data);
            }
            if (data.hasProperty(WOOD_NAME)) {
                String name = (String)data.getData(WOOD_NAME);
                if (!this.woodModelParts.containsKey(name)) {
                    return this.m_6160_();
                }
                return this.getWoodModelParts(name).get((Object)ModelPart.BASE).getParticleIcon(data);
            }
            return this.m_6160_();
        }

        @Nonnull
        public IModelData getModelData(BlockAndTintGetter world, BlockPos pos, BlockState state, IModelData tileData) {
            return WorldHelper.getBlockEntity((BlockGetter)world, (BlockPos)pos, BarrelBlockEntity.class).map(be -> {
                List displayItems;
                ModelDataMap.Builder builder = new ModelDataMap.Builder();
                boolean hasMainColor = be.getStorageWrapper().hasMainColor();
                builder.withInitial(HAS_MAIN_COLOR, (Object)hasMainColor);
                boolean hasAccentColor = be.getStorageWrapper().hasAccentColor();
                builder.withInitial(HAS_ACCENT_COLOR, (Object)hasAccentColor);
                if (!be.hasFullyDynamicRenderer() && !(displayItems = be.getStorageWrapper().getRenderInfo().getItemDisplayRenderInfo().getDisplayItems()).isEmpty()) {
                    builder.withInitial(DISPLAY_ITEMS, (Object)displayItems);
                }
                builder.withInitial(IS_PACKED, (Object)be.isPacked());
                Optional<WoodType> woodType = be.getWoodType();
                if (woodType.isPresent() || !hasMainColor || !hasAccentColor) {
                    builder.withInitial(WOOD_NAME, (Object)woodType.orElse(WoodType.f_61833_).m_61846_());
                }
                return builder.build();
            }).orElse((IModelData)EmptyModelData.INSTANCE);
        }

        public ItemOverrides m_7343_() {
            return this.barrelItemOverrides;
        }

        public BakedModel handlePerspective(ItemTransforms.TransformType cameraTransformType, PoseStack matrixStack) {
            if (cameraTransformType == ItemTransforms.TransformType.NONE) {
                return this;
            }
            Transformation tr = TRANSFORMS.get(cameraTransformType);
            if (!tr.isIdentity()) {
                tr.push(matrixStack);
            }
            return this;
        }

        static {
            BAKED_QUADS_CACHE = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.MINUTES).build();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)new Transformation(new Vector3f(0.0f, 0.15625f, 0.0f), new Quaternion(75.0f, 45.0f, 0.0f, true), new Vector3f(0.375f, 0.375f, 0.375f), null));
            builder.put((Object)ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)new Transformation(new Vector3f(0.0f, 0.15625f, 0.0f), new Quaternion(75.0f, 45.0f, 0.0f, true), new Vector3f(0.375f, 0.375f, 0.375f), null));
            builder.put((Object)ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)new Transformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quaternion(0.0f, 225.0f, 0.0f, true), new Vector3f(0.4f, 0.4f, 0.4f), null));
            builder.put((Object)ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)new Transformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quaternion(0.0f, 45.0f, 0.0f, true), new Vector3f(0.4f, 0.4f, 0.4f), null));
            builder.put((Object)ItemTransforms.TransformType.HEAD, (Object)new Transformation(new Vector3f(0.0f, 0.890625f, 0.0f), new Quaternion(0.0f, 0.0f, 0.0f, true), new Vector3f(1.0f, 1.0f, 1.0f), null));
            builder.put((Object)ItemTransforms.TransformType.GUI, (Object)new Transformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quaternion(30.0f, 225.0f, 0.0f, true), new Vector3f(0.625f, 0.625f, 0.625f), null));
            builder.put((Object)ItemTransforms.TransformType.GROUND, (Object)new Transformation(new Vector3f(0.0f, 0.1875f, 0.0f), new Quaternion(0.0f, 0.0f, 0.0f, true), new Vector3f(0.25f, 0.25f, 0.25f), null));
            builder.put((Object)ItemTransforms.TransformType.FIXED, (Object)new Transformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quaternion(0.0f, 0.0f, 0.0f, true), new Vector3f(0.5f, 0.5f, 0.5f), null));
            TRANSFORMS = builder.build();
            ITEM_TRANSFORMS = BarrelBakedModel.createItemTransforms();
            DISPLAY_ROTATIONS = new HashMap<Integer, QuadTransformer>();
        }
    }

    public static enum ModelPart {
        BASE(Constants.CUBE_BOTTOM_TOP, StorageTextureManager.BarrelMaterial.BASE),
        BASE_OPEN(Constants.CUBE_BOTTOM_TOP, StorageTextureManager.BarrelMaterial.BASE, StorageTextureManager.BarrelMaterial.BASE_OPEN),
        METAL_BANDS(SophisticatedStorage.getRL("block/barrel_metal_bands"), StorageTextureManager.BarrelMaterial.METAL_BANDS),
        ACCENT(SophisticatedStorage.getRL("block/barrel_tintable_accent"), StorageTextureManager.BarrelMaterial.TINTABLE_ACCENT),
        MAIN(SophisticatedStorage.getRL("block/barrel_tintable_main"), StorageTextureManager.BarrelMaterial.TINTABLE_MAIN),
        MAIN_OPEN(SophisticatedStorage.getRL("block/barrel_tintable_main_open"), StorageTextureManager.BarrelMaterial.TINTABLE_MAIN, StorageTextureManager.BarrelMaterial.TINTABLE_MAIN_OPEN),
        WOOD_TIER(Constants.CUBE_BOTTOM_TOP, StorageTextureManager.BarrelMaterial.WOOD_TIER),
        IRON_TIER(Constants.CUBE_BOTTOM_TOP, StorageTextureManager.BarrelMaterial.IRON_TIER),
        GOLD_TIER(Constants.CUBE_BOTTOM_TOP, StorageTextureManager.BarrelMaterial.GOLD_TIER),
        DIAMOND_TIER(Constants.CUBE_BOTTOM_TOP, StorageTextureManager.BarrelMaterial.DIAMOND_TIER),
        NETHERITE_TIER(Constants.CUBE_BOTTOM_TOP, StorageTextureManager.BarrelMaterial.NETHERITE_TIER),
        PACKED(Constants.CUBE_BOTTOM_TOP, StorageTextureManager.BarrelMaterial.PACKED);

        public final ResourceLocation modelName;
        private final StorageTextureManager.BarrelMaterial[] barrelMaterials;

        private ModelPart(ResourceLocation modelName, StorageTextureManager.BarrelMaterial ... barrelMaterials) {
            this.modelName = modelName;
            this.barrelMaterials = barrelMaterials;
        }

        private static class Constants {
            private static final ResourceLocation CUBE_BOTTOM_TOP = new ResourceLocation("minecraft:block/cube_bottom_top");

            private Constants() {
            }
        }
    }

    public static final class Loader
    implements IModelLoader<BarrelDynamicModel> {
        public static final Loader INSTANCE = new Loader();

        public BarrelDynamicModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            return INSTANCE;
        }

        public void m_6213_(ResourceManager resourceManager) {
        }
    }

    private static class BarrelItemOverrides
    extends ItemOverrides {
        private final BarrelBakedModel barrelBakedModel;

        public BarrelItemOverrides(BarrelBakedModel barrelBakedModel) {
            this.barrelBakedModel = barrelBakedModel;
        }

        @Nullable
        public BakedModel m_173464_(BakedModel model, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
            StorageTier storageTier;
            BlockItem blockItem;
            this.barrelBakedModel.barrelHasMainColor = StorageBlockItem.getMainColorFromStack(stack).isPresent();
            this.barrelBakedModel.barrelHasAccentColor = StorageBlockItem.getAccentColorFromStack(stack).isPresent();
            this.barrelBakedModel.barrelWoodName = WoodStorageBlockItem.getWoodType(stack).map(WoodType::m_61846_).orElse((String)(this.barrelBakedModel.barrelHasAccentColor && this.barrelBakedModel.barrelHasMainColor ? null : WoodType.f_61833_.m_61846_()));
            this.barrelBakedModel.barrelIsPacked = WoodStorageBlockItem.isPacked(stack);
            Item item = stack.m_41720_();
            if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).m_40614_()) instanceof BarrelBlock) {
                BarrelBlock barrelBlock = (BarrelBlock)item;
                storageTier = barrelBlock.getStorageTier();
            } else {
                storageTier = StorageTier.WOOD;
            }
            this.barrelBakedModel.barrelStorageTier = storageTier;
            this.barrelBakedModel.barrelItem = stack.m_41720_();
            return this.barrelBakedModel;
        }
    }
}

