/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.init;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class ModBlockColors {
    private ModBlockColors() {
    }

    public static void init() {
        Minecraft minecraft = Minecraft.m_91087_();
        BlockColors blockColors = minecraft.m_91298_();
        blockColors.m_92589_(ModBlockColors::getBarrelTintColor, new Block[]{(Block)ModBlocks.BARREL.get(), (Block)ModBlocks.IRON_BARREL.get(), (Block)ModBlocks.GOLD_BARREL.get(), (Block)ModBlocks.DIAMOND_BARREL.get(), (Block)ModBlocks.NETHERITE_BARREL.get()});
        blockColors.m_92589_(ModBlockColors::getChestShulkerBoxColor, new Block[]{(Block)ModBlocks.CHEST.get(), (Block)ModBlocks.IRON_CHEST.get(), (Block)ModBlocks.GOLD_CHEST.get(), (Block)ModBlocks.DIAMOND_CHEST.get(), (Block)ModBlocks.NETHERITE_CHEST.get(), (Block)ModBlocks.SHULKER_BOX.get(), (Block)ModBlocks.IRON_SHULKER_BOX.get(), (Block)ModBlocks.GOLD_SHULKER_BOX.get(), (Block)ModBlocks.DIAMOND_SHULKER_BOX.get(), (Block)ModBlocks.NETHERITE_SHULKER_BOX.get()});
    }

    private static int getBarrelTintColor(BlockState state, @Nullable BlockAndTintGetter blockDisplayReader, @Nullable BlockPos pos, int tintIndex) {
        if (tintIndex < 0 || pos == null) {
            return -1;
        }
        return WorldHelper.getBlockEntity((BlockGetter)blockDisplayReader, (BlockPos)pos, StorageBlockEntity.class).map(be -> {
            if (tintIndex == 1000) {
                return be.getStorageWrapper().getMainColor();
            }
            if (tintIndex == 1001) {
                return be.getStorageWrapper().getAccentColor();
            }
            if (tintIndex >= 0) {
                RenderInfo.ItemDisplayRenderInfo itemDisplayRenderInfo = be.getStorageWrapper().getRenderInfo().getItemDisplayRenderInfo();
                int displayItemIndex = (tintIndex > 1000 ? tintIndex - 1000 : tintIndex) / 10 - 1;
                List displayItems = itemDisplayRenderInfo.getDisplayItems();
                if (displayItemIndex >= 0 && displayItems.size() > displayItemIndex) {
                    int tintOffset = (displayItemIndex + 1) * 10;
                    return Minecraft.m_91087_().getItemColors().m_92676_(((RenderInfo.DisplayItem)displayItems.get(displayItemIndex)).getItem(), tintIndex - tintOffset);
                }
            }
            return -1;
        }).orElse(-1);
    }

    private static int getChestShulkerBoxColor(BlockState state, @Nullable BlockAndTintGetter blockDisplayReader, @Nullable BlockPos pos, int tintIndex) {
        if (tintIndex < 0 || pos == null) {
            return -1;
        }
        return WorldHelper.getBlockEntity((BlockGetter)blockDisplayReader, (BlockPos)pos, StorageBlockEntity.class).map(be -> {
            if (tintIndex == 0) {
                return be.getStorageWrapper().getMainColor();
            }
            return -1;
        }).orElse(-1);
    }
}

