/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.Random;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.IBlockRenderProperties;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.client.particle.CustomTintTerrainParticle;

class BarrelBlockRenderProperties
implements IBlockRenderProperties {
    private final BarrelBlock barrelBlock;
    private final Random random = new Random();

    public BarrelBlockRenderProperties(BarrelBlock barrelBlock) {
        this.barrelBlock = barrelBlock;
    }

    public boolean addHitEffects(BlockState state, Level level, HitResult target, ParticleEngine manager) {
        ClientLevel clientLevel;
        block11: {
            block10: {
                if (state.m_60734_() != this.barrelBlock || !(level instanceof ClientLevel)) break block10;
                clientLevel = (ClientLevel)level;
                if (target instanceof BlockHitResult) break block11;
            }
            return false;
        }
        BlockHitResult blockHitResult = (BlockHitResult)target;
        Direction sideHit = blockHitResult.m_82434_();
        BlockPos pos = blockHitResult.m_82425_();
        if (state.m_60799_() != RenderShape.INVISIBLE) {
            int i = pos.m_123341_();
            int j = pos.m_123342_();
            int k = pos.m_123343_();
            AABB aabb = state.m_60808_((BlockGetter)level, pos).m_83215_();
            double d0 = (double)i + this.random.nextDouble() * (aabb.f_82291_ - aabb.f_82288_ - (double)0.2f) + (double)0.1f + aabb.f_82288_;
            double d1 = (double)j + this.random.nextDouble() * (aabb.f_82292_ - aabb.f_82289_ - (double)0.2f) + (double)0.1f + aabb.f_82289_;
            double d2 = (double)k + this.random.nextDouble() * (aabb.f_82293_ - aabb.f_82290_ - (double)0.2f) + (double)0.1f + aabb.f_82290_;
            if (sideHit == Direction.DOWN) {
                d1 = (double)j + aabb.f_82289_ - (double)0.1f;
            }
            if (sideHit == Direction.UP) {
                d1 = (double)j + aabb.f_82292_ + (double)0.1f;
            }
            if (sideHit == Direction.NORTH) {
                d2 = (double)k + aabb.f_82290_ - (double)0.1f;
            }
            if (sideHit == Direction.SOUTH) {
                d2 = (double)k + aabb.f_82293_ + (double)0.1f;
            }
            if (sideHit == Direction.WEST) {
                d0 = (double)i + aabb.f_82288_ - (double)0.1f;
            }
            if (sideHit == Direction.EAST) {
                d0 = (double)i + aabb.f_82291_ + (double)0.1f;
            }
            manager.m_107344_(new CustomTintTerrainParticle(clientLevel, d0, d1, d2, 0.0, 0.0, 0.0, state, pos).updateSprite(state, pos).m_107268_(0.2f).m_6569_(0.6f));
        }
        return true;
    }

    public boolean addDestroyEffects(BlockState state, Level level, BlockPos pos, ParticleEngine manager) {
        if (state.m_60734_() != this.barrelBlock || !(level instanceof ClientLevel)) {
            return false;
        }
        ClientLevel clientLevel = (ClientLevel)level;
        VoxelShape voxelshape = state.m_60808_((BlockGetter)level, pos);
        voxelshape.m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
            double d1 = Math.min(1.0, maxX - minX);
            double d2 = Math.min(1.0, maxY - minY);
            double d3 = Math.min(1.0, maxZ - minZ);
            int i = Math.max(2, Mth.m_14165_((double)(d1 / 0.25)));
            int j = Math.max(2, Mth.m_14165_((double)(d2 / 0.25)));
            int k = Math.max(2, Mth.m_14165_((double)(d3 / 0.25)));
            for (int l = 0; l < i; ++l) {
                for (int i1 = 0; i1 < j; ++i1) {
                    for (int j1 = 0; j1 < k; ++j1) {
                        double d4 = ((double)l + 0.5) / (double)i;
                        double d5 = ((double)i1 + 0.5) / (double)j;
                        double d6 = ((double)j1 + 0.5) / (double)k;
                        double d7 = d4 * d1 + minX;
                        double d8 = d5 * d2 + minY;
                        double d9 = d6 * d3 + minZ;
                        manager.m_107344_(new CustomTintTerrainParticle(clientLevel, (double)pos.m_123341_() + d7, (double)pos.m_123342_() + d8, (double)pos.m_123343_() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5, state, pos).updateSprite(state, pos));
                    }
                }
            }
        });
        return true;
    }
}

