/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.permutated.pylons.util.Location;
import net.permutated.pylons.util.Range;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="pylons")
public class SpawnManager {
    private static boolean dirty = false;
    private static Map<Location, Set<String>> chunkMap = new ConcurrentHashMap<Location, Set<String>>();
    private static final Map<Location, Pair<Set<Location>, Set<String>>> pylonMap = new ConcurrentHashMap<Location, Pair<Set<Location>, Set<String>>>();

    private SpawnManager() {
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.END) && dirty) {
            ConcurrentHashMap<Location, Set<String>> replace = new ConcurrentHashMap<Location, Set<String>>();
            pylonMap.values().forEach(pair -> ((Set)pair.getLeft()).forEach(location -> replace.merge((Location)location, (Set)pair.getRight(), Sets::union)));
            chunkMap = replace;
            dirty = false;
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        Level level = event.getWorld();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level = event.getEntity();
            if (level instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)level;
                int chunkX = SectionPos.m_175552_((double)entity.m_20185_());
                int chunkZ = SectionPos.m_175552_((double)entity.m_20189_());
                Location key = new Location((ResourceKey<Level>)level2.m_46472_(), BlockPos.f_121853_, chunkX, chunkZ);
                Set<String> filterSet = chunkMap.get(key);
                if (filterSet == null) {
                    return;
                }
                String registryId = Objects.toString(event.getEntity().m_6095_().getRegistryName(), "unregistered");
                if (filterSet.contains(registryId)) {
                    event.setCanceled(true);
                }
            }
        }
    }

    public static void register(ServerLevel level, BlockPos blockPos, Range range, Collection<String> filters) {
        if (filters.isEmpty()) {
            return;
        }
        Location pylon = Location.of(level, blockPos);
        Set<Location> locations = Location.chunkSet(level, blockPos, range);
        pylonMap.put(pylon, (Pair<Set<Location>, Set<String>>)Pair.of(locations, (Object)ImmutableSet.copyOf(filters)));
        dirty = true;
    }

    public static void unregister(ServerLevel level, BlockPos blockPos) {
        Location pylon = Location.of(level, blockPos);
        pylonMap.remove(pylon);
        dirty = true;
    }
}

