/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.util;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.permutated.pylons.ConfigManager;
import net.permutated.pylons.util.Location;

@Mod.EventBusSubscriber(modid="pylons")
public class ChunkManager {
    private static final Map<UUID, Location> loaded = new ConcurrentHashMap<UUID, Location>();
    private static final Map<UUID, Location> unloaded = new ConcurrentHashMap<UUID, Location>();

    private ChunkManager() {
    }

    @SubscribeEvent
    public static void beforeServerStopped(ServerStoppingEvent event) {
        loaded.clear();
        unloaded.clear();
    }

    @SubscribeEvent
    public static void afterServerStarted(ServerStartedEvent event) {
        loaded.clear();
        unloaded.clear();
    }

    @SubscribeEvent
    public static void onLoginEvent(PlayerEvent.PlayerLoggedInEvent event) {
        UUID uuid = event.getPlayer().m_142081_();
        if (uuid != null && unloaded.containsKey(uuid)) {
            ServerLevel level;
            Location location = unloaded.get(uuid);
            MinecraftServer server = event.getPlayer().m_20194_();
            if (location != null && server != null && (level = server.m_129880_(location.level())) != null) {
                ChunkManager.loadChunk(uuid, level, location.blockPos());
            }
        }
    }

    @SubscribeEvent
    public static void onLogoutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        UUID uuid = event.getPlayer().m_142081_();
        if (uuid != null && loaded.containsKey(uuid)) {
            ServerLevel level;
            Location location = loaded.get(uuid);
            MinecraftServer server = event.getPlayer().m_20194_();
            if (location != null && server != null && (level = server.m_129880_(location.level())) != null) {
                ChunkManager.unloadChunk(uuid, level, location.blockPos());
            }
        }
    }

    public static void loadChunk(UUID owner, ServerLevel level, BlockPos pos) {
        if (Boolean.TRUE.equals(ConfigManager.SERVER.infusionChunkloads.get()) && !loaded.containsKey(owner)) {
            Location location = Location.of(level, pos);
            unloaded.remove(owner, location);
            loaded.put(owner, location);
            ForgeChunkManager.forceChunk((ServerLevel)level, (String)"pylons", (BlockPos)pos, (int)location.chunkX(), (int)location.chunkZ(), (boolean)true, (boolean)false);
        }
    }

    public static void unloadChunk(UUID owner, ServerLevel level, BlockPos pos) {
        Location location = Location.of(level, pos);
        loaded.remove(owner, location);
        unloaded.put(owner, location);
        ForgeChunkManager.forceChunk((ServerLevel)level, (String)"pylons", (BlockPos)pos, (int)location.chunkX(), (int)location.chunkZ(), (boolean)false, (boolean)false);
    }

    public static void validateTickets(ServerLevel level, ForgeChunkManager.TicketHelper ticketHelper) {
        ticketHelper.getBlockTickets().keySet().forEach(arg_0 -> ((ForgeChunkManager.TicketHelper)ticketHelper).removeAllTickets(arg_0));
    }
}

