/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.tile;

import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.permutated.pylons.util.ChunkManager;
import net.permutated.pylons.util.Range;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractPylonTile
extends BlockEntity {
    public static final int SLOTS = 9;
    protected final ItemStackHandler itemStackHandler = new PylonItemStackHandler(9){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return AbstractPylonTile.this.isItemValid(stack);
        }
    };
    protected final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemStackHandler);
    protected UUID owner = null;
    protected String ownerName = null;
    private long lastTicked = 0L;
    int offset = 0;
    protected boolean shouldWork = true;
    protected final Range range = new Range(this.getRange());

    protected AbstractPylonTile(BlockEntityType<?> tileEntityType, BlockPos pos, BlockState state) {
        super(tileEntityType, pos, state);
    }

    protected abstract boolean isItemValid(ItemStack var1);

    protected boolean canAccessInventory() {
        return false;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (side == null || this.canAccessInventory())) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void dropItems() {
        AbstractPylonTile.dropItems(this.f_58857_, this.f_58858_, (IItemHandler)this.itemStackHandler);
    }

    public void removeChunkloads() {
        Level level;
        if (this.owner != null && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ChunkManager.unloadChunk(this.owner, serverLevel, this.m_58899_());
        }
    }

    public void m_7651_() {
        super.m_7651_();
        this.handler.invalidate();
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.m_6596_();
    }

    public boolean canAccess(Player player) {
        return Objects.equals(player.m_142081_(), this.owner) || this.owner == null || player.m_20310_(2);
    }

    public boolean canTick(int every) {
        long gameTime;
        long l = gameTime = this.f_58857_ != null ? this.f_58857_.m_46467_() : 0L;
        if (this.offset(gameTime) % (long)every == 0L && gameTime != this.lastTicked && this.shouldWork()) {
            this.lastTicked = gameTime;
            return true;
        }
        return false;
    }

    protected long offset(long gameTime) {
        if (this.offset == 0) {
            this.offset += ThreadLocalRandom.current().nextInt(0, 20);
        }
        return gameTime + (long)this.offset;
    }

    public abstract void tick();

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        AbstractPylonTile pylonTile;
        if (blockEntity instanceof AbstractPylonTile && (pylonTile = (AbstractPylonTile)blockEntity).shouldWork()) {
            pylonTile.tick();
        }
    }

    protected static void dropItems(@Nullable Level world, BlockPos pos, IItemHandler itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack itemstack = itemHandler.getStackInSlot(i);
            if (itemstack.m_41613_() <= 0 || world == null) continue;
            Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)itemstack);
        }
    }

    public String getOwnerName() {
        String lastKnown = this.owner == null ? null : UsernameCache.getLastKnownUsername((UUID)this.owner);
        return StringUtils.defaultString((String)lastKnown, (String)"unknown");
    }

    public void updateContainer(FriendlyByteBuf packetBuffer) {
        String username = this.getOwnerName();
        packetBuffer.m_130064_(this.f_58858_);
        packetBuffer.writeInt(username.length());
        packetBuffer.m_130070_(username);
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128365_("inv", (Tag)this.itemStackHandler.serializeNBT());
        tag.m_128365_("range", (Tag)this.range.serializeNBT());
        this.writeFields(tag);
    }

    private void writeFields(CompoundTag tag) {
        tag.m_128379_("enabled", this.shouldWork);
        if (this.owner != null) {
            tag.m_128362_("owner", this.owner);
        }
    }

    public void m_142466_(CompoundTag tag) {
        this.itemStackHandler.deserializeNBT(tag.m_128469_("inv"));
        this.range.deserializeNBT(tag.m_128469_("range"));
        this.readFields(tag);
        super.m_142466_(tag);
    }

    private void readFields(@Nullable CompoundTag tag) {
        if (tag != null && tag.m_128441_("enabled")) {
            this.shouldWork = tag.m_128471_("enabled");
        }
        if (tag != null && tag.m_128403_("owner")) {
            this.owner = tag.m_128342_("owner");
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128365_("range", (Tag)this.range.serializeNBT());
        this.writeFields(tag);
        return tag;
    }

    public void handleUpdateTag(@Nullable CompoundTag tag) {
        if (tag != null) {
            this.range.deserializeNBT(tag.m_128469_("range"));
        }
        this.readFields(tag);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public boolean shouldWork() {
        return this.shouldWork;
    }

    public void handleWorkPacket() {
        if (this.f_58857_ != null) {
            this.shouldWork = !this.shouldWork;
            this.m_6596_();
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
            if (!this.shouldWork) {
                this.removeChunkloads();
            }
        }
    }

    protected byte[] getRange() {
        return new byte[]{1};
    }

    public int getSelectedRange() {
        return this.range.get();
    }

    public void handleRangePacket() {
        if (this.getRange().length > 1 && this.f_58857_ != null) {
            this.range.next();
            this.m_6596_();
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public class PylonItemStackHandler
    extends ItemStackHandler {
        public PylonItemStackHandler(int size) {
            super(size);
        }

        protected void onContentsChanged(int slot) {
            AbstractPylonTile.this.m_6596_();
        }
    }
}

