/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.item;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.LogicalSide;
import net.permutated.pylons.ModRegistry;
import net.permutated.pylons.util.TranslationKey;

public class MobFilterCard
extends Item {
    public MobFilterCard() {
        super(new Item.Properties().m_41487_(1).m_41491_(ModRegistry.CREATIVE_TAB).setNoRepair());
    }

    public static void onPlayerInteractEvent(PlayerInteractEvent.EntityInteract event) {
        ItemStack itemStack = event.getItemStack();
        if (itemStack.m_41720_() instanceof MobFilterCard && event.getTarget() instanceof LivingEntity) {
            if (event.getSide() == LogicalSide.SERVER) {
                CompoundTag tag = itemStack.m_41698_("pylons");
                tag.m_128359_("registry", Objects.toString(event.getTarget().m_6095_().getRegistryName(), "unregistered"));
                tag.m_128359_("name", event.getTarget().m_6095_().m_20675_());
                event.setCancellationResult(InteractionResult.SUCCESS);
            } else {
                event.setCancellationResult(InteractionResult.CONSUME);
            }
            event.setCanceled(true);
        }
    }

    public boolean m_5812_(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("pylons");
        return tag != null && tag.m_128441_("registry");
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, level, tooltip, flagIn);
        CompoundTag tag = stack.m_41737_("pylons");
        if (tag != null) {
            String name = tag.m_128461_("name");
            tooltip.add((Component)new TranslatableComponent(name).m_130940_(ChatFormatting.BLUE));
            tooltip.add((Component)new TextComponent(""));
            tooltip.add((Component)this.translate("insert1"));
            tooltip.add((Component)this.translate("insert2"));
        } else {
            tooltip.add((Component)this.translate("no_mob"));
        }
    }

    protected MutableComponent translate(String key) {
        return new TranslatableComponent(TranslationKey.tooltip(key)).m_130940_(ChatFormatting.GRAY);
    }

    protected TranslatableComponent translate(String key, Object ... values) {
        return new TranslatableComponent(TranslationKey.tooltip(key), values);
    }
}

