/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons;

import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.permutated.pylons.ConfigManager;
import net.permutated.pylons.ModRegistry;
import net.permutated.pylons.block.AbstractPylonBlock;
import net.permutated.pylons.client.ClientSetup;
import net.permutated.pylons.item.MobFilterCard;
import net.permutated.pylons.item.PlayerFilterCard;
import net.permutated.pylons.network.NetworkDispatcher;
import net.permutated.pylons.util.ChunkManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="pylons")
public class Pylons {
    public static final String MODID = "pylons";
    public static final Logger LOGGER = LogManager.getLogger();

    public Pylons() {
        LOGGER.info("Registering mod: {}", (Object)MODID);
        ModRegistry.register();
        NetworkDispatcher.register();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ConfigManager.SERVER_SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onCommonSetupEvent);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetupEvent);
        MinecraftForge.EVENT_BUS.addListener(PlayerFilterCard::onPlayerInteractEvent);
        MinecraftForge.EVENT_BUS.addListener(MobFilterCard::onPlayerInteractEvent);
        MinecraftForge.EVENT_BUS.addListener(Pylons::onBlockBreakEvent);
    }

    public void onCommonSetupEvent(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> ForgeChunkManager.setForcedChunkLoadingCallback((String)MODID, ChunkManager::validateTickets));
    }

    public void onClientSetupEvent(FMLClientSetupEvent event) {
        ClientSetup.register();
    }

    public static void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        BlockEntity tileEntity;
        if (event.getState().m_60734_() instanceof AbstractPylonBlock && !AbstractPylonBlock.canAccessPylon(tileEntity = event.getWorld().m_7702_(event.getPos()), event.getPlayer())) {
            event.setCanceled(true);
        }
    }
}

