/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber
public class ConfigManager {
    public static final String CATEGORY_EXPULSION = "expulsion_pylon";
    public static final String CATEGORY_INFUSION = "infusion_pylon";
    public static final String CATEGORY_HARVESTER = "harvester_pylon";
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;

    private ConfigManager() {
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (ServerConfig)specPair.getLeft();
    }

    public static class ServerConfig {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> expulsionAllowedDimensions;
        public final ForgeConfigSpec.IntValue expulsionWorldSpawnRadius;
        public final ForgeConfigSpec.IntValue infusionMinimumDuration;
        public final ForgeConfigSpec.IntValue infusionRequiredDuration;
        public final ForgeConfigSpec.IntValue infusionAppliedDuration;
        public final ForgeConfigSpec.BooleanValue infusionChunkloads;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> infusionAllowedEffects;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> infusionDeniedEffects;
        public final ForgeConfigSpec.IntValue harvesterWorkDelay;
        public final ForgeConfigSpec.BooleanValue harvesterRequiresTool;
        public final ForgeConfigSpec.BooleanValue harvesterCanBeAutomated;

        ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.push(ConfigManager.CATEGORY_EXPULSION);
            this.expulsionAllowedDimensions = builder.comment("Which dimensions the Expulsion Pylon is allowed to operate in.").defineListAllowEmpty(List.of("expulsionAllowedDimensions"), () -> List.of("minecraft:overworld"), s -> {
                String string;
                return s instanceof String && (string = (String)s).matches("^\\w+:\\w+$");
            });
            this.expulsionWorldSpawnRadius = builder.comment(new String[]{"The radius around the world spawn where the pylon is not allowed to operate.", "By default this uses the world spawn radius (/gamerule spawnRadius).", "This config will only take effect if it is larger than the world spawn radius."}).defineInRange("expulsionWorldSpawnRadius", 1, 1, 512);
            builder.pop();
            builder.push(ConfigManager.CATEGORY_INFUSION);
            this.infusionMinimumDuration = builder.comment(new String[]{"The minimum effect duration (in seconds) that can be used for Potion Filters.", "This defaults to 60 seconds to prevent unintended interactions", "with other mods that add persistent potion effects at low durations."}).defineInRange("infusionMinimumDuration", 60, 1, 3600);
            this.infusionRequiredDuration = builder.comment(new String[]{"The total duration (in seconds) required before a Potion Filter can be used.", "By default this is 3600 seconds/1 hour, which is equivalent to 7.5 vanilla extended potions."}).defineInRange("infusionRequiredDuration", 3600, 1, 28800);
            this.infusionAppliedDuration = builder.comment(new String[]{"The max duration of effects (in seconds) applied to the player.", "The duration is refreshed up to this amount every 60 ticks."}).defineInRange("infusionAppliedDuration", 20, 5, 60);
            this.infusionChunkloads = builder.comment(new String[]{"Whether the Infusion Pylon chunkloads itself.", "This is limited to one pylon per player, while the player is online."}).define("infusionChunkloads", true);
            this.infusionAllowedEffects = builder.comment(new String[]{"Effects that may be used in the Infusion Pylon.", "List may include either effect IDs (like `minecraft:strength`) or an entire namespace (like `minecraft`).", "If the list is empty, then all effects will be allowed except for those specifically denied."}).defineListAllowEmpty(List.of("infusionAllowedEffects"), ArrayList::new, s -> {
                String string;
                return s instanceof String && (string = (String)s).matches("^\\w+(:\\w+)?$");
            });
            this.infusionDeniedEffects = builder.comment(new String[]{"Effects that may not be used in the Infusion Pylon.", "This list will override the allowed effect list."}).defineListAllowEmpty(List.of("infusionDeniedEffects"), ArrayList::new, s -> {
                String string;
                return s instanceof String && (string = (String)s).matches("^\\w+(:\\w+)?$");
            });
            builder.pop();
            builder.push(ConfigManager.CATEGORY_HARVESTER);
            this.harvesterWorkDelay = builder.comment("Delay between harvest attempts (in ticks).").defineInRange("harvesterWorkDelay", 60, 10, 120);
            this.harvesterRequiresTool = builder.comment(new String[]{"Whether the harvester requires a hoe to work.", "If enabled, it will use 1 durability per harvest action"}).define("harvesterRequiresTool", true);
            this.harvesterCanBeAutomated = builder.comment(new String[]{"Whether the harvester can have tools piped in to automate it.", "By default, unbreakable tools are required for full automation."}).define("harvesterCanBeAutomated", false);
            builder.pop();
        }
    }
}

