/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker.managers;

import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CrTIngredientUtil;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.actions.AbstractActionRemoveMultipleOutputs;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.random.Percentaged;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="mods/immersiveengineering/Crusher")
@ZenCodeType.Name(value="mods.immersiveengineering.Crusher")
public class CrusherRecipeManager
implements IRecipeManager<CrusherRecipe> {
    public RecipeType<CrusherRecipe> getRecipeType() {
        return CrusherRecipe.TYPE;
    }

    public void remove(IIngredient output) {
        this.removeRecipe(output);
    }

    @ZenCodeType.Method
    public void removeRecipe(IIngredient output) {
        CraftTweakerAPI.apply((IAction)new AbstractActionRemoveMultipleOutputs<CrusherRecipe>((IRecipeManager)this, output){

            @Override
            public List<ItemStack> getAllOutputs(CrusherRecipe recipe) {
                ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
                itemStacks.add((ItemStack)recipe.output.get());
                for (StackWithChance secondaryOutput : recipe.secondaryOutputs) {
                    itemStacks.add((ItemStack)secondaryOutput.stack().get());
                }
                return itemStacks;
            }
        });
    }

    @SafeVarargs
    @ZenCodeType.Method
    public final void addRecipe(String recipePath, IIngredient input, int energy, IItemStack mainOutput, Percentaged<IItemStack> ... additionalOutputs) {
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", recipePath);
        ItemStack result = mainOutput.getInternal();
        Ingredient ingredient = input.asVanillaIngredient();
        CrusherRecipe recipe = new CrusherRecipe(resourceLocation, IESerializableRecipe.of(result), ingredient, energy);
        for (Percentaged<IItemStack> additionalOutput : additionalOutputs) {
            StackWithChance stackWithChance = CrTIngredientUtil.getStackWithChance(additionalOutput);
            recipe.addToSecondaryOutput(stackWithChance);
        }
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (Recipe)recipe, null));
    }
}

